<div class="c7">
    <form class="ui form" action="<?php echo e(route('super_admin.unity.create.center')); ?>" method="post">
        <?php echo e(csrf_field()); ?>

        <h2 class="ui dividing header">Create Entrance Examination Center</h2>
        <div class="three fields">
            <div class="field" class="field-lga">
                <label>Local Govt Area.</label>
                <div class="ui fluid search selection dropdown" id="wrap-slgas">
                <input type="hidden" name="lga_id" value="<?php echo e(old('lga_id')); ?>">
                <i class="dropdown icon"></i>
                <div class="default text">Local Govt. Area</div>
                <div class="menu" class="state-lga">
                    <?php  $ngstate_lgas = App\OndoLGA::all();   ?>
                    <?php foreach($ngstate_lgas as $ngstateLGA): ?>
                    <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                    <?php endforeach; ?>
                </div>
                </div>
            </div>
            <div class="field">
                <label>Center Name.</label>
                <div class="ui input">
                    <input type="text" name="name" placeholder="Center Name">
                </div>
            </div>
            <div class="field">
                <label>Max No of Student.</label>
                <div class="ui input">
                    <input type="number" name="max_count" placeholder="Max No of Student">
                </div>
            </div>
            <div class="field">
                <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">Create Center</button>
            </div>
        </div>
    </form>
    <br>
    <hr>
    <br>
    <form class="ui form delete--center" action="<?php echo e(route('super_admin.unity.delete.center')); ?>" method="post">
        <?php echo e(csrf_field()); ?>

        <h2 class="ui dividing header">Delete Entrance Examination Center</h2>
        <div class="three fields">
            <div class="field" class="field-lga">
                <label>Local Govt Area.</label>
                <div class="ui fluid search selection dropdown">
                <input type="hidden" name="lga_id" class="lgaSelect" value="<?php echo e(old('lga_id')); ?>" data-href="<?php echo e(url('/do-ajax/unity-get-center')); ?>">
                <i class="dropdown icon"></i>
                <div class="default text">Local Govt. Area</div>
                <div class="menu" class="state-lga">
                    <?php  $ngstate_lgas = App\OndoLGA::all();   ?>
                    <?php foreach($ngstate_lgas as $ngstateLGA): ?>
                    <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                    <?php endforeach; ?>
                </div>
                </div>
            </div>
            <div class="field centers">
                <label>Center Name.</label>
                <div class="ui fluid search selection dropdown Centers">
                <input type="hidden" name="center_id" value="<?php echo e(old('center_id')); ?>">
                <i class="dropdown icon"></i>
                <div class="default text">Center Name.</div>
                <div class="menu">
                </div>
                </div>
            </div>
            <div class="field">
                <button class="fluid ui button red" type="submit" style="color:white;margin-top:24px;">Delete Center</button>
            </div>
        </div>
    </form>
    <br>
    <hr>
    <br>
    <form class="ui form horizontal divider" action="<?php echo e(route('super_admin.unity.view.centers')); ?>" method="post">
        <?php echo e(csrf_field()); ?>

        <input type="hidden" name="type" value="center">
        <div class="two fields" style="width:700px;">
            <div class="field">
                <div class="ui fluid search selection dropdown">
                <input type="hidden" required name="lga_id" value="<?php echo e(old('lga_id')); ?>">
                <i class="dropdown icon"></i>
                <div class="default text">Select Local Govt. Area</div>
                <div class="menu" class="state-lga">
                    <?php  $ngstate_lgas = App\OndoLGA::all();   ?>
                    <?php foreach($ngstate_lgas as $ngstateLGA): ?>
                    <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                    <?php endforeach; ?>
                </div>
                </div>
            </div>
            <div class="field">
                <button class="fluid ui button blue" type="submit" style="color:white;">View Centers</button>
            </div>
        </div>
    </form>
    <table class="ui celled table">
        <thead>
            <tr>
            <th>
                <div class="ui ribbon label">S/N</div>
            </th>
            <th>
                <div class="ui ribbon label">LGA</div>
            </th>
            <th>
                <div class="ui ribbon label">Center Name</div>
            </th>
            <th>
                <div class="ui ribbon label">Center Halls</div>
            </th>
            <th>
                <div class="ui ribbon label">Students In Center</div>
            </th>
        </tr>
        </thead>
        <tbody>
            <?php if(isset($lgaCenters) && !empty($lgaCenters)): ?>
                <?php $__empty_1 = true; foreach($lgaCenters as $center): $__empty_1 = false; ?>
                <tr style="text-transform:capitalize;">
                <td><?php echo e($center->id); ?></td>
                <td ><?php echo e($center->ondo_lga->name); ?></td>
                <td><?php echo e($center->name); ?></td>
                <td>
                    <?php  $halls = $center->hall  ?>
                    <ul>
                        <?php foreach($halls as $hall): ?>
                        <li><?php echo e($hall->name); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </td>
                <td><?php echo e(App\UnityHallAllocation::where('school_center_id', $center->id)->get()->count()); ?> Students</td>
                </tr>
                <?php endforeach; if ($__empty_1): ?>
                <tr>
                    <th colspan="7">
                        <div class="ui icon negative message">
                        <i class="info circle icon"></i>
                        <div class="content">
                            <div class="header">
                            Sorry, No Record can be found.
                            </div>
                        </div>
                        </div>
                    </th>
                </tr>
                <?php endif; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>