<?php $__env->startSection('content'); ?>
<br>
<section class="ui raised segment" style="max-width: 1200px; margin: 20px auto;">
	<h2 class="ui horizontal divider cap header" style="color:#dc4900;">
	  ID Card Requests
	</h2>
	<div class="ui statistics">
	  <div class="statistic">
	    <div class="value">
	      <?php echo e(App\StudentIDCardRequest::where('school_id', $school->id)->get()->count()); ?>

	    </div>
	    <div class="label">
	    	All ID Card Request
	    </div>
	  </div>
	  <div class="statistic">
	    <div class="value">
	      <?php echo e(App\StudentIDCardRequest::where('school_id', $school->id)->where('is_verified', false)->get()->count()); ?>

	    </div>
	    <div class="label">
	    	Pending ID Card Request
	    </div>
	  </div>
	  <div class="statistic">
	    <div class="value">
	      <?php echo e(App\StudentIDCardRequest::where('school_id', $school->id)->where('is_verified', true)->get()->count()); ?>

	    </div>
	    <div class="label">
	    	Approved ID Card Request
	    </div>
	  </div>
	</div>
	<br>
	<!-- ui stackable equal height stackable grid -->
	<div class="grid">
		<div class="shadowundertop"></div>
		<div class="row">
			<div class="c8">
                <div class="ui grid">
                    <div class="four wide column">
                        <div class="ui vertical fluid tabular menu">
                        <a href="<?php echo e(url('admin/school-id-card-request')); ?>" class="item <?php if(!isset($_GET['action']) || $_GET['action'] == ''): ?> active <?php endif; ?>">
                        	Request ID Card
                        </a>
                        <a href="<?php echo e(url('admin/school-id-card-request?action=cancle_request')); ?>" class="item <?php if(isset($_GET['action']) && $_GET['action'] == 'cancle_request'): ?> active <?php endif; ?>">
                            Cancle ID Card Request
                        </a>
                        <a href="<?php echo e(url('admin/school-id-card-request?action=pending_request')); ?>" class="item <?php if(isset($_GET['action']) && $_GET['action'] == 'pending_request'): ?> active <?php endif; ?>">
                            View Pending ID Card Request
                        </a>
                        <a href="<?php echo e(url('admin/school-id-card-request?action=approved_request')); ?>" class="item <?php if(isset($_GET['action']) && $_GET['action'] == 'approved_request'): ?> active <?php endif; ?>">
                            View Approved ID Card Request
                        </a>
                        </div>
                    </div>
                    <div class="twelve wide stretched column">
                        <div class="ui segment">
                            <?php if(isset($_GET['action']) && $_GET['action'] == 'cancle_request'): ?>
                                <?php  $pending_requests = App\StudentIDCardRequest::where('school_id', $school->id)->where('is_verified', false)->get();  ?>
                                <?php if($pending_requests->count() > 0): ?>
                                <form method="post" action="" class="form-horizontal global_form">
                                    <?php echo e(csrf_field()); ?>

                                    <input type="hidden" name="school_id" value="<?php echo e(auth('admin')->user()->school_id); ?>">
                                    <input type="hidden" name="payer_id" value="<?php echo e(auth('admin')->user()->id); ?>">
                                    <input type="hidden" name="type" value="cancle">
                                    <div class="form-group">
                                        <div class="col-md-9">
                                            <div class="multiple_select_holder" style="height: 50vh;overflow-y: auto;">
                                                <table class="ui compact celled definition table">
                                                    <thead>
                                                        <tr>
                                                        <th></th>
                                                        <th>Full Name</th>
                                                        <th>Registration Number</th>
                                                        <th>Status</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php foreach($pending_requests as $pending_request): ?>
                                                        <tr>
                                                            <td class="collapsing">
                                                                <div class="ui fitted slider checkbox">
                                                                <input type="checkbox"  name="student_id[]" value="<?php echo e($pending_request->student->id); ?>"> <label></label>
                                                                </div>
                                                            </td>
                                                            <td><?php echo e($pending_request->student->surname.' '.$pending_request->student->firstname.' '.$pending_request->student->middlename); ?></td>
                                                            <td><?php echo e($pending_request->student->regnum); ?></td>
                                                            <td><span style="color:grey;">Pending</span></td>  
                                                        </tr>
                                                    <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    
                                    <br>
                                    <br>
                                    <div class="form-group text-center m-t-30">
                                        <div class="col-md-4 col-xs-offset-4">
                                            <input type="submit" class="ui small red button" name="form_submit" value="Cancle Selected Requests" />
                                        </div>
                                    </div>
                                </form>
                                <?php else: ?>
                                <div class="ui negative message">
									<i class="close icon"></i>
									<div class="header">
										No pending request available
									</div>
									<p>
									    <a href="<?php echo e(url('admin/school-id-card-request')); ?>" class="item <?php if(!isset($_GET['action']) || $_GET['action'] == ''): ?> active <?php endif; ?>">
                                        	Click
                                        </a> to create ID Card Requests
									</p>
								</div>
                                <?php endif; ?>
                            <?php elseif(isset($_GET['action']) && $_GET['action'] == 'pending_request'): ?>
                                <?php  $pending_requests = App\StudentIDCardRequest::where('school_id', $school->id)->where('is_verified', false)->get();  ?>
	                            <div class="ui feed">
	                            <?php $__empty_1 = true; foreach($pending_requests as $pending_request): $__empty_1 = false; ?>
								  <div class="event">
								    <div class="label">
								      <img src="<?php echo e(url_public($pending_request->student->passport)); ?>">
								    </div>
								    <div class="content">
								      <div class="summary">
								        <?php echo e($pending_request->student->surname); ?> <?php echo e($pending_request->student->firstname); ?> <?php echo e($pending_request->student->middlename); ?>

								      </div>
								      <div class="date">
								        <small>requested by <?php echo e(strtolower($pending_request->admin->username)); ?></small>
								      </div>
								      <div class="extra text" style="pointer-events: none;">
								            <div class="ui labeled button" tabindex="0">
                                              <div class="ui yellow button">
                                                <i class="refresh icon"></i> Pending
                                              </div>
                                              <a class="ui basic yellow left pointing label">
                                                <?php echo e($pending_request->created_at->diffForHumans()); ?>

                                              </a>
                                            </div>
								      </div>
								    </div>
								  </div>
								<?php endforeach; if ($__empty_1): ?>
									<div class="ui icon negative message">
									  <i class="info circle icon"></i>
									  <div class="content">
									    <div class="header">
									    Sorry, No Record can be found.
									  	</div>
									  </div>
									</div>
								<?php endif; ?>
								</div>
                            <?php elseif(isset($_GET['action']) && $_GET['action'] == 'approved_request'): ?>
                                <?php  $approved_requests = App\StudentIDCardRequest::where('school_id', $school->id)->where('is_verified', true)->get();  ?>
	                            <div class="ui feed">
	                            <?php $__empty_1 = true; foreach($approved_requests as $approved_request): $__empty_1 = false; ?>
								  <div class="event">
								    <div class="label">
								      <img src="<?php echo e(url_public($approved_request->student->passport)); ?>">
								    </div>
								    <div class="content">
								      <div class="summary">
								        <?php echo e($approved_request->student->surname); ?> <?php echo e($approved_request->student->firstname); ?> <?php echo e($approved_request->student->middlename); ?>

								      </div>
								      <div class="date">
								        <small>requested by <?php echo e(strtolower($approved_request->admin->username)); ?></small>
								      </div>
								      <div class="extra text" style="pointer-events: none;">
								            <div class="ui labeled button" tabindex="0">
                                              <div class="ui green button">
                                                <i class="refresh icon"></i> Approved
                                              </div>
                                              <a class="ui basic green left pointing label">
                                                <?php echo e($approved_request->created_at->diffForHumans()); ?>

                                              </a>
                                            </div>
								      </div>
								    </div>
								  </div>
								<?php endforeach; if ($__empty_1): ?>
									<div class="ui icon negative message">
									  <i class="info circle icon"></i>
									  <div class="content">
									    <div class="header">
									    Sorry, No Record can be found.
									  	</div>
									  </div>
									</div>
								<?php endif; ?>
								</div>
                            <?php else: ?>
                            <div class="new">
                                <div class="ui yellow message">
									<i class="close icon"></i>
									<div class="header">
										Please note!
									</div>
									<p>
										Only students with passport can an ID Card request be made for
									</p>
								</div>
                                <form class="ui form" action="<?php echo e(route('admin.school.wallet.student.search')); ?>" onsubmit="event.preventDefault(); searchStudents(this);" method="post" enctype="multipart/form-data">
                        			<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                        		  <h2 class="ui dividing header">Search Students</h2>
                        		  <div class="five fields">
                        	      <div class="field">
                        	        <label>Session</label>
                        	        <div class="ui fluid search selection dropdown">
                        	          <input type="hidden" name="session" value="<?php echo e(old('session')); ?>" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Session</div>
                        	          <div class="menu">
                        	            <?php for($i = 2010; $i <= (date('Y') + 1) ; $i++): ?>
                        	             <div class="item" data-value="<?php echo e($i); ?>"><?php echo e($i); ?>/<?php echo e($i+1); ?></div>
                        	            <?php endfor; ?>
                        	          </div>
                        	        </div>
                        	      </div>
                        	      <div class="field">
                        	        <label>Term</label>
                        	        <div class="ui fluid search selection dropdown">
                        	          <input type="hidden" name="term" value="<?php echo e(old('term')); ?>" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Term</div>
                        	          <div class="menu">
                        	             <div class="item" data-value="First"> First Term </div>
                        	             <div class="item" data-value="Second"> Second Term </div>
                        	             <div class="item" data-value="Third"> Third Term </div>
                        	          </div>
                        	        </div>
                        	      </div>
                        	      
                        	      <div class="field">
                        	        <label>Class</label>
                        	        <div class="ui fluid search selection dropdown" id="classes-dropdown">
                        	          <input type="hidden" name="class_id" value="<?php echo e(old('class_id')); ?>" data-href="<?php echo e(url('/do-ajax/class')); ?>" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Class</div>
                        	          <div class="menu">
                        	            <?php foreach($classes as $class): ?>
                        	             <div class="item" data-value="<?php echo e($class->id); ?>"><?php echo e($class->class_name); ?></div>
                        	            <?php endforeach; ?>
                        	          </div>
                        	        </div>
                        	      </div>
                        	      <div class="field" id="field-arms">
                        	        <label>Class Arm</label>
                        	        <div class="ui fluid search selection dropdown">
                        	          <input type="hidden" name="class_arm_id" value="<?php echo e(old('class_arm_id')); ?>" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Class Arm</div>
                        	          <div class="menu" id="class-arms">
                        	            <?php if(!empty(old('class_id'))): ?>
                        	                <?php foreach(getClassArms(old('class_id')) as $class_arm): ?>
                        	                 <div class="item" data-value="<?php echo e($class_arm->id); ?>"><?php echo e($class_arm->class_arm); ?></div>
                        	                <?php endforeach; ?>
                        	              <?php else: ?>
                        	                 <div class="item" data-value="">Select Class Arm</div>
                        	              <?php endif; ?>
                        	            
                        	          </div>
                        	        </div>
                        	      </div>
                        	      <div class="field">
                        	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Students</button>
                        	      </div>
                        
                        	    </div>
                        		  
                        		</form>
                                <br>
                                <form method="post" action="" class="form-horizontal global_form">
                                    <?php echo e(csrf_field()); ?>

                                    <input type="hidden" name="school_id" value="<?php echo e(auth('admin')->user()->school_id); ?>">
                                    <input type="hidden" name="payer_id" value="<?php echo e(auth('admin')->user()->id); ?>">
                                    <input type="hidden" name="type" value="create">
                                    <div class="form-group">
                                        <div class="col-md-9">
                                            <div class="multiple_select_holder" style="height: 50vh;overflow-y: auto;">
                                                <table class="ui compact celled definition table">
                                                    <thead>
                                                        <tr>
                                                        <th></th>
                                                        <th>Full Name</th>
                                                        <th>Registration Number</th>
                                                        <th>Passport</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="studentsTable">
                                                        
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="has_passport"></div>
                                    <br>
                                    
                                    <br>
                                    <br>
                                    <div class="form-group text-center m-t-30">
                                        <div class="col-md-4 col-xs-offset-4">
                                            <input type="submit" class="ui small blue button" name="form_submit" value="Request ID Card For Selected Students" />
                                        </div>
                                    </div>
                                </form>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
			</div>
		</div>	
	</div>
</section>
<style>
.ext{
    width: 100% !important;
}
.ext .card{
    width: 100% !important;
}
.ext .card .item{
    text-align: left;
    padding: 13px;
}
.ext .card .content{
    text-align: right;
    float: right;
}
</style>
<script>
function searchStudents(obj){
    var form,table,data,route,term;
    form = $(obj);
    term = form.find('input[name=term]').val();
    table = $('#studentsTable');
    $('.multiple_select_holder .field.loading').remove();
    $('.multiple_select_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

    // throw ajax
    // var token = "<?php echo e(csrf_token()); ?>";
    route = form.attr('action');
    data = form.serialize();
    $.ajax({
        url: route,
        type: 'POST',
        data: data,
        success: function(response){
            console.log(response);
            table.html('')
            $.each(response,  function(index, value){
                $item = '<tr>';
                $item += '<td class="collapsing">';
                $item += '<div class="ui fitted slider checkbox">';
                $item += '<input type="checkbox"  name="student_id[]" value="'+value.id+'"> <label></label>';
                $item += '</div>';
                $item += '</td>';
                $item += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
                $item += '<td>'+value.regnum+'</td>';
                if($('div.has_passport').length){
                    $item += '<td><img src="https://odsgmoe.com/eportal/public'+value.passport+'" style="height:100px;"></td>';    
                }
                $item += '</tr>';

                table.append($item);
            });
            $('.hidden__term__input').remove();
            $('.multiple_select_holder').append('<input type="hidden" name="term" value="'+term+'" class="hidden__term__input">');
            $('.multiple_select_holder .field.loading').remove();
        },
        error: function(error){
            console.error(error);
            table.html('');
            $('.multiple_select_holder .field.loading').remove();
        }
    });
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>