<?php $__env->startSection('content'); ?>
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">

		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  Generate Examination Scratch Card
		</h2>
	<?php if(auth('super_admin')->user()->can('create-scratch-card')): ?>
		<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	  <form action="<?php echo e(route('super_admin.generate.exam_scratch_card')); ?>" method="post" class="ui form">
		<div class="four fields">
		<?php echo e(csrf_field()); ?>

	      
	      <div class="field">
	        <label>Number of Scratch Card</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="iteration" value="<?php echo e(old('iteration')); ?>"  >
	          <i class="dropdown icon"></i>
	          <div class="default text">Select Number of Scratch Card</div>
	          <div class="menu">
	            <?php foreach($iterations as $iteration): ?>
	             <div class="item" data-value="<?php echo e($iteration); ?>"><?php echo e($iteration); ?></div>
	            <?php endforeach; ?>
	          </div>
	        </div>
	      </div>

	      <div class="field">
	        <label>Exam Card</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="exam_type" value="<?php echo e(old('exam_type')); ?>"  >
	          <i class="dropdown icon"></i>
	          <div class="default text">Select Exam Type</div>
	          <div class="menu">
	            <?php foreach($exam_types as $exam_type): ?>
	             <div class="item" data-value="<?php echo e(str_replace(' ', '_', strtolower($exam_type))); ?>"><?php echo e($exam_type); ?></div>
	            <?php endforeach; ?>
	          </div>
	        </div>
	      </div>

	      <div class="field">
	        <label>Number of students for a card </label>
	        <input type="number" name="multiple" value="<?php echo e(old('multiple')); ?>" placeholder="Number of Student per Card">
	      </div>

	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white; margin-top:24px;">Generate Exam Scratch Cards</button>
	      </div>
	     </div>
	    </form>
	 <?php endif; ?>
	   <form action="<?php echo e(route('super_admin.delete.exam_scratch_card')); ?>" method="post" class="ui form">
	   <?php echo e(csrf_field()); ?>

	   <input type="hidden" name="_method" value="delete">
		<table class="ui celled table">
		  <thead>
		    <tr>
			    <th>
			    	S/N
			    </th>
			    <th>
			    	Serial Number
			    </th>
			    <th>
			    	Pin
			    </th>
			    <th>
			    	Exam Number
			    </th>
			    <th>
			    	Exam Type
			    </th>
			    <th>
			    	Students per Card
			    </th>
			    <th >
			    	Select Cards
			    	<div class="ui toggle checkbox check-all">
						<input type="checkbox" class="">
						<label>Select All</label>
					</div>
			    </th>
			 </tr>
		  </thead>
		  <tbody>
		  <?php  $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $vouchers->perPage()  ?>
		  	<?php $__empty_1 = true; foreach($vouchers as $voucher): $__empty_1 = false; ?>
		    <tr>
		      <td><?php echo e(++$counter); ?></td>
		      <td><?php echo e($voucher->serial); ?></td>
		      <td><?php echo e($voucher->pin); ?></td>
		      <?php if($voucher->regnum !== NULL): ?>
				<td><?php echo e($voucher->regnum); ?></td>	
		      <?php else: ?>
		      <td><?php echo e(empty($voucher->school_id) || $voucher->school_id === NULL ? 'Not Used' : $voucher->school->name); ?></td>
		      <?php endif; ?>
		      <td><?php echo e(str_replace('_', ' ', ucwords($voucher->exam_type))); ?></td>
		      <td><?php echo e($voucher->multiple); ?></td>
		      <td class="std-view">
			     <div class="ui toggle checkbox studentID">
					<input type="checkbox" name="scratch_cards[]" value="<?php echo e($voucher->id); ?>"><label></label>
				</div>
			  </td>
		    </tr>
		   <?php endforeach; if ($__empty_1): ?>
			<tr>
				<th colspan="7">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  </tbody>
		  <tfoot>
		  <?php if($vouchers->count() > 0 && auth('super_admin')->user()->can('delete-scratch-card')): ?>
		  	<tr>
		  		<td colspan="7"><button class="fluid ui disabled scratch-card button" type="submit" style="background-color: #f75a0c; color:white;">Delete Scratch Cards</button></td>
		  	</tr>
		  <?php endif; ?>
		  	<tr>
		  		<td colspan="7">
		  			<?php echo $__env->make('pagination.default', ['paginator' => $vouchers], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		  		</td>
		  	</tr>
		  </tfoot>
		</table>
		
	</form>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>