<?php $__env->startSection('content'); ?>

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
		<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		<?php echo $__env->make('partial.flash-error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		<form class="ui form" action="<?php echo e(route('super_admin.view.student-for-id-card.post')); ?>" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
		  <h2 class="ui dividing header">Search Student For ID Card Generation</h2>
		  <div class="three fields">
		  <div class="field states">
            <label>State</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" <?php if(!empty(old('state_id'))): ?>
                  value="<?php echo e(old('state_id')); ?>"
                <?php else: ?>
                  value="<?php echo e($ngstate->id); ?>"
                <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                 <div class="item" data-value="<?php echo e($ngstate->id); ?>"><?php echo e($ngstate->name); ?></div>
              </div>
            </div>
          </div>
          <div class="field" id="field-lga">
            <label>Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="<?php echo e(old('lga_id')); ?>" data-href="<?php echo e(url('/do-ajax/school')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Local Govt. Area</div>
              <div class="menu" id="state-lga">
                <?php foreach($ngstate_lgas as $ngstateLGA): ?>
                 <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>

          <div class="field" id="field-school">
            <label>School</label>
            <div class="ui fluid search selection dropdown" id="wrap-schools">
              <input type="hidden" name="school" value="<?php echo e(old('school')); ?>" data-href="<?php echo e(url('/do-ajax/classes')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Schools</div>
              <div class="menu" id="school-options-handler">
                <?php if(!empty(old('school'))): ?>
                    <?php foreach(getSchools(old('school')) as $school): ?>
                     <div class="item" data-value="<?php echo e($school->id); ?>"><?php echo e($school->name); ?></div>
                    <?php endforeach; ?>
                  <?php else: ?>
                     <div class="item" data-value="">Schools</div>
                  <?php endif; ?>
              </div>
            </div>
          </div>
		  </div>
		  <div class="five fields">
	      <div class="field">
	        <label>Session</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="session" value="<?php echo e(old('session')); ?>">
	          <i class="dropdown icon"></i>
	          <div class="default text">Session</div>
	          <div class="menu">
	            <?php for($i = 2010; $i <= (date('Y') + 1) ; $i++): ?>
	             <div class="item" data-value="<?php echo e($i); ?>"><?php echo e($i); ?>/<?php echo e($i+1); ?></div>
	            <?php endfor; ?>
	          </div>
	        </div>
	      </div>
	      <div class="field">
	        <label>Term</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="term" value="<?php echo e(old('term')); ?>">
	          <i class="dropdown icon"></i>
	          <div class="default text">Term</div>
	          <div class="menu">
	             <div class="item" data-value="First"> First Term </div>
	             <div class="item" data-value="Second"> Second Term </div>
	             <div class="item" data-value="Third"> Third Term </div>
	          </div>
	        </div>
	      </div>
	      
	      <div class="field" id="field-class">
	        <label>Class</label>
	        <div class="ui fluid search selection dropdown" id="classes-dropdown">
	          <input type="hidden" name="class_id" value="<?php echo e(old('class_id')); ?>" data-href="<?php echo e(url('/do-ajax/class')); ?>">
	          <i class="dropdown icon"></i>
	          <div class="default text">Class</div>
	          <div class="menu" id="class-options-handler">
	            <?php if(!empty(old('school'))): ?>
	                <?php foreach(getClasses(old('school')) as $class): ?>
	                 <div class="item" data-value="<?php echo e($class->id); ?>"><?php echo e($class->class_name); ?></div>
	                <?php endforeach; ?>
	              <?php else: ?>
	                 <div class="item" data-value="">Select Class</div>
	              <?php endif; ?>
	            
	          </div>
	        </div>
	      </div>
	      <div class="field" id="field-arms">
	        <label>Class Arm</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="class_arm_id" value="<?php echo e(old('class_arm_id')); ?>">
	          <i class="dropdown icon"></i>
	          <div class="default text">Class Arm</div>
	          <div class="menu" id="class-arms">
	            <?php if(!empty(old('class_id'))): ?>
	                <?php foreach(getClassArms(old('class_id')) as $class_arm): ?>
	                 <div class="item" data-value="<?php echo e($class_arm->id); ?>"><?php echo e($class_arm->class_arm); ?></div>
	                <?php endforeach; ?>
	              <?php else: ?>
	                 <div class="item" data-value="">Select Class Arm</div>
	              <?php endif; ?>
	            
	          </div>
	        </div>
	      </div>
	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Students For ID Card Generation</button>
	      </div>

	    </div>
		  
		</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  Students For School ID Card Generation
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">OSSI Number</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student's ID Card</div>
		    </th>
			<th>
		    	<div class="ui ribbon label">Expiry Date</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">School</div>
		    </th>
		    <th >
		    	<div class="ui toggle checkbox check-all">
					<input type="checkbox" class="">
					<label>Select All</label>
				</div>
		    </th>
		  </tr>
		  </thead>
		  <tbody>
		  	<form class="ui form" action="<?php echo e(route('super_admin.generate.student-school-id-card')); ?>" method="post">
			<?php echo $__env->make('pagination.hidden-input-post', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		  	<?php $__empty_1 = true; foreach($students as $student): $__empty_1 = false; ?>
		    <tr>
		      <td><?php echo e(++$counter); ?></td>
		      <td><?php echo e($student->surname.' '.$student->firstname.' '.$student->middlename); ?></td>
		      <td><?php echo e($student->regnum); ?></td>
			<?php if(count(getStudentIDCard($student->id)) > 0): ?>
		      <td>
		      <a class="ui small image" href="<?php echo e(route('super_admin.download.student-idcard', ['id' => $student->id])); ?>" target="_blank">
			      <div class="ui dimmer">
				    <div class="content">
				      <div class="center">
				        <h2 class="ui inverted header"></h2>
				        <div class="ui orange button">Download ID Card</div>
				      </div>
				    </div>
				  </div>
			      <img src="<?php echo e(url_public(getStudentIDCard($student->id)->id_card)); ?>" class="ui small image">
			    </a>
		      <td><?php echo e(getIDCardExpDate($student->school_id)); ?></td>
		    <?php else: ?>
	    	<td colspan="2">
	    		<p>Student ID card has not been generated</p>
	    	</td>
		    <?php endif; ?>
		      <td><?php echo e(getSchoolName($student->school_id)); ?></td>
		      <td class="std-view">
		     <?php if($student->passport !== '/images/passports/no_img_da88a72526.gif'): ?>
			     <div class="ui toggle checkbox studentID">
					<input type="checkbox" name="student_id[]" value="<?php echo e($student->id); ?>" <?php if(!empty(old('student_id'))): ?><?php echo e(in_array($student->id, old('student_id')) ? 'checked="checked"' : ''); ?><?php endif; ?>><label></label>
				</div>
			<?php else: ?>
				<p>No passport</p>
			<?php endif; ?>
			  </td>
		    </tr>
		    
		   <?php endforeach; if ($__empty_1): ?>
			<tr>
				<th colspan="7">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  <?php if($students->count() > 0): ?>
		  <tr>
		    	<td colspan="7">
		    		<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;padding: 10px !important;">Generate Student ID Card</button>
		    	</td>
		    </tr>

		  <?php endif; ?>
		  </form>
		  </tbody>
		  <tfoot>
		    <tr><th colspan="7">
		     <?php echo $__env->make('pagination.post-default', ['paginator' => $students, 'post_data' => $data], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>