
<?php $__env->startSection('content'); ?>
<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<form class="ui form" action="<?php echo e(route('super_admin.view.teacher.post')); ?>" method="post" enctype="multipart/form-data">
		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
		<h2 class="ui dividing header">Search Registered Teachers</h2>
		<div class="four fields">
		  <div class="field states">
            <label>State</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" <?php if(!empty(old('state_id'))): ?>
                  value="<?php echo e(old('state_id')); ?>"
                <?php else: ?>
                  value="<?php echo e($ngstate->id); ?>"
                <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                 <div class="item" data-value="<?php echo e($ngstate->id); ?>"><?php echo e($ngstate->name); ?></div>
              </div>
            </div>
          </div>
          <div class="field" id="field-lga">
            <label>Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="<?php echo e(old('lga_id')); ?>" data-href="<?php echo e(url('/do-ajax/school')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Local Govt. Area</div>
              <div class="menu" id="state-lga">
                <?php foreach($ngstate_lgas as $ngstateLGA): ?>
                 <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>

          <div class="field" id="field-school">
            <label>School</label>
            <div class="ui fluid search selection dropdown" id="wrap-schools">
              <input type="hidden" name="school" value="<?php echo e(old('school')); ?>" data-href="<?php echo e(url('/do-ajax/classes')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Schools</div>
              <div class="menu" id="school-options-handler">
                <?php if(!empty(old('school'))): ?>
                    <?php foreach(getSchools(old('school')) as $school): ?>
                     <div class="item" data-value="<?php echo e($school->id); ?>"><?php echo e($school->name); ?></div>
                    <?php endforeach; ?>
                  <?php else: ?>
                     <div class="item" data-value="">Schools</div>
                  <?php endif; ?>
              </div>
            </div>
          </div>
          <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Teachers</button>
	      </div>
		</div>
		  
	</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  View Teachers Information
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Identification Number</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Passport</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Subject Areas</div>
		    </th>
		     <th>
		    	<div class="ui ribbon label">Teacher's School</div>
		    </th>
		    <th colspan="2">
		    	<div class="ui ribbon label">Actions on Teachers</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  <?php if(count($teachers) > 0): ?>
		  <?php  $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $teachers->perPage()  ?>
		  	<?php foreach($teachers as $teacher): ?>
		    <tr>
		    <td><?php echo e(++$counter); ?></td>
		      <td><?php echo e($teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename); ?></td>
		      <td><?php echo e($teacher->staff_no); ?></td>
		      <td><img src="<?php echo e(env('APP_URL').$teacher->passport); ?>" class="ui image"></td>
		      <td>
		      	<div class="ui middle aligned divided list">
		      	<?php $__empty_1 = true; foreach(getAssocSubject($teacher->id) as $t_s): $__empty_1 = false; ?>
		      	<div class="item">
				    <div class="content">
				      <p class="header"><?php echo e($t_s->subject_name); ?></p>
				    </div>
				</div>
				<?php endforeach; if ($__empty_1): ?>
				<div class="item">
				    <div class="content">
				      <p class="header">No Subject Area Yet</p>
				    </div>
				</div>
		      	<?php endif; ?>
		      	</div>
		      </td>
		      <td><?php echo e(getSchoolName($teacher->school_id)); ?></td>
		      <td class="std-view">
		      <?php if(auth('super_admin')->user()->can('edit-teacher')): ?>
			      <button class="ui labeled blue icon button editPermission" user-name="<?php echo e($teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename); ?>" user-id="<?php echo e($teacher->id); ?>">
				  <i class="edit icon" ></i>
				  Edit Permissions
				</button>
			<?php endif; ?>
			  </td>
		    </tr>
		   <?php endforeach; ?>
		    <?php else: ?>
			<tr>
				<th colspan="8">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  </tbody>
		  <tfoot>
		    <tr><th colspan="8">
		      <?php echo $__env->make('pagination.post-default', ['paginator' => $teachers, 'post_data' => $data], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		    </th>
		  </tr></tfoot>
		</table>
	</section>

	<!-- modals -->
	<form class="ui long modal">
	  <i class="close icon"></i>
	  <div class="header">
	  </div>
	  <div class="image content" style="height: 70vh;">
	    <div class="image">
	      Available Permissions
	    </div>
	    <div class="description ui grid">
	    	<p style="text-align: center;padding-top: 1em;color: red;">
	    		<small>Not available now please check back..</small>
	    	</p>
	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	    <div style="display: none;" class="ui approve blue button">Update</div>
	  </div>
	</form>

	
	<?php echo $__env->make('super-admin.permissions.select', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<script type="text/javascript">
	$(document).ready(function(){
        $('.editPermission').click(function(){
        	var modal = $('.ui.modal');
        	var name = $(this).attr('user-name');
        	var id = $(this).attr('user-id');
        	modal.find('.header').html("Edit "+name.toLowerCase()+"'s permissions");
        	// modal.find('.description').html('<div class="five wide column field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 10px;"></div>');
	       // append class arm
	       var route = "<?php echo e(route('super_admin.get.classarm')); ?>";
	       var token = "<?php echo e(csrf_token()); ?>";
			$.ajax({
				url: route,
				type: 'POST',
				data: {id:id, _token: token},
				success: function(response){
					if(response == 'permissions updated'){
						$('.msg-bag').html(success(response));
						msgClose();
					}else{
						$('.msg-bag').html(error(response));
						msgClose();
					}
					modal.find('.approve').fadeOut('fast');
				},
				error: function(error){
	        		console.log(error);
	        		$('.msg-bag').html(error('Something went wrong'));
	        		msgClose();
					modal.find('.approve').fadeOut('fast');
				}
			});

	        modal.modal({
		    closable  : false,
		    centered: false,
		    onDeny : function() {
				modal.find('.approve').fadeOut('fast');
		    },
		    onApprove : function() {
		    	$(this).submit();
		    }
		  }).modal('show');
	    });
	});
</script>
<script>
	function getPermissions(value, modal){
		$permission = '<div class="three wide column left floated compact segment" style="padding: 30px">';
		  $permission += '<div class="ui fitted toggle checkbox">';
		    $permission += '<input '+value.status+' name="permission['+value.id+']" value="'+value.id+'" type="checkbox">';
		    $permission += '<label></label>';
		    $permission += value.permission;
		  $permission += '</div>';
		$permission += '</div>';

		modal.find('.description').append($permission);
	}

	function error(response){
		$error = '<div class="ui error message transition">';
		  $error += '<div class="header">'+response+'</div>';
		  $error += '<i class="close icon"></i>';
		$error += '</div>';
		return $error;
	}

	function success(response){
		$success = '<div class="ui success message transition">';
		  $success += '<div class="header">'+response+'</div>';
		  $success += '<i class="close icon"></i>';
		$success += '</div>';
		return $success;
	}

	function msgClose(){
		$('.message .close').on('click', function() {
		    $(this).closest('.message').fadeOut('slow');
		});
	}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>