<?php $__env->startSection('content-unity-exam'); ?>
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
    <form class="ui form" action="<?php echo e(route('exam.unity.confirm.post')); ?>" method="post">
      <h2 class="ui dividing header">Unity Examination Confirmation</h2>
      <div class="field">
        <input type="hidden" value="<?php echo e(csrf_token()); ?>" name="_token" value="<?php echo e(old('_token')); ?>">
        <label>Examination Number</label>
        <div class="three fields">
          <div class="field">
            <p><?php echo e(auth('unity_exam')->user()->regnum); ?></p>
          </div>
        </div>
      </div>
      <div class="field">
        <label>Name</label>
        <div class="three fields">
          <div class="field">
            <p><?php echo e($student->surname); ?></p>
          </div>
          <div class="field">
            <p><?php echo e($student->firstname); ?></p>
          </div>
          <div class="field">
            <p><?php echo e($student->middlename); ?></p>
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <p><?php echo e(\Carbon\Carbon::parse($student->dob)->format('jS F, Y ')); ?></p>
          </div>
          <div class="field">
            <label>Gender</label>
            <p><?php echo e($student->gender); ?></p>
          </div>
          <div class="field">
            <label>Country</label>
            <p><?php echo e($student->country); ?></p>
          </div>
          <div class="field">
            <label>Blood Group</label>
            <p><?php echo e($student->blood_group); ?></p>
          </div>
      </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="ten wide field">
          <label>Contact Address</label>
          <p><?php echo e($student->address); ?></p>
          </div>
          <div class="three wide field">
            <label>State of Origin</label>
            <p><?php echo e($student->state->name); ?></p>
          </div>
          <div class="three wide field" id="field-lga">
            <label>State Local Govt Area.</label>
            <p><?php echo e($student->statelga->name); ?></p>
          </div>
        </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Religion</label>
            <p><?php echo e($student->religion); ?></p>
          </div>

          <div class="four wide field">
            <label>Student's Phone Number</label>
            <p><?php echo e($student->phone); ?></p>
          </div>
        </div>
      </div>
      <h4 class="ui dividing header">Parent or Guardian Information</h4>
      <div class="field">
        <div class="fields">
          <div class="six wide field">
          <label>Parent or Guardian Fullname</label>
          <p><?php echo e($student->parent_fullname); ?></p>
          </div>
          <div class="ten wide field">
            <label>Parent or Guardian Contact Address</label>
            <p><?php echo e($student->parent_address); ?></p>
          </div>
        </div>
      </div>
      <div class="field">
        <div class="fields">
          <div class="four wide field">
          <label>Parent or Guardian Email</label>
          <p><?php echo e($student->parent_email); ?></p>
          </div>
          <div class="four wide field">
            <label>Parent or Guardian Phone Number</label>
            <p><?php echo e($student->parent_phone); ?></p>
          </div>
        </div>
      </div>

      <div class="field">
        <h4 class="ui dividing header">Examinational Area Location Information</h4>
        <div class="two fields">
          <div class="field">
            <label>Examination Center Local Goverment</label>
            <p><?php echo e($student->hall_allocation()->with('ondo_lga')->first()->ondo_lga->name); ?></p>
          </div>

        </div>
      </div>


      <div class="field">
        <h4 class="ui dividing header">School Choices Information</h4>
        <div class="two fields">
          <div class="field">
            <label>First Choice</label>
            <p><?php echo e($student->first_choices->name); ?></p>
          </div>
          

          <div class="field">
            <label>Second Choice</label>
            <p><?php echo e($student->second_choices->name); ?></p>
            </div>
          </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Student Passport</label>
           <div class="ui medium image">
            <img src="<?php echo e(url_public($student->passport)); ?>">
          </div>
          </div>
        </div>
      </div>

      <div class="field">
        <div class="three fields">
          <div class="field">
            <a href="<?php echo e(route('exam.unity.create')); ?>" class="fluid ui button teal">Update Student Information</a>
          </div>
          <div class="field">
            <a href="<?php echo e(route('exam.unity.passport')); ?>" class="fluid ui button teal">Update Passpost</a>
          </div>
          <div class="field">
            <button class="fluid ui button" type="submit" onclick="confirm('Are you sure you want to submit the form, Once submitted you cannot modify the Bio Data?')" style="background-color: #f75a0c; color:white;">Final Submission</button>
          </div>
      </div>
      </div>
      
  </form>
</section>
<div class="jtr"></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('exams.unity.layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>