<?php $__env->startSection('content'); ?>
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<form class="ui form" action="" method="post">
  <h2 class="ui dividing header">Assign Counsellor To Class</h2>
  <div class="field">
    <input type="hidden" value="<?php echo e(csrf_token()); ?>" name="_token" value="<?php echo e(old('_token')); ?>">
    
    <div class="four fields">
      <div class="field">
        <label>Class</label>
        <div class="ui fluid search selection dropdown" id="classes-dropdown">
          <input type="hidden" name="class_id" value="<?php echo e(old('class_id')); ?>" data-href="<?php echo e(url('/do-ajax/class')); ?>">
          <i class="dropdown icon"></i>
          <div class="default text">Class</div>
          <div class="menu">
            <?php foreach($classes as $class): ?>
             <div class="item" data-value="<?php echo e($class->id); ?>"><?php echo e($class->class_name); ?></div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>

      <div class="field" id="field-arms">
        <label>Class Arm</label>
        <div class="ui fluid search selection dropdown">
          <input type="hidden" name="class_arm_id" value="<?php echo e(old('class_arm_id')); ?>">
          <i class="dropdown icon"></i>
          <div class="default text">Class Arm</div>
          <div class="menu" id="class-arms">
            <?php if(!empty(old('class_id'))): ?>
                <?php foreach(getClassArms(old('class_id')) as $class_arm): ?>
                 <div class="item" data-value="<?php echo e($class_arm->id); ?>"><?php echo e($class_arm->class_arm); ?></div>
                <?php endforeach; ?>
              <?php else: ?>
                 <div class="item" data-value="">Select Class Arm</div>
              <?php endif; ?>
            
          </div>
        </div>
      </div>
      <div class="field">
        <label>Assign Teachers</label>
         <select class="ui dropdown" name="teachers[]" >
            <option>Select teacher</option>
             <?php foreach($all_teachers as $teacher): ?>
              <option  value="<?php echo e($teacher->id); ?>" 
              <?php if(!empty(old('teachers')) && in_array($teacher->id, old('teachers'))): ?>
                  selected="selected"
              <?php endif; ?>
              ><?php echo e($teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename); ?></option>
             <?php endforeach; ?>
         </select>
      </div>

      <div class="field">
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white; margin-top:22.5px;">Assign Teachers to Class</button>
      </div>
    </div>
  </div>
</form>
<h2 class="ui horizontal divider header" style="color:#dc4900;">
      <i class="student icon"></i>
      View Counsellor Assigns To Class
    </h2>
    <table class="ui celled table">
      <thead>
        <tr>
        <th>
          <div class="ui ribbon label">Classes and Class Arms</div>
        </th>
        <th>
          <div class="ui ribbon label">Counsellor</div>
        </th>
        <th colspan="2">
          <div class="ui ribbon label">Actions on Subjects Assign</div>
        </th>
      </tr></thead>
      <tbody>
      <?php if(count($classarms) > 0): ?>
        <?php foreach($classarms as $classarm): ?>
        <tr>
          <td><?php echo e(getClassNameByClassID($classarm->class_id) .' '.$classarm->class_arm); ?></td>
          <td>
            <div class="ui middle aligned divided list">
            <?php if(count(getAssocCounsellorByClassArmID($classarm->id)) > 0): ?>
            <?php foreach(getAssocCounsellorByClassArmID($classarm->id) as $teacher): ?>
            <div class="item">
            <div class="content">
              <p class="header"><?php echo e($teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename); ?></p>
            </div>
        </div>
            <?php endforeach; ?>
            <?php else: ?>
            <div class="ui icon negative message">
          <div class="item">
              <div class="content">
                <p class="header">No Counsellor has been assigned to this class arm</p>
              </div>
          </div>
        </div>
            <?php endif; ?>
            </div>
          </td>
          <td class="std-view">
            <button class="ui labeled blue icon button" data-std-id="<?php echo e($classarm->id); ?>" data-href="<?php echo e(route('admin.edit.assign.counsellor.to.class', ['id' => $classarm->id])); ?>" data-message="Are you sure want to edit the Counsellor assigned to">
          <i class="edit icon"></i>
          Edit
        </button>
        </td>
          <td class="std-view">
        
          </td>
        </tr>
       <?php endforeach; ?>
        <?php else: ?>
      <tr>
        <th colspan="4">
          <div class="classarmsui icon negative message">
            <i class="info circle icon"></i>
            <div class="content">
              <div class="header">
              Sorry, No Record can be found.
              </div>
            </div>
           </div>
        </th>
      </tr>
      <?php endif; ?>
      </tbody>
      <tfoot>
        <tr><th colspan="4">
          <?php echo $__env->make('pagination.default', ['paginator' => $classarms], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </th>
      </tr></tfoot>
    </table>
</section>
<div class="ui modal" id="edit">
    <div class="header">Header</div>
    <div class="image content">
      <div class="description">

      </div>
    </div>
    <div class="actions">
      <div class="ui cancel button">Cancel</div>
      <a href="" class="ui approve blue button">Edit</a>
    </div>
  </div>

  <div class="ui modal" id="delete">
    <div class="header">Header</div>
    <div class="image content">
      <div class="description">

      </div>
    </div>
    <div class="actions">
      <div class="ui cancel button">Cancel</div>
      <form action="" method="post" style="display:inline-block;">
        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
        <input type="hidden" name="_method" value="delete">
        <button type="submit" class="ui approve negative button">Delete</button>
      </form>
    </div>
  </div>
<div class="jtr"></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>