<?php $__env->startSection('content'); ?>
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<form class="ui form" action="<?php echo e(route('super_admin.register.teacher')); ?>" method="post">
  <h2 class="ui dividing header">Teacher Registration</h2>
  <div class="field">
    <input type="hidden" value="<?php echo e(csrf_token()); ?>" name="_token">
    <label>Name</label>
    <div class="four fields">
      <div class="field">
        <input type="text" name="title" value="<?php echo e(old('title')); ?>" placeholder="Title">
      </div>
      <div class="field">
        <input type="text" name="surname" value="<?php echo e(old('surname')); ?>" placeholder="Surname">
      </div>
      <div class="field">
        <input type="text" name="firstname" value="<?php echo e(old('firstname')); ?>" placeholder="First Name">
      </div>
      <div class="field">
        <input type="text" name="middlename" value="<?php echo e(old('middlename')); ?>" placeholder="Other Name">
      </div>
    </div>
  </div>
  <div class="three fields">
    <div class="field states">
      <label>School State</label>
      <div class="ui fluid search selection dropdown states-dropdown" >
        <input type="hidden" name="school_state_id" <?php if(!empty(old('school_state_id'))): ?>
            value="<?php echo e(old('school_state_id')); ?>"
          <?php else: ?>
            value="<?php echo e($school_ngstate->id); ?>"
          <?php endif; ?>>
        <i class="dropdown icon"></i>
        <div class="default text">States</div>
        <div class="menu">
           <div class="item" data-value="<?php echo e($school_ngstate->id); ?>"><?php echo e($school_ngstate->name); ?></div>
        </div>
      </div>
    </div>
    <div class="field field-lga">
      <label>School Local Govt Area.</label>
      <div class="ui fluid search selection dropdown wrap-slgas school-wrap-slgas">
        <input type="hidden" name="school_lga_id" value="<?php echo e(old('school_lga_id')); ?>" data-href="<?php echo e(url('/do-ajax/school')); ?>">
        <i class="dropdown icon"></i>
        <div class="default text">Local Govt. Area</div>
        <div class="menu">
          <?php foreach($ngstate_lgas as $ngstateLGA): ?>
           <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
    <div class="field" id="field-school">
      <label>School</label>
      <div class="ui fluid search selection dropdown" id="wrap-schools">
        <input type="hidden" name="school" value="<?php echo e(old('school')); ?>" data-href="<?php echo e(url('/do-ajax/classes')); ?>">
        <i class="dropdown icon"></i>
        <div class="default text">Schools</div>
        <div class="menu" id="school-options-handler">
          <?php if(!empty(old('school'))): ?>
              <?php foreach(getSchools(old('school')) as $school): ?>
               <div class="item" data-value="<?php echo e($school->id); ?>"><?php echo e($school->name); ?></div>
              <?php endforeach; ?>
            <?php else: ?>
               <div class="item" data-value="">Schools</div>
            <?php endif; ?>
        </div>
      </div>
    </div>
  </div>

   <div class="field">
    <div class="three fields">
      <div class="field">
        <label>Qualification</label>
        <input type="text" name="qualification" value="<?php echo e(old('qualification')); ?>" placeholder="Other Name">
      </div>
      <div class="field">
        <label>Gender</label>
        <div class="ui fluid search selection dropdown">
          <input type="hidden" name="gender" value="<?php echo e(old('gender')); ?>">
          <i class="dropdown icon"></i>
          <div class="default text">Gender</div>
          <div class="menu">
             <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
             <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
          </div>
        </div>
      </div>
      <div class="field" id="field-subject">
        <label>Subject Area</label>
         <select multiple="" class="ui dropdown" name="subjects[]" id="subject-options-handler" placeholder="Select Subject Areas">
            <?php if(!empty(old('school'))): ?>
             <?php foreach(getSubjects(old('school')) as $subject): ?>
              <option  value="<?php echo e($subject->id); ?>" 
              <?php if(!empty(old('subjects')) && in_array($subject->id, old('subjects'))): ?>
                  selected="selected"
              <?php endif; ?>
              ><?php echo e($subject->subject_name); ?>(<?php echo e($subject->class_category); ?>)</option>
             <?php endforeach; ?>
             <?php else: ?>
             <option value=""> Select Subjects Area</option>
            <?php endif; ?>
         </select>
      </div>
  </div>
  </div>

  <div class="field">
    <div class="fields">
      <div class="ten wide field">
      <label>Contact Address</label>
        <input type="text" name="address" value="<?php echo e(old('address')); ?>" placeholder="Contact Address">
      </div>
      <div class="three wide field">
        <label>State of Origin</label>
        <div class="ui fluid search selection dropdown" id="states-dropdown">
          <input type="hidden" name="state_id" value="<?php echo e(old('state_id')); ?>" data-href="<?php echo e(url('/do-ajax/state')); ?>">
          <i class="dropdown icon"></i>
          <div class="default text">States</div>
          <div class="menu">
            <?php foreach($ngstates as $ngstate): ?>
             <div class="item" data-value="<?php echo e($ngstate->id); ?>"><?php echo e($ngstate->name); ?></div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
      <div class="three wide field" id="field-lga">
        <label>State Local Govt Area.</label>
        <div class="ui fluid search selection dropdown just-state-lga" id="wrap-slgas">
          <input type="hidden" name="lga_id" value="<?php echo e(old('lga_id')); ?>">
          <i class="dropdown icon"></i>
          <div class="default text">State LGA</div>
          <div class="menu" id="state-lga">
              <?php if(!empty(old('state_id'))): ?>
                <?php foreach(getStateLGAs(old('state_id')) as $ngstateLGA): ?>
                 <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                <?php endforeach; ?>
              <?php else: ?>
                 <div class="item" data-value="">Select State LGA</div>
              <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="field">
    <div class="fields">
      <div class="four wide field">
      <label>Teacher's Email</label>
        <input type="email" name="email" value="<?php echo e(old('email')); ?>" placeholder="Teacher's Email">
      </div>
      <div class="four wide field">
        <label>Teacher's Phone Number</label>
          <input type="text" name="phone" value="<?php echo e(old('phone')); ?>" placeholder="Teacher's Phone Number">
      </div>

      <div class="four wide field">
      <label>Teacher's Password</label>
        <input type="password" name="password" value="<?php echo e(old('password')); ?>" placeholder="Teacher's Password">
      </div>
      <div class="four wide field">
        <label>Teacher's Confirm Password</label>
        <input type="password" name="password_confirmation" value="<?php echo e(old('password_confirmation')); ?>" placeholder="Teacher's Confirm Password">
      </div>
    </div>
  </div>


  <div class="field">
    <div class="three fields">
      <div class="field">
          <label>Session</label>
          <div class="ui fluid search selection dropdown">
            <input type="hidden" name="session" value="<?php echo e(old('session')); ?>">
            <i class="dropdown icon"></i>
            <div class="default text">Session</div>
            <div class="menu">
              <?php for($i = 2010; $i <= (date('Y') + 1) ; $i++): ?>
               <div class="item" data-value="<?php echo e($i); ?>"><?php echo e($i); ?>/<?php echo e($i+1); ?></div>
              <?php endfor; ?>
            </div>
          </div>
        </div>
        <div class="field">
          <label>Marital Status</label>
          <div class="ui fluid search selection dropdown">
            <input type="hidden" name="marital_status" value="<?php echo e(old('marital_status')); ?>">
            <i class="dropdown icon"></i>
            <div class="default text">Marital Status</div>
            <div class="menu">
               <div class="item" data-value="Single">Single</div>
               <div class="item" data-value="Married">Married</div>
               <div class="item" data-value="Divorce">Divorce</div>
            </div>
          </div>
        </div>
    </div>
  </div>




  <h4 class="ui dividing header">Next of kins Information</h4>
  <div class="field">
    <div class="fields">
      <div class="six wide field">
      <label>Next of knis Fullname</label>
        <input type="text" name="next_of_kins" value="<?php echo e(old('next_of_kins')); ?>" placeholder="Next of kins Fullname">
      </div>
      <div class="ten wide field">
        <label>Next of kins Contact Address</label>
        <input type="text" name="next_of_kins_address" value="<?php echo e(old('next_of_kins_address')); ?>" placeholder="Next of kins Contact Address">
      </div>
    </div>
  </div>
  <div class="field">
    <div class="fields">
      <div class="four wide field">
      <label>Next of kins Email</label>
        <input type="email" name="next_of_kins_email" value="<?php echo e(old('next_of_kins_email')); ?>" placeholder="Next of kins Email">
      </div>
      <div class="four wide field">
        <label>Next of kins Phone Number</label>
        <input type="text" name="next_of_kins_phone" value="<?php echo e(old('next_of_kins_phone')); ?>" placeholder="Next of kins Phone Number">
      </div>
    </div>
  </div>

    <h4 class="ui dividing header">Teacher Health Information</h4>
  <div class="field">
    <div class="fields">
      <div class="four wide field">
        <label>Health Status</label>
        <div class="ui fluid search selection dropdown">
          <input type="hidden" name="health_status" value="<?php echo e(old('health_status')); ?>">
          <i class="dropdown icon"></i>
          <div class="default text">Health Status</div>
          <div class="menu">
             <div class="item" data-value="Normal">Normal</div>
             <div class="item" data-value="Disable">Disable</div>
          </div>
        </div>
      </div>
      <div class="four wide field">
        <label>Extra Curricular Activities</label>
         <input type="text" name="extra_curricular_activites" value="<?php echo e(old('extra_curricular_activites')); ?>" placeholder="Teacher Extra Curricular Activities">
      </div>
      <div class="six wide field">
        <label>Health Status Description</label>
        <textarea rows="4" name="health_status_desc"><?php echo e(old('health_status_desc')); ?></textarea>
      </div>
  </div>
    <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Register Teachers</button>
  
  </form>
</section>
<div class="jtr"></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>