@extends('teacher.layouts.main')
@section('content-teacher')
<form class="ui form" action="" method="post">
      <h2 class="ui dividing header">Edit Profile</h2>
      <div class="field">
        <input type="hidden" name="_method" value="put">
        <input type="hidden" value="{{csrf_token()}}" name="_token">
        <label>Name</label>
        <div class="four fields">
          <div class="field">
            <input type="text" name="title" @if(!empty(old('title')))
              value="{{old('title')}}"
            @else
              value="{{$teacher->title}}"
            @endif placeholder="Title">
          </div>
          <div class="field">
            <input type="text" name="surname" @if(!empty(old('surname')))
              value="{{old('surname')}}"
            @else
              value="{{$teacher->surname}}"
            @endif placeholder="Surname">
          </div>
          <div class="field">
            <input type="text" name="firstname" @if(!empty(old('firstname')))
              value="{{old('firstname')}}"
            @else
              value="{{$teacher->firstname}}"
            @endif placeholder="First Name">
          </div>
          <div class="field">
            <input type="text" name="middlename" @if(!empty(old('middlename')))
              value="{{old('middlename')}}"
            @else
              value="{{$teacher->middlename}}"
            @endif placeholder="Other Name">
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
           <div class="field">
            <label>Qualification</label>
            <input type="text" name="qualification" @if(!empty(old('qualification')))
              value="{{old('qualification')}}"
            @else
              value="{{$teacher->qualification}}"
            @endif placeholder="Qualification">
          </div>
          <div class="field">
            <label>Gender</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="gender"    @if(!empty(old('gender')))
                  value="{{old('gender')}}"
                @else
                  value="{{$teacher->gender}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Gender</div>
              <div class="menu">
                 <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
                 <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
              </div>
            </div>
          </div>
          <div class="field">
          <label>Email</label>
            <input type="email" name="email" @if(!empty(old('email')))
              value="{{old('email')}}"
            @else
              value="{{$teacher->email}}"
            @endif placeholder="Email">
          </div>
          <div class="field">
            <label>Phone Number</label>
              <input type="text" name="phone" @if(!empty(old('phone')))
              value="{{old('phone')}}"
            @else
              value="{{$teacher->phone}}"
            @endif placeholder="Phone Number">
          </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="eight wide field">
          <label>Contact Address</label>
            <input type="text" name="address"  @if(!empty(old('address')))
                  value="{{old('address')}}"
                @else
                  value="{{$teacher->address}}"
                @endif placeholder="Contact Address">
          </div>
          <div class="four wide field">
            <label>State of Origin</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id"     @if(!empty(old('state_id')))
                  value="{{old('state_id')}}"
                @else
                  value="{{$teacher->state_id}}"
                @endif data-href="{{url('/do-ajax/state')}}">
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                @foreach($ngstates as $ngstate)
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
                @endforeach
              </div>
            </div>
          </div>
          <div class="four wide field" id="field-lga">
            <label>State Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id"   @if(!empty(old('lga_id')))
                value="{{old('lga_id')}}"
              @else
                value="{{$teacher->lga_id}}"
              @endif
              ">
              <i class="dropdown icon"></i>
              <div class="default text">State LGA</div>
              <div class="menu" id="state-lga">
                  @if(!empty(old('state_id')))
                    @foreach(getStateLGAs(old('state_id')) as $ngstateLGA)
                     <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach
                  @else
                     @foreach(getStateLGAs($teacher->state_id) as $ngstateLGA)
                     <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach
                  @endif
              </div>
            </div>
          </div>
        </div>
      </div>
      <h4 class="ui dividing header">Next of kins Information</h4>
      <div class="field">
        <div class="fields">
          <div class="six wide field">
          <label>Next of knis Fullname</label>
            <input type="text" name="next_of_kins" @if(!empty(old('next_of_kins')))
              value="{{old('next_of_kins')}}"
            @else
              value="{{$teacher->next_of_kins}}"
            @endif placeholder="Next of kins Fullname">
          </div>
          <div class="ten wide field">
            <label>Next of kins Contact Address</label>
            <input type="text" name="next_of_kins_address" @if(!empty(old('next_of_kins_address')))
              value="{{old('next_of_kins_address')}}"
            @else
              value="{{$teacher->next_of_kins_address}}"
            @endif placeholder="Next of kins Contact Address">
          </div>
        </div>
      </div>
      <div class="field">
        <div class="fields">
          <div class="four wide field">
          <label>Next of kins Email</label>
            <input type="email" name="next_of_kins_email" @if(!empty(old('next_of_kins_email')))
              value="{{old('next_of_kins_email')}}"
            @else
              value="{{$teacher->next_of_kins_email}}"
            @endif placeholder="Next of kins Email">
          </div>
          <div class="four wide field">
            <label>Next of kins Phone Number</label>
            <input type="text" name="next_of_kins_phone" @if(!empty(old('next_of_kins_phone')))
              value="{{old('next_of_kins_phone')}}"
            @else
              value="{{$teacher->next_of_kins_phone}}"
            @endif placeholder="Next of kins Phone Number">
          </div>
        </div>
      </div>

        <h4 class="ui dividing header">Teacher Health Information</h4>
      <div class="field">
        <div class="fields">
          <div class="four wide field">
            <label>Marital Status</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="marital_status" @if(!empty(old('marital_status')))
              value="{{old('marital_status')}}"
            @else
              value="{{$teacher->marital_status}}"
            @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Marital Status</div>
              <div class="menu">
                 <div class="item" data-value="Single">Single</div>
                 <div class="item" data-value="Married">Married</div>
                 <div class="item" data-value="Divorce">Divorce</div>
              </div>
            </div>
          </div>
          <div class="four wide field">
            <label>Health Status</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="health_status" @if(!empty(old('health_status')))
              value="{{old('health_status')}}"
            @else
              value="{{$teacher->health_status}}"
            @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Health Status</div>
              <div class="menu">
                 <div class="item" data-value="Normal">Normal</div>
                 <div class="item" data-value="Disable">Disable</div>
              </div>
            </div>
          </div>
          <div class="four wide field">
            <label>Extra Curricular Activities</label>
             <input type="text" name="extra_curricular_activites"  @if(!empty(old('extra_curricular_activites')))
              value="{{old('extra_curricular_activites')}}"
            @else
              value="{{$teacher->extra_curricular_activites}}"
            @endif placeholder="Teacher Extra Curricular Activities">
          </div>
          <div class="four wide field">
            <label>Health Status Description</label>
            @if(!empty(old('health_status_desc')))
            <textarea rows="4" name="health_status_desc">{{old('health_status_desc')}}</textarea>
            @else
              <textarea rows="4" name="health_status_desc">{{$teacher->health_status_desc}}</textarea>
            @endif</textarea>
          </div>
      </div>
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Update Profile</button>
      
  </form>
@endsection