@extends('teacher.layouts.main')
@section('content-teacher')
<form class="ui form" action="" method="post">
    <input type="hidden" name="_token" value="{{csrf_token()}}">
    <h2 class="ui dividing header">Your Overview</h2>
    <div class="field">
        <div class="two fields">
            <div class="field">
                <label>Account Type</label>
                <div class="ui fluid search selection dropdown">
                  <input type="hidden" name="type" @if($overview->count() > 0) value="{{$overview->first()->teacher_type}}" @endif required>
                  <i class="dropdown icon"></i>
                  <div class="default text">Select Category</div>
                  <div class="menu">
                     <div class="item" data-value="government teacher"><i class="dot circle outline icon"></i>Government Teacher</div>
                     <div class="item" data-value="pta employed"><i class="dot circle outline icon"></i>PTA Employed</div>
                     <div class="item" data-value="corper"><i class="dot circle outline icon"></i>Corper</div>
                     <div class="item" data-value="npower teacher"><i class="dot circle outline icon"></i>NPower Teacher</div>
                     <div class="item" data-value="other"><i class="dot circle outline icon"></i>Other</div>
                  </div>
                </div>
                <br>
                <label>Date Of Birth</label>
                <div class="ui fluid">
                    <div class="ui calendar">
                        <div class="ui input left icon">
                          <i class="calendar icon"></i>
                          <input type="text" name="teacher_date_of_birth" placeholder="Date" @if($overview->count() > 0) value="{{$overview->first()->teacher_date_of_birth}}" @endif>
                        </div>
                    </div>
                </div>
                <br>
                <label>Highest Qualification</label>
                <div class="ui fluid search selection dropdown">
                  <input type="hidden" name="teacher_highest_qualification" onchange="toggleOtherSpecified(this);" @if($overview->count() > 0) value="{{$overview->first()->teacher_highest_qualification}}" @endif required>
                  <i class="dropdown icon"></i>
                  <div class="default text">Select Qualification</div>
                  <div class="menu">
                     <div class="item" data-value="master degrees with tq"><i class="dot circle outline icon"></i>Master Degrees With TQ</div>
                     <div class="item" data-value="graduate with tq"><i class="dot circle outline icon"></i>Graduate With TQ</div>
                     <div class="item" data-value="graduate without tq<"><i class="dot circle outline icon"></i>Graduate Without TQ</div>
                     <div class="item" data-value="hnd Wwith tq"><i class="dot circle outline icon"></i>HND With TQ</div>
                     <div class="item" data-value="hnd without tq"><i class="dot circle outline icon"></i>HND Without TQ</div>
                     <div class="item" data-value="nce"><i class="dot circle outline icon"></i>NCE</div>
                     <div class="item" data-value="ond & equivalent"><i class="dot circle outline icon"></i>OND & Equivalent</div>
                     <div class="item" data-value="others"><i class="dot circle outline icon"></i>Others (Specified)</div>
                  </div>
                </div>
                <div class="others_specified" @if($overview->count() > 0 && $overview->first()->teacher_other_qualification == '') style="display: none;" @endif>
                  <div class="ui fluid">
                    <input type="text" name="teacher_other_qualification" placeholder="Enter Qualification" @if($overview->count() > 0) value="{{$overview->first()->teacher_other_qualification}}" @endif>
                  </div>
                </div>
                <br>
                <label>Major Subject Specialization</label>
                <div class="ui fluid search selection dropdown">
                  <input type="hidden" name="teacher_subject_specialization_major" @if($overview->count() > 0) value="{{$overview->first()->teacher_subject_specialization_major}}" @endif required>
                  <i class="dropdown icon"></i>
                  <div class="default text">Select Major Specialization</div>
                  <div class="menu">
                    @foreach(App\SpecializationSubject::all() as $subject)
                     <div class="item" data-value="{{strtolower($subject->subject_name)}}"><i class="dot circle outline icon"></i>{{strtoupper($subject->subject_name)}}</div>
                    @endforeach
                  </div>
                </div>
                <br>
                <label>Minor Subject Specialization</label>
                <div class="ui fluid search selection dropdown">
                  <input type="hidden" name="teacher_subject_specialization_minor" @if($overview->count() > 0) value="{{$overview->first()->teacher_subject_specialization_minor}}" @endif required>
                  <i class="dropdown icon"></i>
                  <div class="default text">Select Minor Specialization</div>
                  <div class="menu">
                    @foreach(App\SpecializationSubject::all() as $subject)
                     <div class="item" data-value="{{strtolower($subject->subject_name)}}"><i class="dot circle outline icon"></i>{{strtoupper($subject->subject_name)}}</div>
                    @endforeach
                  </div>
                </div>
                <br>
                <label>Date Of First Appointment</label>
                <div class="ui fluid">
                    <div class="ui calendar">
                        <div class="ui input left icon">
                          <i class="calendar icon"></i>
                          <input type="text" name="teacher_date_of_service" placeholder="Date" @if($overview->count() > 0) value="{{$overview->first()->teacher_date_of_service}}" @endif>
                        </div>
                    </div>
                </div>
            </div>
            <div class="field">
                <label>Description</label>
                <textarea type="text" placeholder="Write a little bio here..." name="description" required>@if($overview->count() > 0){{$overview->first()->teacher_description}}@endif</textarea>
            </div>
        </div>
    </div>
    <div style="text-align: right;">
        <button class="ui button" type="submit" style="background-color: #f75a0c; color:white;">Update Overview</button>
        <a href="https://play.google.com/store/apps/details?id=odsgmoe.attendance.app" target="_blank" class="ui button blue" type="button" style="color:white;">Download Attendance App!</a>
    </div>
</form>
<div class="ui printnone" style="padding: 30px 20px; 10px 20px;margin: 0 auto;">
    @include('layouts.ads.sub-menu-ad')
</div>
@endsection
@section('scripts')
<script>
    $(function(){
        $('.ui.calendar').calendar({
          type: 'date'
        });

        if($('.others_specified').val() != ''){
          $('.others_specified').slideDown();
        }
    });

    function toggleOtherSpecified(obj){
      var input = $(obj);
      if(input.val() == 'others'){ 
        $('.others_specified').slideDown(); 
      }else{
        $('.others_specified').slideUp();
        $('.others_specified input').val('');
      }
    }
</script>
@endsection