@extends('layouts.main')
@section('content')
	<section class="ui stackable grid" id="student-dashboard" style="margin-top: 40px; margin-left:20px;">
		<div class="ui floating message four wide column">
			<div class="ui divided items">
			  <div class="item">
			  	<div class="image" style="margin:auto">
			      <img src="{{url_public($teacher->passport)}}">
			    </div>
			  </div>
			  @php
		  	    $analytics = App\AttendanceAnalytic::where('teacher_id', $teacher->id)->get()->first();
		  	    if($analytics){
		  	        $rawDOB = explode(' ', $analytics->teacher_date_of_birth);
		  	        $rawDOA = explode(' ', $analytics->teacher_date_of_service);
		  	        $dob = $rawDOB[2];
		  	        $doa = $rawDOA[2];
		  	        
                    $age =  date('Y') - $dob;
                    $yearsOfWorking = date('Y') - $doa;
                    $yearOfStopWorking = $doa + 35;
                    if($yearsOfWorking <= 35){
                        $yearsOfWorkingLeft = 35 - $yearsOfWorking;
                    }else{
                        $yearsOfWorkingLeft = 0;
                    }
                }
		  	@endphp
		  	@if($analytics)
    	          @if($age >= 60)
    	          <!--<div class="ui info message">-->
               <!--       <i class="close icon"></i>-->
    	          <!--    <div class="header">Retirement Stauts:</div>-->
    	          <!--    <br>-->
        	      <!--    <span style="color: red;">Retired by age</span>-->
        	      <!--    <br>-->
        	      <!--    <small style="color: orange;">orked for {{$yearsOfWorking}} years.</small><br>-->
        	      <!--    <small style="color: orange;">due for retirement in {{$yearsOfWorkingLeft}} years.</small>-->
        	      <!--</div>-->
    	          @elseif($yearsOfWorking >= 35)
    	          <!--<div class="ui info message">-->
               <!--       <i class="close icon"></i>-->
    	          <!--    <div class="header">Retirement Stauts:</div>-->
    	          <!--    <br>-->
        	      <!--    <span style="color: red;">Retired by year of service</span>-->
        	      <!--    <br>-->
        	      <!--    <small style="color: orange;">worked for {{$yearsOfWorking}} years.</small><br>-->
        	      <!--    <small style="color: orange;">due for retirement in {{$yearsOfWorkingLeft}} years.</small>-->
        	      <!--</div>-->
    	          @else
    	          <!--<div class="ui info message">-->
               <!--       <i class="close icon"></i>-->
    	          <!--    <div class="header">Retirement Stauts:</div>-->
    	          <!--    <br>-->
        	      <!--    <span style="color: green;">Still working</span>-->
        	      <!--    <br>-->
        	      <!--    <small style="color: orange;">worked for {{$yearsOfWorking}} years.</small><br>-->
        	      <!--    <small style="color: orange;">due for retirement in {{$yearsOfWorkingLeft}} years.</small>-->
        	      <!--</div>-->
    	          @endif
    	    @else
            <div class="ui negative message">
              <i class="close icon"></i>
              <div class="header">Retirement Stauts:</div>
              <br>
              <span>Please update your overview data</span>
            </div>
		    @endif
			  <div class="item">
			    <div class="content">
			      <div class="header">Fullname</div>
			      <div class="description">
			        <p>{{$teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Teacher ID</div>
			      <div class="description">
			        <p>{{$teacher->staff_no}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Email Address</div>
			      <div class="description">
			        <p>{{$teacher->email}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Phone Number</div>
			      <div class="description">
			        <p>{{$teacher->phone}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Contact Address</div>
			      <div class="description">
			        <p>{{$teacher->address}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Qualification</div>
			      <div class="description">
			        <p>{{ !empty($teacher->qualification) ? $teacher->qualification : 'Qualification not Available'}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Gender</div>
			      <div class="description">
			        <p><i class="{{strtolower($teacher->gender)}} icon"></i>{{$teacher->gender}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">State of Origin</div>
			      <div class="description">
			        <p>{{getStateName($teacher->state_id)}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">State Local Government Area</div>
			      <div class="description">
			        <p>{{getStateLGAName($teacher->lga_id)}}</p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Teacher's Signature</div>
			      <div class="description">
			      @if(!empty($teacher->signature))
			        <img src="{{url_public($teacher->signature)}}" class="ui fluid image">
			       @else
			       	<p class="ui negative message">You have not Submitted your signature</p>
			       @endif
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Teacher's Phone Number</div>
			      <div class="description">
			        <p>{{$teacher->phone}}</p>
			      </div>
			    </div>
			  </div>
	      	<div class="item">
			    <div class="content">
			      <div class="header">Subject Area</div>
			      <div class="description">
				 @if($teacher->subjects()->count() > 0)
					@foreach(getAssocSubject($teacher->id) as $t_s)
					      <p>{{$t_s->subject_name}}</p>
			      	@endforeach
			     @else
			     	<p>No Subject Area Yet</p>
				 @endif
				    </div>
				</div>
			</div>
		</div>
	</div>
	<div class="ten wide column">
		@include('partial.error')
		@yield('content-teacher')
	</div>
	</section>

	<div class="jtr"></div>
@endsection