@extends('teacher.layouts.main')

@section('content-teacher')
	<div class="ui stackable three column grid">
	    <div class="column dashboard">
    	        <span class="notify danger">new</span>
    		    <a class="ui medium image" target="_blank" href="https://play.google.com/store/apps/details?id=odsgmoe.attendance.app">
    		      <div class="ui dimmer">
    			    <div class="content">
    			      <div class="center">
    			        <h2 class="ui inverted header"></h2>
    			        <div class="ui orange button">Attendance Application</div>
    			      </div>
    			    </div>
    			  </div>
    		      <img class="ui fuild image" src="{{url_public('/images/ATTENDANCE APPLICATION.png')}}">
    		    </a>
    		    <div class="content">
    			    <div class="meta">
    			      <a class="ui orange fluid button" target="_blank" href="https://play.google.com/store/apps/details?id=odsgmoe.attendance.app">Attendance Application</a>
    			    </div>
    			</div>
        	</div>
	    <div class="column dashboard">
    	        @if(App\AttendanceAnalytic::where('teacher_id', auth('teacher')->user()->id)->get()->count() <= 0)
    	        <span class="notify danger">Attention!</span>
    	        @endif
    		    <a class="ui medium image" href="{{route('teacher.overview')}}">
    		      <div class="ui dimmer">
    			    <div class="content">
    			      <div class="center">
    			        <h2 class="ui inverted header"></h2>
    			        <div class="ui orange button">Your Overview</div>
    			      </div>
    			    </div>
    			  </div>
    		      <img class="ui fuild image" src="{{url_public('/images/symbols-analytics-icon-1.png')}}" style="height: 260px;">
    		    </a>
    		    <div class="content">
    			    <div class="meta">
    			      <a class="ui orange fluid button" href="{{route('teacher.overview')}}">Your Overview</a>
    			    </div>
    			</div>
        	</div>
			  <div class="column dashboard">
			    <a class="ui medium image" href="{{route('teacher.profile', ['id' => \Auth::guard('teacher')->id()])}}">
			      <div class="ui dimmer">
				    <div class="content">
				      <div class="center">
				        <h2 class="ui inverted header"></h2>
				        <div class="ui orange button">Edit Profile</div>
				      </div>
				    </div>
				  </div>
			      <img class="ui fuild image" src="{{url_public('/images/edit-profile.png')}}">
			    </a>
			    <div class="content">
				    <div class="meta">
				      <a class="ui orange fluid button" href="{{route('teacher.profile', ['id' => \Auth::guard('teacher')->id()])}}">Edit Profile</a>
				    </div>
				</div>
			  </div>
			  <div class="column dashboard">
			    <a class="ui medium image" href="{{route('teacher.password.edit', ['id' => \Auth::guard('teacher')->id()])}}">
			      <div class="ui dimmer">
				    <div class="content">
				      <div class="center">
				        <h2 class="ui inverted header"></h2>
				        <div class="ui orange button">Change Password</div>
				      </div>
				    </div>
				  </div>
			      <img class="ui fuild image" src="{{url_public('/images/change-password.png')}}">
			    </a>
			    <div class="content">
				    <div class="meta">
				      <a class="ui orange fluid button" href="{{route('teacher.password.edit', ['id' => \Auth::guard('teacher')->id()])}}">Change Password</a>
				    </div>
				</div>
			  </div>
			  <div class="column dashboard">
			    <a class="ui medium image" href="{{route('teacher.passport', ['id' => \Auth::guard('teacher')->id()])}}">
			      <div class="ui dimmer">
				    <div class="content">
				      <div class="center">
				        <h2 class="ui inverted header"></h2>
				        <div class="ui orange button">Upload Passport</div>
				      </div>
				    </div>
				  </div>
			      <img class="ui fuild image" src="{{url_public('/images/passport-upload.png')}}">
			    </a>
			    <div class="content">
				    <div class="meta">
				      <a class="ui orange fluid button" href="{{route('teacher.passport', ['id' => \Auth::guard('teacher')->id()])}}">Upload Passport</a>
				    </div>
				</div>
			  </div>
              
              <div class="column dashboard">
			    <a class="ui medium image" href="{{route('teacher.view.result')}}">
			      <div class="ui dimmer">
				    <div class="content">
				      <div class="center">
				        <h2 class="ui inverted header"></h2>
				        <div class="ui orange button">View Class Result</div>
				      </div>
				    </div>
				  </div>
			      <img class="ui fuild image" src="{{url_public('/images/result_checker.png')}}">
			    </a>
			    <div class="content">
				    <div class="meta">
				      <a class="ui orange fluid button" href="{{route('teacher.view.result')}}">View Class Result</a>
				    </div>
				</div>
			  </div>
              
              <div class="column dashboard">
			    <a class="ui medium image" href="{{route('teacher.view.batch.upload.result.by.subject')}}">
			      <div class="ui dimmer">
				    <div class="content">
				      <div class="center">
				        <h2 class="ui inverted header"></h2>
				        <div class="ui orange button">Upload Class Result</div>
				      </div>
				    </div>
				  </div>
			      <img class="ui fuild image" src="{{url_public('/images/result_checker.png')}}">
			    </a>
			    <div class="content">
				    <div class="meta">
				      <a class="ui orange fluid button" href="{{route('teacher.view.batch.upload.result.by.subject')}}">Upload Class Result</a>
				    </div>
				</div>
			  </div>
              
			@can('view-result')
			  <!--<div class="column dashboard">
			    <a class="ui medium image" href="{{route('teacher.results', ['id' => \Auth::guard('teacher')->id()])}}">
			      <div class="ui dimmer">
				    <div class="content">
				      <div class="center">
				        <div class="ui orange button">View Result</div>
				      </div>
				    </div>
				  </div>
			      <img class="ui fuild image" src="{{url_public('/images/view-result.png')}}">
			    </a>
			    <div class="content">
				    <div class="meta">
				      <a class="ui orange fluid button" href="{{route('teacher.results', ['id' => \Auth::guard('teacher')->id()])}}">View Result</a>
				    </div>
				</div>
			  </div>-->
			 @endcan
			@can('view-assignment-teacher')
			   <!--<div class="column dashboard">
			    <a class="ui medium image" href="{{route('teacher.assignment', ['id' => \Auth::guard('teacher')->id()])}}">
			      <div class="ui dimmer">
				    <div class="content">
				      <div class="center">
				        <div class="ui orange button">Assignment</div>
				      </div>
				    </div>
				  </div>
			      <img class="ui fuild image" src="{{url_public('/images/assignment-icon.png')}}">
			    </a>
			    <div class="content">
				    <div class="meta">
				      <a class="ui orange fluid button" href="{{route('teacher.assignment', ['id' => \Auth::guard('teacher')->id()])}}">Assignment</a>
				    </div>
				</div>
			  </div>-->
			@endcan
			@can('view-remarks')
			  <!--<div class="column dashboard">
			    <a class="ui medium image" href="{{route('teacher.remarks', ['id' => \Auth::guard('teacher')->id()])}}">
			      <div class="ui dimmer">
				    <div class="content">
				      <div class="center">
				        <div class="ui orange button">Remarks</div>
				      </div>
				    </div>
				  </div>
			      <img class="ui fuild image" src="{{url_public('/images/remarks-icon.png')}}">
			    </a>
			    <div class="content">
				    <div class="meta">
				      <a class="ui orange fluid button" href="{{route('teacher.remarks', ['id' => \Auth::guard('teacher')->id()])}}">Remarks</a>
				    </div>
				</div>
			  </div>-->
			 @endcan
			  
			  <div class="column dashboard">
			    <a class="ui medium image" href="{{route('teacher.subject', ['id' => \Auth::guard('teacher')->id()])}}">
			      <div class="ui dimmer">
				    <div class="content">
				      <div class="center">
				        <div class="ui orange button">Update Subject Area</div>
				      </div>
				    </div>
				  </div>
			      <img class="ui fuild image" src="{{url_public('/images/subject-icon.png')}}">
			    </a>
			    <div class="content">
				    <div class="meta">
				      <a class="ui orange fluid button" href="{{route('teacher.subject', ['id' => \Auth::guard('teacher')->id()])}}">Update Subject Area</a>
				    </div>
				</div>
			  </div>

			  <div class="column dashboard">
			    <a class="ui medium image" href="{{route('teacher.signature')}}">
			      <div class="ui dimmer">
				    <div class="content">
				      <div class="center">
				        <div class="ui orange button">Signature</div>
				      </div>
				    </div>
				  </div>
			      <img class="ui fuild image" src="{{url_public('/images/signature-icon.png')}}">
			    </a>
			    <div class="content">
				    <div class="meta">
				      <a class="ui orange fluid button" href="{{route('teacher.signature')}}">Signature</a>
				    </div>
				</div>
			  </div>

			</div>
@endsection