@extends('teacher.layouts.main')

@section('content-teacher')

<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 1024px" id="result-view">
<div class="sixteen wide column">
    <table class="ui unstackable celled table">
      <thead>
        <tr>
          <th class="ui huge centered header"> {{getClassNameByClassID($class_id).' '.getClassArmNameByClassArmID($classarm_id_get)}} &nbsp;&nbsp; {{$session.'/'.($session + 1)}}  {{$term}} Term Results</th>
        </tr>
      </thead>
      <tbody>
      @php $counter = 0 @endphp
       @foreach($students_results_info as $key => $student_results)
        <tr>
          <td>
            <table class="ui unstackable celled table">
              <thead>
                <tr>
                    <th>{{++$counter}}</th>
                    <th colspan="{{ceil((count($student_results['data']) - 1) / 2)}}">{{getStudentFullnameByStudentID($key)}}</th>
                    <th colspan="{{floor((count($student_results['data']) - 1) / 2)}}">{{getRegNumByStudentID($key)}}</th>
                </tr>
              </thead>
              <tbody> 
                <tr>
              @if(count($student_results['data']) > 0)           
                  @foreach($student_results['data'] as  $student_result)
                    <td>
                       <table class="inner-table">
                         <tr style="padding:0"><td style="padding:0">{{getSubjectCodeBySubjectID($student_result->subject_id)}}</td></tr>
                         <tr><td>{{$student_result->weighted_average}}</td></tr>
                         <tr><td>
                         @if($class_name_char == "J")
                              {{resultGradeJS($student_result->weighted_average)}}
                         @else
                              {{resultGradeSS($student_result->weighted_average)}}
                         @endif
                         </td></tr>
                       </table>
                    </td>
                  @endforeach

                @else
                    <td colspan="3">
                      <div class="ui icon negative message">
                            <div class="content">
                              <p class="header">Result has not been uploaded</p>
                            </div>
                      </div>
                    </td>
                @endif
                </tr>
              </tbody>
            </table>
          </td>
        </tr>
        @endforeach

      </tbody>
      
    </table>
</div>
</section>

@endsection