@extends('layouts.main')
@section('content')
	<section class="ui raised segment" style="max-width: 90%; margin: 30px auto;">
	    <h2 class="ui horizontal divider header" style="color:#dc4900;">
		  View School
		</h2>
		
		<div class="search-bar">
			<div class="ui stackable equal height stackable grid">
				<div class="seven wide column">
					<form method="get" action="" class="form form-horizontal global_form">
							<div class="ui left action input fluid">
									<button class="ui orange labeled icon button">
											<i class="search icon"></i>
											Search KEYWORD:
									</button>
									<input type="text" placeholder="Enter keyword..." name="name_keyword" value="">
							</div>
					</form>
				</div>
				<div class="two wide column">
					<h2 class="ui horizontal divider header" style="margin-top: 8px;color:#dc4900;text-align: center;">Or</h2>
				</div>
				<div class="seven wide column">
					<form method="get" action="" class="form form-horizontal global_form">
							<div class="second">
									<div class="fields">
											<div class="sixteen wide field">
													<div class="ui left action input fluid">
															<button class="ui orange labeled icon button">
																	<i class="search icon"></i>
																	Search with LGA:
															</button>
															<select name="lga_keyword" class="ui search fluid dropdown">
																<option value="">Choose LGA</option>
																@if($item_rows = DB::table('ondo_lgas')->get())
																		@foreach ($item_rows as $item_data)
																		<option value="{{$item_data->id}}">{{$item_data->name}}</option>
																		@endforeach
																@endif
														</select>
													</div>
											</div>
									</div>
							</div>
					</form>
				</div>
			</div>
		</div>
		<table class="ui celled table">
		  <thead>
		      <tr>
		          <th>
					<form method="POST" action="" class="form form-horizontal global_form">
					    <input type="hidden" name="_token" value="{{csrf_token()}}">
						<div class="ui left action input fluid">
							<button class="ui orange labeled icon button">
									<i class="money icon"></i>
									Set Digital Payment Fee
							</button>
							<input type="number" min="0" step="0.01" placeholder="Enter amount..." name="digital_amount" value="{{DB::table('payment_items')->first()->cost}}">
						</div>
					</form>
		          </th>
		      </tr>
		    <tr>
			  	<th>
			    	<div class="ui ribbon label">School name</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">School LGA</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">School Balance</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">School Phone Contact</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">Wallet Top-Up</div>
			    </th>
			    <th colspan="2">
			    	<div class="ui ribbon label">Actions on School</div>
			    </th>
			 </tr>
		  </thead>
		  <tbody>
		  @if(count($schools) > 0)
		  	@foreach($schools as $school)
		  	@php
		  	    if($wallet = App\Wallet::find($school->wallet_id)){
		  	        $balance = money_format('%i', $wallet->available_balance);
		  	    }else{
		  	        $wallet = App\Wallet::create([
		  	            'cleared_balance' => 0.00,
		  	            'available_balance' => 0.00,
		  	            'last_payment' => 0.00,
		  	            'account_balance' => 0.00
		  	        ]);
		  	        
		  	        $school->wallet_id = $wallet->id;
		  	        $school->save();
		  	        
		  	        $balance = number_format(0.00, 2);
		  	    }
		  	@endphp
		  	<form action="" method="POST">
		    <tr>
		      <td>{{$school->name}}</td>
		      <td>{{$school->ondo_lga->name}}</td>
		      <td>₦{{$balance}}</td>
		      <td>
		      	<div class="ui input focus">
				  <input type="number" name="phone" placeholder="Phone (eg: 2348000000000 )" value="{{$school->phone}}" required>
				</div>
		      </td>
		      <td>
		      	<div class="ui input focus">
				  <input type="number" name="amount" min="0" step="0.01" placeholder="Top-Up Amount ₦0.00">
				</div>
		      </td>
		      <td class="">
	  		   <input type="hidden" name="_token" value="{{csrf_token()}}">
		          <input type="hidden" name="school_id" value="{{$school->id}}">
			      <button class="ui blue button" type="submit">
				  Add To Wallet
				</button>
		        </form>
		        <form action="" method="POST">
		            <input type="hidden" name="_token" value="{{csrf_token()}}">
		            <input type="hidden" name="amount" value="0.00">
		            <input type="hidden" name="school_id" value="{{$school->id}}">
		            <input type="hidden" name="phone" value="{{$school->phone}}">
		            <br>
    			    <button class="ui labeled red button icon" type="submit">
    			        Reset Wallet
    				  <i class="icon trash"></i>
    				</button>
		        </form>
		        <br>
		        <a href="{{route('super_admin.schools.wallet.transactions', ['school_id' => $school->id])}}" class="ui orange button" style="cursor: pointer;">Transactions</a>
			  </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="6">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr><th colspan="6">
		      @include('pagination.default', ['paginator' => $schools])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="jtr"></div>
@endsection