@extends('layouts.main')
@section('content')
<br>
<section class="ui raised segment" style="max-width: 1200px; margin: 20px auto;">
	<h2 class="ui horizontal divider cap header" style="color:#dc4900;">
	  {{ucwords($school->name)}}'s Wallet Transaction History
	</h2>
	@php $transactions = App\Transaction::where('school_id', $school->id)->paginate(20) @endphp
	<a href="{{route('super_admin.schools.wallet')}}" class="ui labeled button red icon"> Back to schools wallet <i class="icon angle left"></i></a>
    <div class="ui feed">
    @forelse($transactions as $transaction)
	  <div class="event">
	    <div class="label">
	      <img src="{{url_public($school->logo)}}">
	    </div>
	    <div class="content">
	      <div class="summary">
	        {{$transaction->title}}
	      </div>
	      <div class="date">
	        <small>{{$transaction->created_at->diffForHumans()}}</small>
	      </div>
	      <div class="extra text">
	        {{$transaction->description}}
	      </div>
	    </div>
	  </div>
	@empty
		<div class="ui icon negative message">
		  <i class="info circle icon"></i>
		  <div class="content">
		    <div class="header">
		    Sorry, No Record can be found.
		  	</div>
		  </div>
		</div>
	@endforelse
	</div>
	@if($transactions->count() > 0)
    @include('pagination.default', ['paginator' => $transactions])
    @endif
</section>
<style>
.ext{
    width: 100% !important;
}
.ext .card{
    width: 100% !important;
}
.ext .card .item{
    text-align: left;
    padding: 13px;
}
.ext .card .content{
    text-align: right;
    float: right;
}
</style>
@endsection