@extends('layouts.main')

@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">

		<h2 class="ui horizontal divider header print-none" style="color:#dc4900;">
		  <i class="student icon"></i>
		  
		</h2>
	@if(auth('super_admin')->user()->can('delete-scratch-card'))
		@include('partial.error')
	  <form action="{{route('super_admin.generate.scratch_card')}}" method="post" class="ui form print-none">
		<div class="two fields">
		{{csrf_field()}}
	      <div class="field">
	        <label>Number of Scratch Card</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="iteration" value="{{old('iteration')}}"  >
	          <i class="dropdown icon"></i>
	          <div class="default text">Select Number of Scratch Card</div>
	          <div class="menu">
	            @foreach($iterations as $iteration)
	             <div class="item" data-value="{{$iteration}}">{{$iteration}}</div>
	            @endforeach
	          </div>
	        </div>
	      </div>
	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white; margin-top:24px;">Generate Scratch Cards</button>
	      </div>
	     </div>
	    </form>
	 @endif
	   <form action="{{route('super_admin.delete.scratch_card')}}" method="post" class="ui form">
	   {{csrf_field()}}
	   <input type="hidden" name="_method" value="delete">
		<table class="ui celled table">
		  <thead>
		    <tr>
		    	<th>
			    	S/N
			    </th>
			    <th>
			    	Serial Number
			    </th>
			    <th>
			    	Pin
			    </th>
			    <th>
			    	ISSI Number
			    </th>
			    <th >
			    	Select Cards
			    	<div class="ui toggle checkbox check-all">
						<input type="checkbox" class="">
						<label>Select All</label>
					</div>
			    </th>
			 </tr>
		  </thead>
		  <tbody>
		  @php $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $vouchers->perPage() @endphp
		  	@forelse($vouchers as $voucher)
		    <tr>
		      <td>{{++$counter}}</td>
		      <td>{{$voucher->serial}}</td>
		      <td>{{$voucher->pin}}</td>
	            <td>{{getStudentISSI($voucher->student_id)}}</td>
		      <td class="std-view">
			     <div class="ui toggle checkbox studentID">
					<input type="checkbox" name="scratch_cards[]" value="{{$voucher->id}}"><label></label>
				</div>
			  </td>
		    </tr>
		   @empty
			<tr>
				<th colspan="5">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endforelse
		  </tbody>
		  <tfoot>
		  @if($vouchers->count() > 0 && auth('super_admin')->user()->can('delete-scratch-card'))
		  	<tr>
		  		<td colspan="5"><button class="fluid ui disabled scratch-card button red" type="submit" style="background-color: #f75a0c; color:white;">Delete Scratch Cards</button></td>
		  	</tr>
		  @endif
		  	<tr>
		  		<td colspan="5"><button class="ui scratch-card button" type="button" onClick="print()" style="background-color: #f75a0c; color:white;">Print</button></td>
		  	</tr>
		  	<tr>
		  		<td colspan="5">
		  			@include('pagination.default', ['paginator' => $vouchers])
		  		</td>
		  	</tr>
		  </tfoot>
		</table>
		
	</form>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
<style type="text/css">
@media print{
	.print-none{
		display: none !important;
	}
}
</style>
@endsection