@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">
    <h2 class="ui dividing header printnone text_center"> {{ $title }} </h2>
    <div class="ui stackable equal height stackable grid">
        <div class="four wide column printnone">
            <div class="ui vertical fluid tabular menu">
            <a href="{{url('ministry/unity/view')}}" class="item @if(!isset($_GET['action']) || $_GET['action'] == '') active @endif">
                Entrance Examination Center
            </a>
            <a href="{{url('ministry/unity/view?action=allocate-hall')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'allocate-hall') active @endif">
                Entrance Examination Hall
            </a>
            <a href="{{url('ministry/unity/view?action=view-students')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'view-students') active @endif">
                View Registered Students
            </a>
            <a href="{{url('ministry/unity/view?action=statistics')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'statistics') active @endif">
                Exam Statistics
            </a>
            <a href="{{url('ministry/unity/view?action=assign-students')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'assign-students') active @endif">
                Assign Students To Hall
            </a>
            </div>
        </div>
        <div class="twelve wide column">
            <div class="ui segment less">
                @if(isset($_GET['action']) && $_GET['action'] == 'allocate-hall')
                    @include('super-admin.unity.layouts.allocate-hall')
                @elseif(isset($_GET['action']) && $_GET['action'] == 'view-students')
                    @include('super-admin.unity.layouts.view-students')
                @elseif(isset($_GET['action']) && $_GET['action'] == 'statistics')
                    @include('super-admin.unity.layouts.statistics')
                @elseif(isset($_GET['action']) && $_GET['action'] == 'assign-students')
                    @include('super-admin.unity.layouts.assign-students')
                @else
                    @include('super-admin.unity.layouts.allocate-center ')
                @endif
            </div>
        </div>
    </div>
</section>
<div class="jtr"></div>
<script type="text/javascript">
	$(document).ready(function(){
        $('.create--hall input.lgaSelect').on('change', function(){
            //get permissions with ajax
            var select = $(this);
            var route = $(this).attr('data-href');
            $('.create--hall .field.centers').addClass('loading');
            $.ajax({
                url: route,
                keyboardShortcuts: false,
		        headers: {'X-CSRF-TOKEN': $('meta[name=csrf_token]').attr('content')},
		        data: {
		            lga_id: select.val()
		        },
		        type: 'POST',
		        // datatype: 'JSON',
		        success: function (response) {
                    var center = $('.create--hall .Centers .menu');
                    center.html('');
                    $.each(response, function(index, value){
                        center.append('<div class="item" data-value="'+value.id+'">'+value.name.toUpperCase()+'</div>');
                    });
                    $('.create--hall .field.centers').removeClass('loading');
                },
                error: function(error){
                    console.log(error);
                    $('.create--hall .field.centers').removeClass('loading');
                }
		    });
	    });


        $('.delete--hall input.lgaSelect').on('change', function(){
            //get permissions with ajax
            var select = $(this);
            var route = $(this).attr('data-href');
            $('.delete--hall .field.centers').addClass('loading');
            $.ajax({
                url: route,
                keyboardShortcuts: false,
		        headers: {'X-CSRF-TOKEN': $('meta[name=csrf_token]').attr('content')},
		        data: {
		            lga_id: select.val()
		        },
		        type: 'POST',
		        // datatype: 'JSON',
		        success: function (response) {
                    var center = $('.delete--hall .Centers .menu');
                    center.html('');
                    $.each(response, function(index, value){
                        center.append('<div class="item" data-value="'+value.id+'">'+value.name.toUpperCase()+'</div>');
                    });
                    $('.delete--hall .field.centers').removeClass('loading');
                },
                error: function(error){
                    console.log(error);
                    $('.delete--hall .field.centers').removeClass('loading');
                }
		    });
	    });

        $('.delete--hall input.centerSelect').on('change', function(){
            //get permissions with ajax
            var select = $(this);
            var route = $(this).attr('data-href');
            $('.delete--hall .field.halls').addClass('loading');
            $.ajax({
                url: route,
                keyboardShortcuts: false,
		        headers: {'X-CSRF-TOKEN': $('meta[name=csrf_token]').attr('content')},
		        data: {
		            center_id: select.val()
		        },
		        type: 'POST',
		        // datatype: 'JSON',
		        success: function (response) {
                    var center = $('.delete--hall #halls .menu');
                    center.html('');
                    $.each(response, function(index, value){
                        center.append('<div class="item" data-value="'+value.id+'">'+value.name.toUpperCase()+'</div>');
                    });
                    $('.delete--hall .field.halls').removeClass('loading');
                },
                error: function(error){
                    console.log(error);
                    $('.delete--hall .field.halls').removeClass('loading');
                }
		    });
	    });


        $('.delete--center input.lgaSelect').on('change', function(){
            //get permissions with ajax
            var select = $(this);
            var route = $(this).attr('data-href');
            $('.delete--center .field.centers').addClass('loading');
            $.ajax({
                url: route,
                keyboardShortcuts: false,
		        headers: {'X-CSRF-TOKEN': $('meta[name=csrf_token]').attr('content')},
		        data: {
		            lga_id: select.val()
		        },
		        type: 'POST',
		        // datatype: 'JSON',
		        success: function (response) {
                    var center = $('.delete--center .Centers .menu');
                    center.html('');
                    $.each(response, function(index, value){
                        center.append('<div class="item" data-value="'+value.id+'">'+value.name.toUpperCase()+'</div>');
                    });
                    $('.delete--center .field.centers').removeClass('loading');
                },
                error: function(error){
                    console.log(error);
                    $('.delete--center .field.centers').removeClass('loading');
                }
		    });
	    });
	});
</script>
<style>
.wallpaper{
    position: relative;
    height: 250px;
    width: 100%;
    background: red;
}
.wallpaper img{
    position: absolute;
    width: 100%;
    height: 100%;
    filter: brightness(0.4);
}
.wallpaper h1{
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: #fff;
    font-size: 3em;
    text-transform: uppercase;
    text-align: center;
}
@media print{
    .printnone{
        display: none;
    }
    .ui.segment.less{
        width: fit-content;
        justify-content: center;
        margin: 0 auto;
    }
}
</style>
@endsection