<div class="c7">
    <h1 class="ui printnone horizontal divider">View Registered Students</h1>
    <form class="ui printnone form delete--center" action="{{route('super_admin.unity.view.centers')}}" method="post">
        {{csrf_field()}}
        <input type="hidden" name="type" value="student">
        <div class="two fields">
            <div class="field" class="field-lga">
                <div class="ui fluid search selection dropdown">
                <input type="hidden" name="lga_id" class="lgaSelect" value="{{old('lga_id')}}" data-href="{{url('/do-ajax/unity-get-center')}}">
                <i class="dropdown icon"></i>
                <div class="default text">Local Govt. Area</div>
                <div class="menu" class="state-lga">
                    @php $ngstate_lgas = App\OndoLGA::all();  @endphp
                    @foreach($ngstate_lgas as $ngstateLGA)
                    <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach
                </div>
                </div>
            </div>
            <div class="field centers">
                <div class="ui fluid search selection dropdown Centers">
                <input type="hidden" name="center_id" value="{{old('center_id')}}">
                <i class="dropdown icon"></i>
                <div class="default text">Center Name.</div>
                <div class="menu">
                </div>
                </div>
            </div>
            <div class="field">
                <button class="fluid ui button blue" type="submit" style="color:white;">View Students</button>
            </div>
        </div>
    </form>
    <table class="ui celled structured fluid table">
        <thead>
            <tr>
                <th>
                    <div class="ui ribbon label">S/N</div>
                </th>
                <th>
                    <div class="ui ribbon label">Registration Number</div>
                </th>
                <th>
                    <div class="ui ribbon label">Student Name</div>
                </th>
                <th>
                    <div class="ui ribbon label">Student's Passport</div>
                </th>
                <th>
                    <div class="ui ribbon label">Student LGA</div>
                </th>
                <th>
                    <div class="ui ribbon label">Center Name</div>
                </th>
            </tr>
        </thead>
        <tbody>
            @php $lgaStudents = Session::get('lgaStudents'); @endphp
            @if(isset($lgaStudents) && !empty($lgaStudents))
                @forelse($lgaStudents as $Student)
                <tr style="text-transform:capitalize;">
                    <td>{{$Student->id}}</td>
                    <td >{{$Student->unity_exam->regnum}}</td>
                    <td>{{$Student->unity_exam->surname}} {{$Student->unity_exam->firstname}} {{$Student->unity_exam->middlename}}</td>
                    <td>
                        @if(!empty($Student->passport) && $Student->passport != null)
                        <img src="{{url_public($Student->passport)}}" class="ui small image" height="200">
                        @else
                        No Passport Yet
                        @endif
                    </td>
                    <td>{{App\NgStatesLGA::find($Student->unity_exam->lga_id)->name}}</td>
                    <td>{{App\UnityCenter::find($Student->school_center_id)->name}}</td>
                </tr>
                @empty
                <tr>
                    <th colspan="7">
                        <div class="ui icon negative message">
                        <i class="info circle icon"></i>
                        <div class="content">
                            <div class="header">
                            Sorry, No Record can be found.
                            </div>
                        </div>
                        </div>
                    </th>
                </tr>
                @endforelse
                <button onclick="print()" class="ui button orange printnone">Print Sheet</button>
            @endif
        </tbody>
    </table>
</div>