@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">
    <h2 class="ui dividing header printnone text_center"> {{ $title }} </h2>
    <div class="ui stackable equal height stackable grid">
        <div class="four wide column printnone">
            <div class="ui vertical fluid tabular menu">
            <a href="{{url('ministry/unity/view')}}" class="item">
                Entrance Examination Center
            </a>
            <a href="{{url('ministry/unity/view?action=allocate-hall')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'allocate-hall') active @endif">
                Entrance Examination Hall
            </a>
            <a href="{{url('ministry/unity/view?action=view-students')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'view-students') active @endif">
                View Registered Students
            </a>
            <a href="{{url('ministry/unity/view?action=statistics')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'statistics') active @endif">
                Exam Statistics
            </a>
            <a href="{{url('ministry/unity/view?action=assign-students')}}" class="item active">
                Assign Students To Hall
            </a>
            </div>
        </div>
        <div class="twelve wide column">
            <div class="ui segment less">
                <div class="c7">
                    <form class="ui form create--hall" action="{{route('super_admin.unity.assign.students')}}" method="post">
                        {{csrf_field()}}
                        <h2 class="ui dividing header">View Students To Allocate To Hall</h2>
                        <div class="three fields">
                            <div class="field" class="field-lga">
                                <label>Local Govt Area.</label>
                                <div class="ui fluid search selection dropdown">
                                <input type="hidden" name="lga_id" class="lgaSelect" value="{{old('lga_id')}}" data-href="{{url('/do-ajax/unity-get-center')}}">
                                <i class="dropdown icon"></i>
                                <div class="default text">Local Govt. Area</div>
                                <div class="menu" class="state-lga">
                                    @php $ngstate_lgas = App\OndoLGA::all();  @endphp
                                    @foreach($ngstate_lgas as $ngstateLGA)
                                    <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                                    @endforeach
                                </div>
                                </div>
                            </div>
                            <div class="field centers">
                                <label>Center Name.</label>
                                <div class="ui fluid search selection dropdown Centers">
                                <input type="hidden" name="unity_centers_id" value="{{old('unity_centers_id')}}">
                                <i class="dropdown icon"></i>
                                <div class="default text">Center Name.</div>
                                <div class="menu">
                                </div>
                                </div>
                            </div>
                            <div class="field">
                                <button class="fluid ui button blue" type="submit" style="color:white;margin-top:24px;">View Students</button>
                            </div>
                        </div>
                    </form>

                    <table class="ui celled structured fluid table">
                        <thead>
                            <tr>
                                <th>
                                    <div class="ui ribbon label">S/N</div>
                                </th>
                                <th>
                                    <div class="ui ribbon label">Registration Number</div>
                                </th>
                                <th>
                                    <div class="ui ribbon label">Student Name</div>
                                </th>
                                <th>
                                    <div class="ui ribbon label">Center Name</div>
                                </th>
                                <th >
                                    <div class="ui toggle checkbox check-all">
                                        <input type="checkbox" class="">
                                        <label>Select All</label>
                                    </div>
                                </th>
                            </tr>
                        </thead>
                        <form action="{{route('super_admin.unity.assign.students.post')}}" method="post">
                        {{csrf_field()}}
                        <tbody>
                            @if(isset($students) && !empty($students))
                                @forelse($students as $Student)
                                <tr style="text-transform:capitalize;">
                                    <td>{{$Student->id}}</td>
                                    <td >{{$Student->unity_exam->regnum}}</td>
                                    <td>{{$Student->unity_exam->surname}} {{$Student->unity_exam->firstname}} {{$Student->unity_exam->middlename}}</td>
                                    <td>{{App\UnityCenter::find($Student->school_center_id)->name}}</td>
                                    <td class="std-view">
                                        @if($Student->unity_exam->submitted != 0)
                                            <div class="ui toggle checkbox studentID">
                                               <input type="checkbox" name="student_id[]" class="formCheckbox" value="{{$Student->id}}" @if(!empty(old('student_id'))){{in_array($Student->id, old('student_id')) ? 'checked="checked"' : ''}}@endif><label></label>
                                           </div>
                                       @else
                                           <p style="color:red;">Student data hasn't been saved</p>
                                       @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <th colspan="7">
                                        <div class="ui icon negative message">
                                        <i class="info circle icon"></i>
                                        <div class="content">
                                            <div class="header">
                                            Sorry, No Record can be found.
                                            </div>
                                        </div>
                                        </div>
                                    </th>
                                </tr>
                                @endforelse
                            @endif
                        </tbody>
                    </table>
                    <br>
                    <div class="ui form">
                        <div class="two fields">
                            <div class="field">
                                <label>Select Hall</label>
                                <div class="ui fluid search selection dropdown">
                                <input type="hidden" name="hall_id" required />
                                <i class="dropdown icon"></i>
                                <div class="default text">Select Hall</div>
                                    <div class="menu" class="state-lga">
                                        @foreach($halls as $hall)
                                        <div class="item" data-value="{{$hall->id}}">{{$hall->name}}</div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <div class="field">
                                <button class="fluid ui button blue" type="submit" style="color:white;margin-top:24px;">View Students</button>
                            </div>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="jtr"></div>
<script type="text/javascript">
	$(document).ready(function(){
        $('.create--hall input.lgaSelect').on('change', function(){
            //get permissions with ajax
            var select = $(this);
            var route = $(this).attr('data-href');
            $('.create--hall .field.centers').addClass('loading');
            $.ajax({
                url: route,
                keyboardShortcuts: false,
		        headers: {'X-CSRF-TOKEN': $('meta[name=csrf_token]').attr('content')},
		        data: {
		            lga_id: select.val()
		        },
		        type: 'POST',
		        // datatype: 'JSON',
		        success: function (response) {
                    var center = $('.create--hall .Centers .menu');
                    center.html('');
                    $.each(response, function(index, value){
                        center.append('<div class="item" data-value="'+value.id+'">'+value.name.toUpperCase()+'</div>');
                    });
                    $('.create--hall .field.centers').removeClass('loading');
                },
                error: function(error){
                    console.log(error);
                    $('.create--hall .field.centers').removeClass('loading');
                }
		    });
	    });


        $('.delete--hall input.lgaSelect').on('change', function(){
            //get permissions with ajax
            var select = $(this);
            var route = $(this).attr('data-href');
            $('.delete--hall .field.centers').addClass('loading');
            $.ajax({
                url: route,
                keyboardShortcuts: false,
		        headers: {'X-CSRF-TOKEN': $('meta[name=csrf_token]').attr('content')},
		        data: {
		            lga_id: select.val()
		        },
		        type: 'POST',
		        // datatype: 'JSON',
		        success: function (response) {
                    var center = $('.delete--hall .Centers .menu');
                    center.html('');
                    $.each(response, function(index, value){
                        center.append('<div class="item" data-value="'+value.id+'">'+value.name.toUpperCase()+'</div>');
                    });
                    $('.delete--hall .field.centers').removeClass('loading');
                },
                error: function(error){
                    console.log(error);
                    $('.delete--hall .field.centers').removeClass('loading');
                }
		    });
	    });

        $('.delete--hall input.centerSelect').on('change', function(){
            //get permissions with ajax
            var select = $(this);
            var route = $(this).attr('data-href');
            $('.delete--hall .field.halls').addClass('loading');
            $.ajax({
                url: route,
                keyboardShortcuts: false,
		        headers: {'X-CSRF-TOKEN': $('meta[name=csrf_token]').attr('content')},
		        data: {
		            center_id: select.val()
		        },
		        type: 'POST',
		        // datatype: 'JSON',
		        success: function (response) {
                    var center = $('.delete--hall #halls .menu');
                    center.html('');
                    $.each(response, function(index, value){
                        center.append('<div class="item" data-value="'+value.id+'">'+value.name.toUpperCase()+'</div>');
                    });
                    $('.delete--hall .field.halls').removeClass('loading');
                },
                error: function(error){
                    console.log(error);
                    $('.delete--hall .field.halls').removeClass('loading');
                }
		    });
	    });


        $('.delete--center input.lgaSelect').on('change', function(){
            //get permissions with ajax
            var select = $(this);
            var route = $(this).attr('data-href');
            $('.delete--center .field.centers').addClass('loading');
            $.ajax({
                url: route,
                keyboardShortcuts: false,
		        headers: {'X-CSRF-TOKEN': $('meta[name=csrf_token]').attr('content')},
		        data: {
		            lga_id: select.val()
		        },
		        type: 'POST',
		        // datatype: 'JSON',
		        success: function (response) {
                    var center = $('.delete--center .Centers .menu');
                    center.html('');
                    $.each(response, function(index, value){
                        center.append('<div class="item" data-value="'+value.id+'">'+value.name.toUpperCase()+'</div>');
                    });
                    $('.delete--center .field.centers').removeClass('loading');
                },
                error: function(error){
                    console.log(error);
                    $('.delete--center .field.centers').removeClass('loading');
                }
		    });
	    });
	});
</script>
<style>
.wallpaper{
    position: relative;
    height: 250px;
    width: 100%;
    background: red;
}
.wallpaper img{
    position: absolute;
    width: 100%;
    height: 100%;
    filter: brightness(0.4);
}
.wallpaper h1{
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: #fff;
    font-size: 3em;
    text-transform: uppercase;
    text-align: center;
}
@media print{
    .printnone{
        display: none;
    }
    .ui.segment.less{
        width: fit-content;
        justify-content: center;
        margin: 0 auto;
    }
}
</style>
@endsection