@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="{{route('super_admin.register.teacher')}}" method="post">
  <h2 class="ui dividing header">Teacher Registration</h2>
  <div class="field">
    <input type="hidden" value="{{csrf_token()}}" name="_token">
    <label>Name</label>
    <div class="four fields">
      <div class="field">
        <input type="text" name="title" value="{{old('title')}}" placeholder="Title">
      </div>
      <div class="field">
        <input type="text" name="surname" value="{{old('surname')}}" placeholder="Surname">
      </div>
      <div class="field">
        <input type="text" name="firstname" value="{{old('firstname')}}" placeholder="First Name">
      </div>
      <div class="field">
        <input type="text" name="middlename" value="{{old('middlename')}}" placeholder="Other Name">
      </div>
    </div>
  </div>
  <div class="three fields">
    <div class="field states">
      <label>School State</label>
      <div class="ui fluid search selection dropdown states-dropdown" >
        <input type="hidden" name="school_state_id" @if(!empty(old('school_state_id')))
            value="{{old('school_state_id')}}"
          @else
            value="{{$school_ngstate->id}}"
          @endif>
        <i class="dropdown icon"></i>
        <div class="default text">States</div>
        <div class="menu">
           <div class="item" data-value="{{$school_ngstate->id}}">{{$school_ngstate->name}}</div>
        </div>
      </div>
    </div>
    <div class="field field-lga">
      <label>School Local Govt Area.</label>
      <div class="ui fluid search selection dropdown wrap-slgas school-wrap-slgas">
        <input type="hidden" name="school_lga_id" value="{{old('school_lga_id')}}" data-href="{{url('/do-ajax/school')}}">
        <i class="dropdown icon"></i>
        <div class="default text">Local Govt. Area</div>
        <div class="menu">
          @foreach($ngstate_lgas as $ngstateLGA)
           <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
          @endforeach
        </div>
      </div>
    </div>
    <div class="field" id="field-school">
      <label>School</label>
      <div class="ui fluid search selection dropdown" id="wrap-schools">
        <input type="hidden" name="school" value="{{old('school')}}" data-href="{{url('/do-ajax/classes')}}">
        <i class="dropdown icon"></i>
        <div class="default text">Schools</div>
        <div class="menu" id="school-options-handler">
          @if(!empty(old('school')))
              @foreach(getSchools(old('school')) as $school)
               <div class="item" data-value="{{$school->id}}">{{$school->name}}</div>
              @endforeach
            @else
               <div class="item" data-value="">Schools</div>
            @endif
        </div>
      </div>
    </div>
  </div>

   <div class="field">
    <div class="three fields">
      <div class="field">
        <label>Qualification</label>
        <input type="text" name="qualification" value="{{old('qualification')}}" placeholder="Other Name">
      </div>
      <div class="field">
        <label>Gender</label>
        <div class="ui fluid search selection dropdown">
          <input type="hidden" name="gender" value="{{old('gender')}}">
          <i class="dropdown icon"></i>
          <div class="default text">Gender</div>
          <div class="menu">
             <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
             <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
          </div>
        </div>
      </div>
      <div class="field" id="field-subject">
        <label>Subject Area</label>
         <select multiple="" class="ui dropdown" name="subjects[]" id="subject-options-handler" placeholder="Select Subject Areas">
            @if(!empty(old('school')))
             @foreach(getSubjects(old('school')) as $subject)
              <option  value="{{$subject->id}}" 
              @if(!empty(old('subjects')) && in_array($subject->id, old('subjects')))
                  selected="selected"
              @endif
              >{{$subject->subject_name}}({{$subject->class_category}})</option>
             @endforeach
             @else
             <option value=""> Select Subjects Area</option>
            @endif
         </select>
      </div>
  </div>
  </div>

  <div class="field">
    <div class="fields">
      <div class="ten wide field">
      <label>Contact Address</label>
        <input type="text" name="address" value="{{old('address')}}" placeholder="Contact Address">
      </div>
      <div class="three wide field">
        <label>State of Origin</label>
        <div class="ui fluid search selection dropdown" id="states-dropdown">
          <input type="hidden" name="state_id" value="{{old('state_id')}}" data-href="{{url('/do-ajax/state')}}">
          <i class="dropdown icon"></i>
          <div class="default text">States</div>
          <div class="menu">
            @foreach($ngstates as $ngstate)
             <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
            @endforeach
          </div>
        </div>
      </div>
      <div class="three wide field" id="field-lga">
        <label>State Local Govt Area.</label>
        <div class="ui fluid search selection dropdown just-state-lga" id="wrap-slgas">
          <input type="hidden" name="lga_id" value="{{old('lga_id')}}">
          <i class="dropdown icon"></i>
          <div class="default text">State LGA</div>
          <div class="menu" id="state-lga">
              @if(!empty(old('state_id')))
                @foreach(getStateLGAs(old('state_id')) as $ngstateLGA)
                 <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                @endforeach
              @else
                 <div class="item" data-value="">Select State LGA</div>
              @endif
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="field">
    <div class="fields">
      <div class="four wide field">
      <label>Teacher's Email</label>
        <input type="email" name="email" value="{{old('email')}}" placeholder="Teacher's Email">
      </div>
      <div class="four wide field">
        <label>Teacher's Phone Number</label>
          <input type="text" name="phone" value="{{old('phone')}}" placeholder="Teacher's Phone Number">
      </div>

      <div class="four wide field">
      <label>Teacher's Password</label>
        <input type="password" name="password" value="{{old('password')}}" placeholder="Teacher's Password">
      </div>
      <div class="four wide field">
        <label>Teacher's Confirm Password</label>
        <input type="password" name="password_confirmation" value="{{old('password_confirmation')}}" placeholder="Teacher's Confirm Password">
      </div>
    </div>
  </div>


  <div class="field">
    <div class="three fields">
      <div class="field">
          <label>Session</label>
          <div class="ui fluid search selection dropdown">
            <input type="hidden" name="session" value="{{old('session')}}">
            <i class="dropdown icon"></i>
            <div class="default text">Session</div>
            <div class="menu">
              @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
               <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
              @endfor
            </div>
          </div>
        </div>
        <div class="field">
          <label>Marital Status</label>
          <div class="ui fluid search selection dropdown">
            <input type="hidden" name="marital_status" value="{{old('marital_status')}}">
            <i class="dropdown icon"></i>
            <div class="default text">Marital Status</div>
            <div class="menu">
               <div class="item" data-value="Single">Single</div>
               <div class="item" data-value="Married">Married</div>
               <div class="item" data-value="Divorce">Divorce</div>
            </div>
          </div>
        </div>
    </div>
  </div>




  <h4 class="ui dividing header">Next of kins Information</h4>
  <div class="field">
    <div class="fields">
      <div class="six wide field">
      <label>Next of knis Fullname</label>
        <input type="text" name="next_of_kins" value="{{old('next_of_kins')}}" placeholder="Next of kins Fullname">
      </div>
      <div class="ten wide field">
        <label>Next of kins Contact Address</label>
        <input type="text" name="next_of_kins_address" value="{{old('next_of_kins_address')}}" placeholder="Next of kins Contact Address">
      </div>
    </div>
  </div>
  <div class="field">
    <div class="fields">
      <div class="four wide field">
      <label>Next of kins Email</label>
        <input type="email" name="next_of_kins_email" value="{{old('next_of_kins_email')}}" placeholder="Next of kins Email">
      </div>
      <div class="four wide field">
        <label>Next of kins Phone Number</label>
        <input type="text" name="next_of_kins_phone" value="{{old('next_of_kins_phone')}}" placeholder="Next of kins Phone Number">
      </div>
    </div>
  </div>

    <h4 class="ui dividing header">Teacher Health Information</h4>
  <div class="field">
    <div class="fields">
      <div class="four wide field">
        <label>Health Status</label>
        <div class="ui fluid search selection dropdown">
          <input type="hidden" name="health_status" value="{{old('health_status')}}">
          <i class="dropdown icon"></i>
          <div class="default text">Health Status</div>
          <div class="menu">
             <div class="item" data-value="Normal">Normal</div>
             <div class="item" data-value="Disable">Disable</div>
          </div>
        </div>
      </div>
      <div class="four wide field">
        <label>Extra Curricular Activities</label>
         <input type="text" name="extra_curricular_activites" value="{{old('extra_curricular_activites')}}" placeholder="Teacher Extra Curricular Activities">
      </div>
      <div class="six wide field">
        <label>Health Status Description</label>
        <textarea rows="4" name="health_status_desc">{{old('health_status_desc')}}</textarea>
      </div>
  </div>
    <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Register Teachers</button>
  
  </form>
</section>
<div class="jtr"></div>
@endsection