@extends('layouts.main')
@section('content')
	<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
		@include('partial.error')
		<form class="ui form" action="" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		  <h2 class="ui dividing header">Batch Teacher Registration</h2>
		  <div class="four fields">
          <div class="field states">
                <label>School State</label>
                <div class="ui fluid search selection dropdown" id="states-dropdown">
                  <input type="hidden" name="state_id" @if(!empty(old('state_id')))
                      value="{{old('state_id')}}"
                    @else
                      value="{{$school_ngstate->id}}"
                    @endif>
                  <i class="dropdown icon"></i>
                  <div class="default text">States</div>
                  <div class="menu">
                     <div class="item" data-value="{{$school_ngstate->id}}">{{$school_ngstate->name}}</div>
                  </div>
                </div>
              </div>
              <div class="field" id="field-lga">
                <label>School Local Govt Area.</label>
                <div class="ui fluid search selection dropdown wrap-slgas" id="">
                  <input type="hidden" name="school_lga_id" value="{{old('school_lga_id')}}" data-href="{{url('/do-ajax/school')}}">
                  <i class="dropdown icon"></i>
                  <div class="default text">Local Govt. Area</div>
                  <div class="menu" id="state-lga">
                    @foreach($ngstate_lgas as $ngstateLGA)
                     <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach
                  </div>
                </div>
              </div>

              <div class="field" id="field-school">
                <label>School</label>
                <div class="ui fluid search selection dropdown" id="wrap-schools">
                  <input type="hidden" name="school" value="{{old('school')}}" data-href="{{url('/do-ajax/classes')}}">
                  <i class="dropdown icon"></i>
                  <div class="default text">Schools</div>
                  <div class="menu" id="school-options-handler">
                    @if(!empty(old('school')))
                        @foreach(getSchools(old('school')) as $school)
                         <div class="item" data-value="{{$school->id}}">{{$school->name}}</div>
                        @endforeach
                    @endif
                  </div>
                </div>
              </div>

            <div class="field">
	          <label>Session</label>
	          <div class="ui fluid search selection dropdown">
	            <input type="hidden" name="session" value="{{old('session')}}">
	            <i class="dropdown icon"></i>
	            <div class="default text">Session</div>
	            <div class="menu">
	              @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
	               <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
	              @endfor
	            </div>
	          </div>
	        </div>
        </div>
		  <div class="fields">
		      <div class="six wide field">
		      	<label>File Upload</label>
		      	<div class="ui right action input">
				  <input type="text" class="pseudo-batch-file-name" name="pseudo_batch_file_name" >
				  <button type="button" class="ui orange labeled icon button pseudo-batch-file">
				    <i class="file excel outline icon"></i>
				    Upload Excel File
				  </button>
				</div>
        		<input type="file" name="batch_file" id="batch_file" class="batch-file" style="display: none">
		      </div>
		  </div>
		  <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;-">Batch Register Teachers</button>
		</form>
	</section>
@endsection