@extends('layouts.main-datatable')
@section('content')   


<style>
.ui.celled.table tr th, .ui.celled.table tr td {
	font-size: 12.5px;
}
.label-success {
    background-color: #5cb85c;
}
.label-default {
    background-color: #777;
}
.label-primary {
    background-color: #337ab7;
}
.label-danger {
    background-color: #d9534f;
}
.label {
    display: inline;
    padding: .2em .6em .3em;
    font-size: 100%;
    font-weight: 700;
    line-height: 1;
    color: #fff;
    text-align: center;
    white-space: nowrap;
    vertical-align: baseline;
    border-radius: .5em;
}
</style> 

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="" method="post">
  <h2 class="ui dividing header">All Tasks</h2>

		<table class="ui celled table" id="global_datatable">
		  <thead>
		    <tr>
            <th width="5%">S/N</th>
            <th>Title</th>
            <th width="10%">Start Date</th>
            <th width="10%">Due Date</th>
            <th width="10%">Status</th>
            <th width="9%">Approval</th>
		    <th>
		    	<div class="ui ribbon label"></div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if(count($tasks) > 0)
		  	@php
		  	$sn = 1
		  	@endphp
		  	@foreach($tasks as $task)
		    <tr>
		      <td>{{$sn}}</td>
		      <td>{{$task->title}}</td>
		      <td>{{$task->start_date}}</td>
		      <td>{{$task->due_date}}</td>
		      <td>
		      	<span class="label {{getTaskStatusWrapper($task->task_status)}}">
		      	{{getTaskStatus($task->task_status)}}
		      	</span>
		      </td>
		      <td>
		      	<span class="label {{$task->approval == 1 ? 'label-primary': 'label-success'}}">
		      		{{$task->approval == 1 ? 'Unapproved': 'Approved'}}
		      	</span>
		      </td>
		      <td>
		      	<div><a href="{{route('super_admin.task.board', ['id' => $task->id])}}"> Task Board </a></div>
		      </td>
		    </tr>
		  	@php
		  	$sn++
		  	@endphp
		   @endforeach
		    @else
			<tr>
				<th colspan="6">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record was found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		</table>
  
</form>
   
</section>

<div class="jtr"></div>

@endsection	