@extends('layouts.main')
@section('content')

<style>
.twelve {
  margin: 0 auto;
}
.header {
  text-align: center;
}
.form-group label {
    font-weight: bold;
}


.multiple_check {
    width:96%;
    height:200px;
    overflow-y:auto;
    padding: 5px 1.5%;
    border:1px solid #333;
}
.multiple_check div p {
    float:left;
    margin-right:10px;
}
.multiple_check div img {
    float:left;
    margin-top:5px;
}
.multiple_check table tbody tr td {
    padding-bottom:5px;
}

.pt5 {
    padding-top: 5px;
}


.ui.form input[type="text"], .ui.form select {
    border: 1px solid #696969;
}

.label-success {
    background-color: #5cb85c;
}
.label-default {
    background-color: #777;
}
.label-primary {
    background-color: #337ab7;
}
.label-danger {
    background-color: #d9534f;
}
.label-orange {
    background-color: #F2711C;
}
.label {
    display: inline;
    padding: .2em .6em .3em;
    font-size: 100%;
    font-weight: 700;
    line-height: 1;
    color: #fff;
    text-align: center;
    white-space: nowrap;
    vertical-align: baseline;
    border-radius: .5em;
}

.ui.raised.segments, .ui.raised.segment {
    background: #ebeff2;
}
.taskboard_main {
    background: #fff;
    padding: 2%;
    margin: 0 auto;
}
.taskboard_sidebar {
    background: #fff;
    padding: 2%;
    margin: 0 auto;
}

.rounded_edge_15 {
border-radius: 15px;
-webkit-border-radius: 15px;
-moz-border-radius: 15px;
}

.rounded_edge_10 {
border-radius: 10px;
-webkit-border-radius: 10px;
-moz-border-radius: 10px;
}

h4.board_header_text {
    font-size: 24px;
}
.board_header_text span {
    font-size: 12px;
}

.board_descrip {
    font-size: 14px;
    color: #444444;
    padding: 20px 0 10px 0;
}

.task_datebox {}

.task_dates {}

.task_datebox .task_dates li, .task_assigned_box .task_assigned_users li {
    float: left;
    display: inline-block;
    padding-right: 5px;
    padding-left: 5px;
}

.task_datebox .task_dates li {
    width: 50%;
}

.clear{
    clear: both;
}

ul.task_dates, ul.task_assigned_users {
    padding-inline-start: 0px;
    clear: both;
}

.task_assigned_box {
    margin-top: 20px;
}

.task_sub_header {
    font-size: 17px;
}

.float_lt {
    float: left;
}

.task_assigned_users_box {}

.task_assigned_users li {
    width: auto;
    background-color: #F2711C;
border-radius: 10px;
-webkit-border-radius: 10px;
-moz-border-radius: 10px;
color: #fff;
padding: 0px 5px 2px 5px;
margin-right: 10px;
margin-bottom: 10px;
}

.remove_assigned_user {
    color: #000;
    padding-left: 15px;
    padding-right: 5px;
}

.add-new-plus {
    height: 32px;
    text-align: center;
    width: 32px;
    display: block;
    line-height: 32px;
    color: #98a6ad;
    font-weight: 700;
    background-color: #ebeff2;
    border-radius: 50%;
    font-size: 18px;
}

#toggle_task_assign_form  {
    cursor: pointer;
    margin-top: 20px;
}

#toggle_task_assign_form div:nth-child(2) {
    margin-left: 10px;
    margin-top: 7px;
}

.task_assign_form {
    margin-top: 20px;
}
.ui.form input[type="text"] {
    width: 50%;
}

.text_center {
    text-align: center;
}

#task_assign_submit {
    margin-top: 10px;
}
</style> 

<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 1024px">
@include('partial.error')


    <div class="sixteen wide column">
  <h2 class="ui dividing header">Task Board</h2>
    </div>

        <div class="ten wide column">
            <div class="taskboard_main rounded_edge_15">

                <div class="board_header">
                    <h4 class="board_header_text">
                        {{$task->title}}
                    <span class="label {{getTaskStatusWrapper($task->task_status)}}">
                        {{getTaskStatus($task->task_status)}}
                    </span>
                    </h4>
                </div>

                <div class="board_descrip">
                    <p>{{$task->descrip}}</p>
                </div>

                <div class="task_datebox">
                    <ul class="task_dates">
                        <li>
                            <h5 class="font-600 m-b-5">Start Date</h5>
                            <p>{{\Carbon\Carbon::parse($task->start_date)->format('jS F, Y ')}}</p>
                        </li>

                        <li>
                            <h5 class="font-600 m-b-5">Due Date</h5>
                            <p>{{\Carbon\Carbon::parse($task->due_date)->format('jS F, Y ')}}</p>
                        </li>
                    </ul>

                    <div class="clear"></div>
                </div>

                <div class="task_assigned_box">
                    <h5 class="task_sub_header">Assigned to:</h5>
                    <div id="task_assigned_users_box" class="task_assigned_users_box">
                        @if(!empty($assigned_admins))
                            <ul class="task_assigned_users">
                            @foreach($assigned_admins as $assign_admin)
                                <li>{{ucwords(strtolower($assign_admin->fullname))}} <span class="remove_assigned_user">x</span></li>
                            @endforeach
                            </ul>
                            <div class="clear"></div>
                        @endif
                        <!--<ul class="task_assigned_users">
                            <li>sss <span class="remove_assigned_user">x</span></li>
                            <li>sss <span class="remove_assigned_user">x</span></li>
                        </ul>
                        <div class="clear"></div>-->
                    </div>

                    <div id="toggle_task_assign_form"></div>

                    <div id="task_assign_form_holder" class="task_assign_form" style="display: none;">
                        <form id="task_assign_form" class="ui form">
                            <div class="form-group">
                                    <div class="col-md-8">
                                        <input type="hidden" name="task_id" value="{{$task->id}}">
                                       <div class="multiple_check">
                                            <table>
                                                <tbody>
                                                    @if(!empty($super_admins))
                                                        <tr><td colspan="2">
                                                            <strong>Tick to Assign Super Admin</strong>
                                                        </td></tr>
                                                      @foreach($super_admins as $admin)
                                                        <tr>
                                                            <td width="15%">
                                                                <div class="pt5">
                                                                <input type="checkbox" name="member_ids[]" value="{{$admin->id}}" /> 
                                                                </div>
                                                            </td>
                                                            <td>
                                                                {{ucwords(strtolower($admin->fullname))}}
                                                            </td>
                                                        </tr>
                                                      @endforeach
                                                    @endif
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-md-4 text_center">
                                        <input type="button" class="ui small blue button" id="task_assign_submit" name="form_submit" value="Save Assigned Member" />
                                    </div>
                                </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>

        <div class="six wide column">
            <div class="taskboard_sidebar rounded_edge_15">
                <p><strong>Comment</strong></p>
            </div>
        </div>
  
</section>

<div class="jtr"></div>

<script>
var site_url = "{{url('/admin')}}";
var token = "{{csrf_token()}}";
var ajax_loader = "{{url_public('/images/ajax-loader.gif')}}";

var toggle_form_open = '<div class="add-new-plus float_lt">+</div><div class="float_lt">Assign Member to Task</div><div class="clear"></div>';

var toggle_form_close = '<div class="add-new-plus float_lt">-</div><div class="float_lt">Close Member Box</div><div class="clear"></div>';

$(document).ready(function(){
    $("#toggle_task_assign_form").html(toggle_form_open);
});

$(function() {
    $('#toggle_task_assign_form').on('click', function(){
        if($('#task_assign_form_holder').is(":visible")){
            $("#toggle_task_assign_form").html(toggle_form_open);
            $('#task_assign_form_holder').hide();
        }
        else{
            $("#toggle_task_assign_form").html(toggle_form_close);
            $('#task_assign_form_holder').show('slow');
        }
    });


    $('#task_assign_submit').on('click', function(e){

        var checkedValCount = 0;
        var member_ids = [];
        $('#task_assign_form input[type="checkbox"]:checked').each(function () {
            checkedValCount++;
            member_ids.push($(this).val());
        });

        if(checkedValCount > 0){
            var task_id             = $('#task_assign_form input[name="task_id"]').val();

            var token = "{{csrf_token()}}";
            var route = "{{route('super_admin.task.assign.members')}}";

            var form_data = {
                member_ids : member_ids,
                task_id : task_id,
                _token : token
            };

            $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
            $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
            $("#pagewrap_ajax_box").show('slow');          
            $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
            window.oncontextmenu = function(){return false;}    // Disable right click  
            $("input").prop('disabled', true);                 // Disable form input 

            $.ajax({
                url: route,
                type: 'POST',
                dataType:   "html",
                data: form_data,
                success: function(response){
                    window.oncontextmenu = function(){return true;}     // Enable right click
                    $("#pagewrap_ajax_box").html('');                  
                    $("#pagewrap_ajax_box").hide();                    
                    $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                    $("input").prop('disabled', false);                    // Enable form input   

                    if(response === '1'){
                        alert('Empty data submitted. Ensure you select at least one Task member.');
                    }
                    else if(response === '2'){
                        alert('All your admin selection had been assigned to the Task.');
                    }
                    else{
                        alert('Selected User have been successfully assigned to the Task')
                        $('#task_assign_form input[type="checkbox"]').attr("checked", false);
                        $("#task_assigned_users_box").html(response);
                    }
                },
                error: function(error){
                    window.oncontextmenu = function(){return true;}     // Enable right click
                    $("#pagewrap_ajax_box").html('');                  
                    $("#pagewrap_ajax_box").hide();                    
                    $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                    $("input").prop('disabled', false);                    // Enable form input    

                    alert('Error encountered while processing request. Pls try again shortly');
                }
            });

        }
        else{
            alert('You must tick or check at least ONE super admin member to assign');
        }

        e.preventDefault();
    });
});

</script>

@endsection 