@extends('layouts.main')
@section('content')
    <br>
    <div class="ui grid" style="padding: 10px;">
        <div class="three wide column">
            <div class="ui vertical fluid tabular menu">
                <a href="{{route('super_admin.schools-survey')}}" class="item">
                    Schools Survey
                </a>
                <a href="{{route('super_admin.teachers-survey')}}?lga_id=1&school=all" class="item @if(!isset($_GET['action']) || $_GET['action'] == '') active @endif">
                    View Teacher Survey
                </a>
                <div class="ui dropdown item">
                    <i class="dropdown icon"></i>
                    Filter Teacher Survey
                    <div class="menu">
                      <div class="header">Submenu</div>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && !isset($_GET['by'])) active @endif">General Filter</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=major_subject_specialization" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'major_subject_specialization') active @endif">Major Subject Specialization</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=minor_subject_specialization" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'minor_subject_specialization') active @endif">Minor Subject Specialization</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=major_and_minor_specialization" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'major_and_minor_specialization') active @endif">Major & Minor Subject Specialization</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=retirment_year" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'retirment_year') active @endif">Retirement Year</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=retirment_year_range" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'retirment_year_range') active @endif">Retirement Year Range</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=retirment_with_major_subject_specialization" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'retirment_with_major_subject_specialization') active @endif">Retirement With Major Subject Specialization</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=retirment_with_minor_subject_specialization" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'retirment_with_minor_subject_specialization') active @endif">Retirement With Minor Subject Specialization</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="thirteen wide stretched column">
            <div class="ui segment">
                @if(isset($_GET['action']) && $_GET['action'] == 'filter')
                <div class="c8">
                    <div class="teacher---sort">
                      <form class="ui form" action="{{route('super_admin.teachers-survey-sort')}}" method="post" onsubmit="event.preventDefault(); teacherSortSubmit(this);">
                          <input type="hidden" name="_token" value="{{csrf_token()}}">
                          <div class="field">
                            <label>Local Govt Area.</label>
                            <div class="ui fluid search selection dropdown">
                              <input type="hidden" name="lga_id" value="{{old('lga_id')}}" onchange="getSchools(this);" data-href="{{url('/do-ajax/school')}}" required>
                              <i class="dropdown icon"></i>
                              <div class="default text">Local Govt. Area</div>
                              <div class="menu" id="state-lga">
                                @foreach(App\OndoLGA::all() as $ngstateLGA)
                                 <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                                @endforeach
                              </div>
                            </div>
                          </div>
                          <div class="field" id="field-school">
                            <label>School</label>
                            <div class="ui fluid search selection dropdown" id="schoolsWrap">
                              <input type="hidden" name="school" value="{{old('school')}}" data-href="{{url('/do-ajax/classes')}}" required>
                              <i class="dropdown icon"></i>
                              <div class="default text">School</div>
                              <div class="menu" id="school-options-handler">
                                @if(isset($_GET['school']) && $_GET['school'] != 'all')
                                    @foreach(getSchools(old('school')) as $school)
                                     <div class="item" data-value="{{$school->id}}">{{$school->name}}</div>
                                    @endforeach
                                @else
                                  <div class="item" data-value="all">All Schools In Local Government Area</div>
                                @endif
                              </div>
                            </div>
                          </div>
                          @if(isset($_GET['by']) && $_GET['by'] =='major_subject_specialization' || isset($_GET['by']) && $_GET['by'] == 'major_and_minor_specialization')
                          <div class="field">
                              <label>Major Subject Specialization</label>
                                <div class="ui fluid search selection dropdown">
                                  <input type="hidden" name="subject_specialization_major" required>
                                  <i class="dropdown icon"></i>
                                  <div class="default text">Select Major Specialization</div>
                                  <div class="menu">
                                    @foreach(App\SpecializationSubject::all() as $subject)
                                     <div class="item" data-value="{{strtolower($subject->subject_name)}}"><i class="dot circle outline icon"></i>{{strtoupper($subject->subject_name)}}</div>
                                    @endforeach
                                  </div>
                                </div>
                          </div>
                          @endif
                          @if(isset($_GET['by']) && $_GET['by'] =='minor_subject_specialization' || isset($_GET['by']) && $_GET['by'] == 'major_and_minor_specialization')
                          <div class="field">
                              <label>Minor Subject Specialization</label>
                                <div class="ui fluid search selection dropdown">
                                  <input type="hidden" name="subject_specialization_minor" required>
                                  <i class="dropdown icon"></i>
                                  <div class="default text">Select Minor Specialization</div>
                                  <div class="menu">
                                    @foreach(App\SpecializationSubject::all() as $subject)
                                     <div class="item" data-value="{{strtolower($subject->subject_name)}}"><i class="dot circle outline icon"></i>{{strtoupper($subject->subject_name)}}</div>
                                    @endforeach
                                  </div>
                                </div>
                          </div>
                          @endif
                          @if(isset($_GET['by']) && $_GET['by'] =='retirment_year')
                          <div class="field">
                              <label>Retirement Year</label>
                              <div class="ui calendar" id="yearInput">
                                <div class="ui input left icon">
                                  <i class="calendar icon"></i>
                                  <input type="text" name="retirement_year" placeholder="Select Year">
                                </div>
                              </div>
                          </div>
                          @endif
                          @if(isset($_GET['by']) && $_GET['by'] =='retirment_year_range')
                          <div class="field">
                              <label>Retirement Year Range</label>
                              <div class="ui form" style="padding: 4px;">
                                <div class="two fields">
                                  <div class="field">
                                    <label>Start Year</label>
                                    <div class="ui calendar" id="rangestart">
                                      <div class="ui input left icon">
                                        <i class="calendar icon"></i>
                                        <input type="text" name="retirement_year_range_start" placeholder="Start">
                                      </div>
                                    </div>
                                  </div>
                                  <div class="field">
                                    <label>End Year</label>
                                    <div class="ui calendar" id="rangeend">
                                      <div class="ui input left icon">
                                        <i class="calendar icon"></i>
                                        <input type="text" name="retirement_year_range_end" placeholder="End">
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                          </div>
                          @endif
                          @if(isset($_GET['by']) && $_GET['by'] =='retirment_with_major_subject_specialization')
                          <div class="field">
                              <label>Major Subject Specialization</label>
                                <div class="ui fluid search selection dropdown">
                                  <input type="hidden" name="subject_specialization_major" required>
                                  <i class="dropdown icon"></i>
                                  <div class="default text">Select Major Specialization</div>
                                  <div class="menu">
                                    @foreach(App\SpecializationSubject::all() as $subject)
                                     <div class="item" data-value="{{strtolower($subject->subject_name)}}"><i class="dot circle outline icon"></i>{{strtoupper($subject->subject_name)}}</div>
                                    @endforeach
                                  </div>
                                </div>
                          </div>
                          <div class="field">
                              <label>Retirement Year</label>
                              <div class="ui calendar" id="yearInput">
                                <div class="ui input left icon">
                                  <i class="calendar icon"></i>
                                  <input type="text" name="retirement_year" placeholder="Select Year">
                                </div>
                              </div>
                          </div>
                          @endif
                          @if(isset($_GET['by']) && $_GET['by'] =='retirment_with_minor_subject_specialization')
                          <div class="field">
                              <label>Minor Subject Specialization</label>
                                <div class="ui fluid search selection dropdown">
                                  <input type="hidden" name="subject_specialization_minor" required>
                                  <i class="dropdown icon"></i>
                                  <div class="default text">Select Minor Specialization</div>
                                  <div class="menu">
                                    @foreach(App\SpecializationSubject::all() as $subject)
                                     <div class="item" data-value="{{strtolower($subject->subject_name)}}"><i class="dot circle outline icon"></i>{{strtoupper($subject->subject_name)}}</div>
                                    @endforeach
                                  </div>
                                </div>
                          </div>
                          <div class="field">
                              <label>Retirement Year</label>
                              <div class="ui calendar" id="yearInput">
                                <div class="ui input left icon">
                                  <i class="calendar icon"></i>
                                  <input type="text" name="retirement_year" placeholder="Select Year">
                                </div>
                              </div>
                          </div>
                          @endif
                          <div class="field">
                          <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">Sort Teachers</button>
                        </div>
                    </form>
                  </div>
                </div>
                @else
                <div class="c8">
                    <div style="width: 100%;margin: 0 auto;padding: 10px">
                        <section class="ui segment" style="width: 100%;margin: 0px;">
                            <h2 class="ui horizontal divider header" style="color:#dc4900;">
                              View Teachers (Survey)
                            </h2>
                            <form class="ui form" action="{{route('super_admin.teachers-survey')}}" method="get">
                                <div class="three fields">
                                  <div class="field">
                                    <label>Local Govt Area.</label>
                                    <div class="ui fluid search selection dropdown">
                                      <input type="hidden" name="lga_id" value="{{old('lga_id')}}" onchange="getSchools(this);" data-href="{{url('/do-ajax/school')}}">
                                      <i class="dropdown icon"></i>
                                      <div class="default text">Local Govt. Area</div>
                                      <div class="menu" id="state-lga">
                                        @foreach(App\OndoLGA::all() as $ngstateLGA)
                                         <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                                        @endforeach
                                      </div>
                                    </div>
                                  </div>
                                  <div class="field" id="field-school">
                                    <label>School</label>
                                    <div class="ui fluid search selection dropdown" id="schoolsWrap">
                                      <input type="hidden" name="school" value="{{old('school')}}" data-href="{{url('/do-ajax/classes')}}">
                                      <i class="dropdown icon"></i>
                                      <div class="default text">School</div>
                                      <div class="menu" id="school-options-handler">
                                        @if(isset($_GET['school']) && $_GET['school'] != 'all')
                                            @foreach(getSchools(old('school')) as $school)
                                             <div class="item" data-value="{{$school->id}}">{{$school->name}}</div>
                                            @endforeach
                                        @else
                                          <div class="item" data-value="all">All Schools In Local Government Area</div>
                                        @endif
                                      </div>
                                    </div>
                                  </div>
                                  <div class="field">
                                    <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Teachers</button>
                                  </div>
                                </div>
                            </form>
                            <table class="ui celled table" style="zoom:80%">
                              <thead>
                                <tr>
                                    <th>
                                        <div class="ui ribbon label">Teacher Details</div>
                                    </th>
                              @if(isset($_GET['school']) && $_GET['school'] == 'all')
                              <th>
                                <div class="ui ribbon label">School Detais</div>
                              </th>
                              @endif
                                    <th>
                                        <div class="ui ribbon label">Date Of Appointment</div>
                                    </th>
                                    <th>
                                        <div class="ui ribbon label">Date Of Retirement</div>
                                    </th>
                                    <th>
                                        <div class="ui ribbon label">Date Of Birth</div>
                                    </th>
                                    <th>
                                        <div class="ui ribbon label">Type Of Teacher</div>
                                    </th>
                              <th>
                                <div class="ui ribbon label">Qualification</div>
                              </th>
                                    <th width="250px">
                                        <div class="ui ribbon label">Status</div>
                                    </th>
                                 </tr>
                              </thead>
                              <tbody>
                              @if($teachers->count() > 0)
                                @foreach($teachers as $teacher)
                                @php
                    		  	    $analytics = App\AttendanceAnalytic::where('teacher_id', $teacher->id)->get()->first();
                    		  	    if($analytics){
                    		  	        $rawDOB = explode(' ', $analytics->teacher_date_of_birth);
                    		  	        $rawDOA = explode(' ', $analytics->teacher_date_of_service);
                    		  	        $dob = $rawDOB[2];
                    		  	        $doa = $rawDOA[2];
                    		  	        $defaultYearsOfWorking = 35;
                    		  	        $defaultRetirmentAge = 60;
                    		  	        $didNotServe = false;
                                        $age =  date('Y') - $dob;
                                        $yearsOfWorking = date('Y') - $doa;
                                        $whenSixty = $dob + $defaultRetirmentAge;
                                        if($doa > $whenSixty){
                                            $didNotServe = true;
                                        }
                                        if($yearsOfWorking <= $defaultYearsOfWorking && $age >= $defaultRetirmentAge){
                                            $yearOfStopWorking = $whenSixty;
                                        }else{
                                            $yearOfStopWorking = $doa + $defaultYearsOfWorking;
                                        }
                                        if($yearsOfWorking <= $defaultYearsOfWorking){
                                            $yearsOfWorkingLeft = $defaultYearsOfWorking - $yearsOfWorking;
                                        }else{
                                            $yearsOfWorkingLeft = 0;
                                        }
                                    }
                    		  	@endphp
                                <tr>
                                  <td>
                                      <div style="display: flex;">
                                          <img src="{{env('APP_URL').$teacher->passport}}" style="width:50px;height: 50px;border-radius: 50%;">
                                          <span style="align-self: center;margin-left:5px;">{{$teacher->surname}} {{$teacher->firstname}} {{$teacher->middlename}} <br>@if($analytics) <small>Age: {{$age}}</small> @endif </span>
                                      </div>
                                  </td>
                              @if(isset($_GET['school']) && $_GET['school'] == 'all')
                              <td>
                                @php
                                  error_reporting(0); 
                                  $school = App\School::find($teacher->school_id);
                                @endphp
                                @if($school)
                                <div style="display: flex;">
                                    <img src="{{env('APP_URL').$school->logo}}" style="width:50px;height: 50px;border-radius: 50%;">
                                    <span style="align-self: center;margin-left:5px;">{{ucwords($school->name)}} <br>
                                      <small>LGA: {{$school->ondoLga->name}}</small>
                                    </span>
                                </div>
                                @else
                                <span style="color: red">Unknown School</span>
                                @endif
                              </td>
                              @endif
                                  @if($analytics)
                                  <td>{{$analytics->teacher_date_of_service}}</td>
                                  <td>{{$rawDOA[0]}} {{$rawDOA[1]}} {{$yearOfStopWorking}}</td>
                                  <td>{{$analytics->teacher_date_of_birth}}</td>
                              <td>{{$analytics->teacher_type}}</td>
                                  <td>{{$analytics->teacher_highest_qualification}}</td>
                                  <td>
                                    @if($didNotServe == true)
                                        <span style="color: red;">did not serve</span>
                                    @else
                                          @if($age >= $defaultRetirmentAge)
                                          <span style="color: red;">retired by age</span>
                                          <br>
                                          <small style="color: orange;">worked for {{$yearsOfWorking}} years.</small><br>
                                          <!-- <small style="color: orange;">due for retirement in {{$yearsOfWorkingLeft}} years.</small> -->
                                          @elseif($yearsOfWorking >= $defaultYearsOfWorking)
                                          <span style="color: red;">retired by year of service</span>
                                          <br>
                                          <small style="color: orange;">worked for {{$yearsOfWorking}} years.</small><br>
                                          <!-- <small style="color: orange;">due for retirement in {{$yearsOfWorkingLeft}} years.</small> -->
                                          @else
                                          <span style="color: green;">still working</span>
                                          <br>
                                          <small style="color: orange;">worked for {{$yearsOfWorking}} years.</small><br>
                                          <small style="color: orange;">due for retirement in {{$yearsOfWorkingLeft}} years.</small>
                                          @endif
                                    @endif
                                  </td>
                                  @else
                                  <td colspan="9"></td>
                                  @endif
                                </tr>
                               @endforeach
                                @else
                                <tr>
                                    <th colspan="9">
                                        <div class="ui icon negative message">
                                          <i class="info circle icon"></i>
                                          <div class="content">
                                            <div class="header">
                                            Sorry, No Record can be found.
                                            </div>
                                          </div>
                                         </div>
                                    </th>
                                </tr>
                              @endif
                              </tbody>
                              <tfoot>
                                <tr><th colspan="6">
                                  @include('pagination.default', ['paginator' => $teachers])
                                </th>
                              </tr></tfoot>
                            </table>
                        </section>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <!-- modals -->
    <form class="ui long modal teacherSortModal" method="post" action="{{route('super_admin.teachers-survey-sort-export')}}">
        <input type="hidden" name="_token" value="{{csrf_token()}}">
        <i class="close icon"></i>
        <div class="image content" style="height: 70vh;">
        <div class="description" style="padding: 15px;">
            <div class="result hard-center" style="width: 100%;">
                <div class="five wide column field loading"></div>
            </div>
        </div>
        </div>
        <div class="actions">
        <div class="ui cancel button">Cancel</div>
        </div>
    </form>
    <div class="jtr"></div>
@endsection
@section('scripts')
<script>
    $(function(){
        $('.ui.accordion').accordion();
        $('#yearInput').calendar({
          type: 'year'
        });
        $('#rangestart').calendar({
          type: 'year',
          endCalendar: $('#rangeend')
        });
        $('#rangeend').calendar({
          type: 'year',
          startCalendar: $('#rangestart')
        });
    });

        function teacherSortSubmit(obj){
            var form = $(obj);
            var modal = $('.teacherSortModal');
            var url = form.attr('action');
            var type = form.attr('method');
            var data = form.serialize();
            
            modal.find('.description .result').html('<div class="five wide column field loading"></div>');
            modal.modal({
                closable  : true,
                centered: true
            }).modal('show');

            $.ajax({
                url: url,
                type: type,
                data: data,
                success: function(res){
                    $post = `
                    <div>
                        <div class="ui statistics">
                            <div class="statistic">
                                <div class="value teacher_count">
                                ${res.all_count}
                                </div>
                                <div class="label">
                                All Teachers
                                </div>
                            </div>
                            <div class="statistic">
                                <div class="value student_count">
                                ${res.male_count}
                                </div>
                                <div class="label">
                                Male Teachers
                                </div>
                            </div>
                            <div class="statistic">
                                <div class="value admin_count">
                                ${res.female_count}
                                </div>
                                <div class="label">
                                Female Teachers
                                </div>
                            </div>
                        </div>
                    </div>
                    <form id="export--form" action="{{route('super_admin.teachers-survey')}}" method="POST" style="text-align: center;font-size: 2em;">
                        <input type="hidden" name="_token" value="{{csrf_token()}}">
                        <button type="submit" class="ui button orange big">
                            Export Table (Excel)
                            <i class="file excel icon"></i>
                        </button>
                    </form>
                    `;
                    modal.find('.description .result').html($post);
                    $.each(res.request, function(index, value){
                        $('.teacherSortModal').append(`<input type="hidden" name="${index}" value="${value}" >`);
                    });
                },
                    error: function(err){
                    console.log(err.responsJSON.message);
                }
            });
        }
    function openFullSurvey(obj){
        var btn = $(obj);
        var url = btn.attr('data-url');
        var session = btn.parents('.field').first().find('select').val();
        
        window.open(`${url}/${session}`);
    }
    
    function openSurvey(obj){
        var btn = $(obj);
        var id = btn.attr('data-id');
        var url = btn.attr('data-url');
        var session = btn.parents('.fields').first().find('select').val();
        
        window.open(`${url}/${id}/${session}`);
    }

    function getSchools(obj){
      var input = $(obj);
      var url = input.attr('data-href');
      var value = input.val();
      data = {lga: value};
      var schoolsWrap = $('#schoolsWrap');

      schoolsWrap.addClass('loading');

      $.ajax({
        url: url,
        type: 'POST',
        data: data,
        success: function(res){
            $post = `
                <div class="item" data-value="all">All Schools In Local Government Area</div>
                ${res.schoolDisplay}
            `;
            schoolsWrap.removeClass('loading');
            schoolsWrap.find('.menu').html($post);
        },
        error: function(err){
            console.log(err.responsJSON.message)
        }
      });

    }
</script>
@endsection