@extends('layouts.main')
@section('content')
    <br>
    
    <div class="ui grid" style="padding: 10px;">
        <div class="four wide column">
            <div class="ui vertical fluid tabular menu">
                <a href="{{route('super_admin.schools-survey')}}" class="item active">
                    Schools Survey
                </a>
                <a href="{{route('super_admin.teachers-survey')}}" class="item">
                    View Teachers Survey
                </a>
                <div class="ui dropdown item">
                    <i class="dropdown icon"></i>
                    Filter Teacher Survey
                    <div class="menu">
                      <div class="header">Submenu</div>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && !isset($_GET['by'])) active @endif">General Filter</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=major_subject_specialization" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'major_subject_specialization') active @endif">Major Subject Specialization</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=minor_subject_specialization" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'minor_subject_specialization') active @endif">Minor Subject Specialization</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=major_and_minor_specialization" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'major_and_minor_specialization') active @endif">Major & Minor Subject Specialization</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=retirment_year" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'retirment_year') active @endif">Retirement Year</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=retirment_year_range" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'retirment_year_range') active @endif">Retirement Year Range</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=retirment_with_major_subject_specialization" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'retirment_with_major_subject_specialization') active @endif">Retirement With Major Subject Specialization</a>
                      <a href="{{route('super_admin.teachers-survey')}}?action=filter&by=retirment_with_minor_subject_specialization" class="item @if(isset($_GET['action']) && $_GET['action'] == 'filter' && isset($_GET['by']) && $_GET['by'] == 'retirment_with_minor_subject_specialization') active @endif">Retirement With Minor Subject Specialization</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="twelve wide stretched column">
            <div class="ui segment">
                <section class="ui segment" style="max-width: 900px;margin: 0px;">
            	    <h2 class="ui horizontal divider header" style="color:#dc4900;">
            		  View Schools (Survey)
            		</h2>
            		
            		<div class="search-bar">
            			<div class="ui stackable equal height stackable grid">
            				<div class="seven wide column">
            					<form method="get" action="" class="form form-horizontal global_form">
            							<input type="hidden" name="type" value="search_school">
            							<div class="ui left action input fluid">
            									<button class="ui orange labeled icon button">
            											<i class="search icon"></i>
            											Search KEYWORD:
            									</button>
            									<input type="text" placeholder="Enter keyword..." name="keyword" value="">
            							</div>
            					</form>
            				</div>
            				<div class="two wide column">
            					<h2 class="ui horizontal divider header" style="margin-top: 8px;color:#dc4900;text-align: center;">Or</h2>
            				</div>
            				<div class="seven wide column">
            					<form method="get" class="form form-horizontal global_form">
            							<input type="hidden" name="type" value="search_school">
            							<div class="second">
            									<div class="fields">
            											<div class="sixteen wide field">
            													<div class="ui left action input fluid">
            															<button class="ui orange labeled icon button">
            																	<i class="search icon"></i>
            																	Search with LGA:
            															</button>
            															<select name="lga" class="ui search fluid dropdown">
            																<option value="">Choose LGA</option>
            																@if($item_rows = DB::table('ondo_lgas')->get())
            																		@foreach ($item_rows as $item_data)
            																		<option value="{{$item_data->id}}">{{$item_data->name}}</option>
            																		@endforeach
            																@endif
            														</select>
            													</div>
            											</div>
            									</div>
            							</div>
            					</form>
            				</div>
            				<div class="sixteen wide field column">
            				    <div class="ui left action input fluid">
            						<button class="ui blue labeled icon button" data-url="{{url('ministry/schools-survey-stats')}}" onclick="openFullSurvey(this)">
            							<i class="icon newspaper outline"></i>
            					        View All Schools Survey Analytics
            						</button>
            						<select class="ui search fluid dropdown">
            							<option value="">Choose Session</option>
            							@for($i = 2010; $i <= (date('Y') +1) ; $i++)
            							<option value="{{$i}}">{{$i}}/{{$i+1}}</option>
            							@endfor
            						</select>
            					</div>
            				</div>
            			</div>
            		</div>
            		<table class="ui celled table">
            		  <thead>
            		    <tr>
            			  	<th>
            			    	<div class="ui ribbon label">School name</div>
            			    </th>
            			    <th>
            			    	<div class="ui ribbon label">School LGA</div>
            			    </th>
            			    <th>
            			    	<div class="ui ribbon label">Survey Status</div>
            			    </th>
            			    <th colspan="2">
            			    	<div class="ui ribbon label">Action</div>
            			    </th>
            			 </tr>
            		  </thead>
            		  <tbody>
            		  @if(count($schools) > 0)
            		  	@foreach($schools as $school)
            		    <tr>
            		      <td>
            		          <div style="display: flex;">
            		              <img src="{{url_public($school->logo)}}" style="width:50px;height: 50px;border-radius: 50%;">
            		              <span style="align-self: center;margin-left:5px;">{{$school->name}}</span>
            		          </div>
            		      </td>
            		      <td>{{$school->ondo_lga->name}}</td>
            		      <td>
            		          @if(App\SchoolSurvey::where('school_id', $school->id)->get()->first())
            		          <span style="color: green;">Updated [@foreach(App\SchoolSurvey::where('school_id', $school->id)->get() as $survey) {{$survey->session}} @endforeach]</span>
            		          @else
            		          <span style="color: red;">Not updated</span>
            		          @endif
            		      </td>
            		      <td width="300px">
            				<div class="fields">
            					<div class="sixteen wide field">
            						<div class="ui left action input fluid">
            							<button class="ui blue button"  data-id="{{$school->id}}" data-url="{{url('ministry/school-survey-view')}}" onclick="openSurvey(this)">
            								View Survey:
            							</button>
            							<select class="ui search fluid dropdown">
            								<option value="">Choose Session</option>
            								@for($i = 2010; $i <= (date('Y') + 1) ; $i++)
            								@php $year = date('Y') - 1; @endphp
            								<option @if($year == $i) selected @endif value="{{$i}}">{{$i}}/{{$i+1}}</opion>
            								@endfor
            							</select>
            						</div>
            					</div>
            				</div>
            			  </td>
            		    </tr>
            		   @endforeach
            		    @else
            			<tr>
            				<th colspan="4">
            					<div class="ui icon negative message">
            					  <i class="info circle icon"></i>
            					  <div class="content">
            					    <div class="header">
            					    Sorry, No Record can be found.
            					  	</div>
            					  </div>
            					 </div>
            				</th>
            			</tr>
            		  @endif
            		  </tbody>
            		  <tfoot>
            		    <tr><th colspan="6">
            		      @include('pagination.default', ['paginator' => $schools])
            		    </th>
            		  </tr></tfoot>
            		</table>
            	</section>
            </div>
        </div>
    </div>
	<div class="jtr"></div>
@endsection
@section('scripts')
<script>
    $(function(){
        $('.ui.accordion').accordion();
    });

    function getSchools(obj){
      var input = $(obj);
      var url = input.attr('data-href');
      var value = input.val();
      data = {lga: value};
      var schoolsWrap = $('#schoolsWrap');

      schoolsWrap.addClass('loading');

      $.ajax({
        url: url,
        type: 'POST',
        data: data,
        success: function(res){
            $post = `
                <div class="item" data-value="all">All Schools In Local Government Area</div>
                ${res.schoolDisplay}
            `;
            schoolsWrap.removeClass('loading');
            schoolsWrap.find('.menu').html($post);
        },
        error: function(err){
            console.log(err.responsJSON.message)
        }
      });

    }

    function openFullSurvey(obj){
        var btn = $(obj);
        var url = btn.attr('data-url');
        var session = btn.parents('.field').first().find('select').val();
        
        if(session == '' || session == null){
            alert('Please select session');
            return false;
        }
        
        window.open(`${url}/${session}`);
    }
    
    function openSurvey(obj){
        var btn = $(obj);
        var id = btn.attr('data-id');
        var url = btn.attr('data-url');
        var session = btn.parents('.fields').first().find('select').val();
        
        if(session == '' || session == null){
            alert('Please select session');
            return false;
        }
        
        window.open(`${url}/${id}/${session}`);
    }
</script>
@endsection