@extends('layouts.main')
@section('styles')
<link rel="stylesheet" type="text/css" href="https://odsgmoe.com/eportal/public/css/chart.min.css">
@endsection
@section('content')
    @php $lgas = App\OndoLGA::all(); @endphp
    <br>
    <div class="survey-form" data-title="Schools Survey">
        <!--<div class="ui main-loader">-->
        <!--  <div class="ui active dimmer">-->
        <!--    <div class="ui loader"></div>-->
        <!--  </div>-->
        <!--</div>-->
        <div class="no-print" style="padding: 35px 50px 10px 50px;">
            <div style="position: sticky !important;top: 10px !important;">
              <div class="ui styled accordion" style="width: 350px;">
                  <div class="title" onclick="$('.survey-form').toggleClass('all-page'); $('.export-hide').each(function(){ $(this).toggleClass('hidden') });">
                    <i class="dropdown icon"></i>
                    Export pages?
                  </div>
                  <div class="content">
                    <p>
                        Click the <i class="print blue icon"></i> icon to <b>Print</b> pages, click the <i class="file pdf orange icon"></i> icon to download pages as <b>PDF</b> and click the <i class="file excel green icon"></i> icon to export pages as <b>Excel</b>.
                    </p>
                    
                    <div class="export">
                        <button class="ui circular blue icon button export-btn"  data-content="Print Pages" onclick="printPage();">
                          <i class="print icon"></i>
                        </button>
                        <button id="printPDF" class="ui circular orange icon button export-btn" data-content="Save Pages As PDF" onclick="$(this).addClass('loading'); $(this).css('pointer-events', 'none'); genPDF(this);">
                          <i class="file pdf icon"></i>
                        </button>
                        <button class="ui circular green icon button export-btn" data-content="Export Pages As Excel" onclick="exportExcel();">
                          <i class="file excel icon"></i>
                        </button>
                    </div>
                  </div>
                </div>
                <br>
        <form class="fields hidden lga-export-form" method="post" action="" style="padding: 0px !important;">
            {{csrf_field()}}
            <input type="hidden" name="session" value="{{$session}}">
          <div class="sixteen wide field">
            <div class="ui left action input fluid">
              <button class="ui orange button">
                Export:
              </button>
              <select name="lga" class="ui search fluid dropdown" required>
                <option value="">Choose LGA</option>
                @if($lgas->count() > 0)
                @foreach ($lgas as $item_data)
                <option value="{{$item_data->id}}">{{$item_data->name}}</option>
                @endforeach
                @endif
                </select>
              <select name="type" class="ui search fluid dropdown" required>
                <option value="">Choose Type</option>
                <option value="all">All</option>
                <option value="enrolment">Enrolment</option>
                <option value="teaching">Teaching</option>
                <option value="non teaching">Non Teaching</option>
                <option value="facilities">Facilities</option>
                <option value="furniture">Furniture</option>
                <option value="summary">Summary</option>
                </select>
            </div>
          </div>
        </form>
            </div>
        </div>
        <br>
        <form method="POST" action="" class="main--survey" style="padding: 0px 5px 10px 50px;width: -webkit-fill-available;">
            <input type="hidden" name="_token" value="{{csrf_token()}}">
            <div class="ui page-count no-print export-hide">
                <a data-page="1" onclick="switchPage(1)" class="ui black circular label">G1</a>
                <a data-page="2" onclick="switchPage(2)" class="ui grey circular label">G2</a>
                @if($lgas->count() > 0)
                @php $counter = 3; $counterDigit = 1; @endphp
                @foreach($lgas as $lga)
                <a data-page="{{$counter}}" onclick="switchPage({{$counter}})" class="ui grey circular label">{{$counterDigit}}</a>
                @php $counter++; $counterDigit++; @endphp
                @endforeach
                @endif
                <a data-page="50" onclick="switchPage(50)" class="ui grey circular label">SS</a>
            </div>
            <div class="ui raised segment" data-page="1">
                <div style="text-align: center;">
                    <img src="{{url_public('/images/header-logo.png')}}" style="width: 250px;border-radius: 20px;">
                    <h1 style="text-transform: uppercase;">
              Ondo State Ministry Of <br> Education, Science And Technology's <br> Schools Survey Analytics For {{$session}}/{{$session + 1}}
                    </h1>
                </div>
                <a class="ui black ribbon label">State's Statistics</a>
                <div style="text-align: center;">
                    <div>
                    <canvas id="generalChart"></canvas>
                  </div>
                </div>
                <a class="ui black ribbon label">State's LGA Statistics</a>
                <div style="text-align: center;">
                    <div>
                    <canvas id="generalLgaChart"></canvas>
                  </div>
                </div>
                <div class="p-right">
                    <button type="button" class="no-print export-hide ui right black labeled icon button" onclick="switchPage(2)">
                      <i class="right arrow icon"></i>
                      Next
                    </button>
                </div>
                <div style="clear: both;"></div>
            </div>
            <div class="ui raised segment hidden" data-page="2">
                <a class="ui black ribbon label">Junior Students Histogram Chart Representation</a>
                <div style="text-align: center;">
                    <div>
                    <canvas id="juniorChart"></canvas>
                  </div>
                </div>
                <a class="ui black ribbon label">Senior Students Pie Chart Representation</a>
                <div style="text-align: center;">
                    <div>
                    <canvas id="seniorChart"></canvas>
                  </div>
                </div>
                <div class="p-left">
                    <button type="button" class="no-print export-hide ui black labeled icon button" onclick="switchPage(1)">
                      <i class="left arrow icon"></i>
                      Previous
                    </button>
                </div>
                <div class="p-right">
                    <button type="button" class="no-print export-hide ui right black labeled icon button" onclick="switchPage(3)">
                      <i class="right arrow icon"></i>
                      Next
                    </button>
                </div>
                <div style="clear: both;"></div>
            </div>
            @if($lgas->count() > 0)
            @php $counter = 3; @endphp
            @foreach($lgas as $lga)
            <div class="ui raised segment hidden" data-page="{{$counter}}" data-id="{{$lga->id}}">
                <div class="ui active inverted dimmer dummy-loader">
                    <div class="ui text loader">Loading</div>
                </div>
                <div style="text-align: center;">
                    <h3 style="text-transform: uppercase;">
              {{ucwords($lga->name)}}'s Survey Analytics
                    </h3>
                </div>
                <a class="ui black ribbon label">Summary</a>
                <div style="zoom: 80%;">
                    <br>
                    <table class="ui celled structured table summary--table" style="margin-bottom: 0px !important;zoom:85%;" data-id="{{$lga->id}}">
                        <thead>
                            <tr>
                                <th rowspan="2">S/N</th>
                                <th rowspan="2">Schools</th>
                                <th rowspan="2">Student Enrolment</th>
                                <th colspan="3">Classrooms</th>
                                <th colspan="3">Laboratories</th>
                                <th colspan="3">Computer Room</th>
                                <th colspan="3">Technical Workshop</th>
                                <th colspan="3">Library</th>
                                <th colspan="3">Toilets</th>
                                <th colspan="3">School Fence</th>
                                <th rowspan="2">Classroom Student Ratio</th>
                            </tr>
                            <tr>
                                <th>NO AV</th>
                                <th>NO INGC</th>
                                <th>NO ND</th>
                                <th>NO AV</th>
                                <th>NO INGC</th>
                                <th>NO ND</th>
                                <th>NO AV</th>
                                <th>NO INGC</th>
                                <th>NO ND</th>
                                <th>NO AV</th>
                                <th>NO INGC</th>
                                <th>NO ND</th>
                                <th>NO AV</th>
                                <th>NO INGC</th>
                                <th>NO ND</th>
                                <th>NO AV</th>
                                <th>NO INGC</th>
                                <th>NO ND</th>
                                <th>NO AV</th>
                                <th>NO INGC</th>
                                <th>NO ND</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                        <tfoot>
                            <tr>
                                <td></td>
                                <td></td>
                                <td colspan="24"></td>
                            </tr>
                        </tfoot>
                    </table>
                    @php
                        $sumSurvey = App\SchoolSurvey::where('local_government_area', $lga->name)->where('session', $session);
                        $jss1_male = ($sumSurvey->sum('jss1_male')) ? $sumSurvey->sum('jss1_male') : 0;
                        $jss1_female = ($sumSurvey->sum('jss1_female')) ? $sumSurvey->sum('jss1_female') : 0;
                        $jss2_male = ($sumSurvey->sum('jss2_male')) ? $sumSurvey->sum('jss2_male') : 0;
                        $jss2_female = ($sumSurvey->sum('jss2_female')) ? $sumSurvey->sum('jss2_female') : 0;
                        $jss3_male = ($sumSurvey->sum('jss3_male')) ? $sumSurvey->sum('jss3_male') : 0;
                        $jss3_female = ($sumSurvey->sum('jss3_female')) ? $sumSurvey->sum('jss3_female') : 0;
                        $sss1_male = ($sumSurvey->sum('sss1_male')) ? $sumSurvey->sum('sss1_male') : 0;
                        $sss1_female = ($sumSurvey->sum('sss1_female')) ? $sumSurvey->sum('sss1_female') : 0;
                        $sss2_male = ($sumSurvey->sum('sss2_male')) ? $sumSurvey->sum('sss2_male') : 0;
                        $sss2_female = ($sumSurvey->sum('sss2_female')) ? $sumSurvey->sum('sss2_female') : 0;
                        $sss3_male = ($sumSurvey->sum('sss3_male')) ? $sumSurvey->sum('sss3_male') : 0;
                        $sss3_female = ($sumSurvey->sum('sss3_female')) ? $sumSurvey->sum('sss3_female') : 0;
                        $classrooms_available = ($sumSurvey->sum('classrooms_available')) ? $sumSurvey->sum('classrooms_available') : 0;
                        $classrooms_in_good_condition = ($sumSurvey->sum('classrooms_in_good_condition')) ? $sumSurvey->sum('classrooms_in_good_condition') : 0;
                        $classrooms_needed = ($sumSurvey->sum('classrooms_needed')) ? $sumSurvey->sum('classrooms_needed') : 0;
                        $laboratories_available = ($sumSurvey->sum('laboratories_available')) ? $sumSurvey->sum('laboratories_available') : 0;
                        $laboratories_in_good_condition = ($sumSurvey->sum('laboratories_in_good_condition')) ? $sumSurvey->sum('laboratories_in_good_condition') : 0;
                        $laboratories_needed = ($sumSurvey->sum('laboratories_needed')) ? $sumSurvey->sum('laboratories_needed') : 0;
                        $computerroom_available = ($sumSurvey->sum('computerroom_available')) ? $sumSurvey->sum('computerroom_available') : 0;
                        $computerroom_in_good_condition = ($sumSurvey->sum('computerroom_in_good_condition')) ? $sumSurvey->sum('computerroom_in_good_condition') : 0;
                        $computerroom_needed = ($sumSurvey->sum('computerroom_needed')) ? $sumSurvey->sum('computerroom_needed') : 0;
                        $technical_workshop_available = ($sumSurvey->sum('technical_workshop_available')) ? $sumSurvey->sum('technical_workshop_available') : 0;
                        $technical_workshop_in_good_condition = ($sumSurvey->sum('technical_workshop_in_good_condition')) ? $sumSurvey->sum('technical_workshop_in_good_condition') : 0;
                        $technical_workshop_needed = ($sumSurvey->sum('technical_workshop_needed')) ? $sumSurvey->sum('technical_workshop_needed') : 0;
                        $library_available = ($sumSurvey->sum('library_available')) ? $sumSurvey->sum('library_available') : 0;
                        $library_in_good_condition = ($sumSurvey->sum('library_in_good_condition')) ? $sumSurvey->sum('library_in_good_condition') : 0;
                        $library_workshop = ($sumSurvey->sum('library_workshop')) ? $sumSurvey->sum('library_workshop') : 0;
                        $master_degree_with_tq_male = ($sumSurvey->sum('master_degree_with_tq_male')) ? $sumSurvey->sum('master_degree_with_tq_male') : 0;
                        $master_degree_with_tq_female = ($sumSurvey->sum('master_degree_with_tq_female')) ? $sumSurvey->sum('master_degree_with_tq_female') : 0;
                        $master_degree_with_tq_total = ($sumSurvey->sum('master_degree_with_tq_total')) ? $sumSurvey->sum('master_degree_with_tq_total') : 0;
                        $graduate_with_tq_male = ($sumSurvey->sum('graduate_with_tq_male')) ? $sumSurvey->sum('graduate_with_tq_male') : 0;
                        $graduate_with_tq_female = ($sumSurvey->sum('graduate_with_tq_female')) ? $sumSurvey->sum('graduate_with_tq_female') : 0;
                        $graduate_with_tq_total = ($sumSurvey->sum('graduate_with_tq_total')) ? $sumSurvey->sum('graduate_with_tq_total') : 0;
                        $graduate_without_tq_male = ($sumSurvey->sum('graduate_without_tq_male')) ? $sumSurvey->sum('graduate_without_tq_male') : 0;
                        $graduate_without_tq_female = ($sumSurvey->sum('graduate_without_tq_female')) ? $sumSurvey->sum('graduate_without_tq_female') : 0;
                        $graduate_without_tq_total = ($sumSurvey->sum('graduate_without_tq_total')) ? $sumSurvey->sum('graduate_without_tq_total') : 0;
                        $hnd_with_tq_male = ($sumSurvey->sum('hnd_with_tq_male')) ? $sumSurvey->sum('hnd_with_tq_male') : 0;
                        $hnd_with_tq_female = ($sumSurvey->sum('hnd_with_tq_female')) ? $sumSurvey->sum('hnd_with_tq_female') : 0;
                        $hnd_with_tq_total = ($sumSurvey->sum('hnd_with_tq_total')) ? $sumSurvey->sum('hnd_with_tq_total') : 0;
                        $hnd_without_tq_male = ($sumSurvey->sum('hnd_without_tq_male')) ? $sumSurvey->sum('hnd_without_tq_male') : 0;
                        $hnd_without_tq_female = ($sumSurvey->sum('hnd_without_tq_female')) ? $sumSurvey->sum('hnd_without_tq_female') : 0;
                        $hnd_without_tq_total = ($sumSurvey->sum('hnd_without_tq_total')) ? $sumSurvey->sum('hnd_without_tq_total') : 0;
                        $nce_male = ($sumSurvey->sum('nce_male')) ? $sumSurvey->sum('nce_male') : 0;
                        $nce_female = ($sumSurvey->sum('nce_female')) ? $sumSurvey->sum('nce_female') : 0;
                        $nce_total = ($sumSurvey->sum('nce_total')) ? $sumSurvey->sum('nce_total') : 0;
                        $ond_and_equivalent_male = ($sumSurvey->sum('ond_and_equivalent_male')) ? $sumSurvey->sum('ond_and_equivalent_male') : 0;
                        $ond_and_equivalent_female = ($sumSurvey->sum('ond_and_equivalent_female')) ? $sumSurvey->sum('ond_and_equivalent_female') : 0;
                        $ond_and_equivalent_total = ($sumSurvey->sum('ond_and_equivalent_total')) ? $sumSurvey->sum('ond_and_equivalent_total') : 0;
                        $others_male = ($sumSurvey->sum('others_male')) ? $sumSurvey->sum('others_male') : 0;
                        $others_female = ($sumSurvey->sum('others_female')) ? $sumSurvey->sum('others_female') : 0;
                        $others_total = ($sumSurvey->sum('others_total')) ? $sumSurvey->sum('others_total') : 0;
                    @endphp
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Students Enrolled:</th>
                          <th colspan="2">JSS1</th>
                          <th colspan="2">JSS2</th>
                          <th colspan="2">JSS3</th>
                          <th colspan="2">SS1</th>
                          <th colspan="2">SS2</th>
                          <th colspan="2">SS3</th>
                        </tr>
                        <tr>
                          <th>M</th>
                          <th>F</th>
                          <th>M</th>
                          <th>F</th>
                          <th>M</th>
                          <th>F</th>
                          <th>M</th>
                          <th>F</th>
                          <th>M</th>
                          <th>F</th>
                          <th>M</th>
                          <th>F</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                            <td></td>
                            <td>{{$jss1_male}}</td>
                            <td>{{$jss1_female}}</td>
                            <td>{{$jss2_male}}</td>
                            <td>{{$jss2_female}}</td>
                            <td>{{$jss3_male}}</td>
                            <td>{{$jss3_female}}</td>
                            <td>{{$sss1_male}}</td>
                            <td>{{$sss1_female}}</td>
                            <td>{{$sss2_male}}</td>
                            <td>{{$sss2_female}}</td>
                            <td>{{$sss3_male}}</td>
                            <td>{{$sss3_female}}</td>
                        </tr>
                      </tbody>
                    </table>
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Teachers:</th>
                          <th colspan="3">Master Degrees with TQ</th>
                          <th colspan="3">Graduate with TQ</th>
                          <th colspan="3">Graduate without TQ</th>
                          <th colspan="3">HND with TQ</th>
                          <th colspan="3">HND without TQ</th>
                          <th colspan="3">NCE</th>
                          <th colspan="3">OND & Equivalent</th>
                          <th colspan="3">Others</th>
                        </tr>
                        <tr>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                            <td></td>
                            <td>{{$master_degree_with_tq_male}}</td>
                            <td>{{$master_degree_with_tq_female}}</td>
                            <td>{{$master_degree_with_tq_total}}</td>
                            <td>{{$graduate_with_tq_male}}</td>
                            <td>{{$graduate_with_tq_female}}</td>
                            <td>{{$graduate_with_tq_total}}</td>
                            <td>{{$graduate_without_tq_male}}</td>
                            <td>{{$graduate_without_tq_female}}</td>
                            <td>{{$graduate_without_tq_total}}</td>
                            <td>{{$hnd_with_tq_male}}</td>
                            <td>{{$hnd_with_tq_female}}</td>
                            <td>{{$hnd_with_tq_total}}</td>
                            <td>{{$hnd_without_tq_male}}</td>
                            <td>{{$hnd_without_tq_female}}</td>
                            <td>{{$hnd_without_tq_total}}</td>
                            <td>{{$nce_male}}</td>
                            <td>{{$nce_female}}</td>
                            <td>{{$nce_total}}</td>
                            <td>{{$ond_and_equivalent_male}}</td>
                            <td>{{$ond_and_equivalent_female}}</td>
                            <td>{{$ond_and_equivalent_total}}</td>
                            <td>{{$others_male}}</td>
                            <td>{{$others_female}}</td>
                            <td>{{$others_total}}</td>
                        </tr>
                      </tbody>
                    </table>
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Classrooms:</th>
                          <th>Number Available</th>
                          <th>Number In Good Condition</th>
                          <th>Number Needed</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                            <td></td>
                            <td>{{$classrooms_available}}</td>
                            <td>{{$classrooms_in_good_condition}}</td>
                            <td>{{$classrooms_needed}}</td>
                        </tr>
                      </tbody>
                    </table>
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Laboratories:</th>
                          <th>Number Available</th>
                          <th>Number In Good Condition</th>
                          <th>Number Needed</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                            <td></td>
                            <td>{{$laboratories_available}}</td>
                            <td>{{$laboratories_in_good_condition}}</td>
                            <td>{{$laboratories_needed}}</td>
                        </tr>
                      </tbody>
                    </table>
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Computer Rooms:</th>
                          <th>Number Available</th>
                          <th>Number In Good Condition</th>
                          <th>Number Needed</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                            <td></td>
                            <td>{{$computerroom_available}}</td>
                            <td>{{$computerroom_in_good_condition}}</td>
                            <td>{{$computerroom_needed}}</td>
                        </tr>
                      </tbody>
                    </table>
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Technical Workshops:</th>
                          <th>Number Available</th>
                          <th>Number In Good Condition</th>
                          <th>Number Needed</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                            <td></td>
                            <td>{{$technical_workshop_available}}</td>
                            <td>{{$technical_workshop_in_good_condition}}</td>
                            <td>{{$technical_workshop_needed}}</td>
                        </tr>
                      </tbody>
                    </table>
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Libraries:</th>
                          <th>Number Available</th>
                          <th>Number In Good Condition</th>
                          <th>Number Needed</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                            <td></td>
                            <td>{{$library_available}}</td>
                            <td>{{$library_in_good_condition}}</td>
                            <td>{{$library_workshop}}</td>
                        </tr>
                      </tbody>
                    </table>
                </div>
                <div class="ui info icon message">
                <i class="exclamation circle icon"></i>
                <div class="content">
                    <div class="header">
                      Quick Table Abbrivations Guide
                    </div>
                    <ul class="list alert-news">
                      <li><b>S/N:</b> Serial Number</li>
                      <li><b>M:</b> Male</li>
                      <li><b>F:</b> Female</li>
                      <li><b>No AV:</b> Number Available</li>
                        <li><b>NO INGC:</b> Number In Good Condition</li>
                        <li><b>NO ND:</b> Number Needed</li>
                      </ul>
                  </div>
                </div>
                <br>
                <div class="p-left">
                    <button type="button" class="no-print export-hide ui black labeled icon button" onclick="switchPage({{$counter - 1}})">
                      <i class="left arrow icon"></i>
                      Previous
                    </button>
                </div>
                <div class="p-right">
                    <button type="button" class="no-print export-hide ui right black labeled icon button" onclick="switchPage({{$counter + 1}})">
                      <i class="right arrow icon"></i>
                      Next
                    </button>
                </div>
                <div style="clear: both;"></div>
            </div>
            @php $counter++; @endphp
            @endforeach
            @endif
            <div class="ui raised segment hidden" data-page="50">
                @if($lgas->count() > 0)
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Students Enrolled:</th>
                          <th colspan="2">JSS1</th>
                          <th colspan="2">JSS2</th>
                          <th colspan="2">JSS3</th>
                          <th colspan="2">SS1</th>
                          <th colspan="2">SS2</th>
                          <th colspan="2">SS3</th>
                        </tr>
                        <tr>
                          <th>M</th>
                          <th>F</th>
                          <th>M</th>
                          <th>F</th>
                          <th>M</th>
                          <th>F</th>
                          <th>M</th>
                          <th>F</th>
                          <th>M</th>
                          <th>F</th>
                          <th>M</th>
                          <th>F</th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach($lgas as $lga)
                            @php
                                $sumSurvey = App\SchoolSurvey::where('local_government_area', $lga->name)->where('session', $session);
                                $jss1_male = ($sumSurvey->sum('jss1_male')) ? $sumSurvey->sum('jss1_male') : 0;
                                $jss1_female = ($sumSurvey->sum('jss1_female')) ? $sumSurvey->sum('jss1_female') : 0;
                                $jss2_male = ($sumSurvey->sum('jss2_male')) ? $sumSurvey->sum('jss2_male') : 0;
                                $jss2_female = ($sumSurvey->sum('jss2_female')) ? $sumSurvey->sum('jss2_female') : 0;
                                $jss3_male = ($sumSurvey->sum('jss3_male')) ? $sumSurvey->sum('jss3_male') : 0;
                                $jss3_female = ($sumSurvey->sum('jss3_female')) ? $sumSurvey->sum('jss3_female') : 0;
                                $sss1_male = ($sumSurvey->sum('sss1_male')) ? $sumSurvey->sum('sss1_male') : 0;
                                $sss1_female = ($sumSurvey->sum('sss1_female')) ? $sumSurvey->sum('sss1_female') : 0;
                                $sss2_male = ($sumSurvey->sum('sss2_male')) ? $sumSurvey->sum('sss2_male') : 0;
                                $sss2_female = ($sumSurvey->sum('sss2_female')) ? $sumSurvey->sum('sss2_female') : 0;
                                $sss3_male = ($sumSurvey->sum('sss3_male')) ? $sumSurvey->sum('sss3_male') : 0;
                                $sss3_female = ($sumSurvey->sum('sss3_female')) ? $sumSurvey->sum('sss3_female') : 0;
                            @endphp
                        <tr>
                            <td>{{strtoupper($lga->name)}}</td>
                            <td>{{$jss1_male}}</td>
                            <td>{{$jss1_female}}</td>
                            <td>{{$jss2_male}}</td>
                            <td>{{$jss2_female}}</td>
                            <td>{{$jss3_male}}</td>
                            <td>{{$jss3_female}}</td>
                            <td>{{$sss1_male}}</td>
                            <td>{{$sss1_female}}</td>
                            <td>{{$sss2_male}}</td>
                            <td>{{$sss2_female}}</td>
                            <td>{{$sss3_male}}</td>
                            <td>{{$sss3_female}}</td>
                        </tr>
                        @endforeach
                      </tbody>
                    </table>
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Teachers:</th>
                          <th colspan="3">Master Degrees with TQ</th>
                          <th colspan="3">Graduate with TQ</th>
                          <th colspan="3">Graduate without TQ</th>
                          <th colspan="3">HND with TQ</th>
                          <th colspan="3">HND without TQ</th>
                          <th colspan="3">NCE</th>
                          <th colspan="3">OND & Equivalent</th>
                          <th colspan="3">Others</th>
                        </tr>
                        <tr>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                            <th>M</th>
                            <th>F</th>
                            <th>Total</th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach($lgas as $lga)
                            @php
                                $sumSurvey = App\SchoolSurvey::where('local_government_area', $lga->name)->where('session', $session);
                                $master_degree_with_tq_male = ($sumSurvey->sum('master_degree_with_tq_male')) ? $sumSurvey->sum('master_degree_with_tq_male') : 0;
                                $master_degree_with_tq_female = ($sumSurvey->sum('master_degree_with_tq_female')) ? $sumSurvey->sum('master_degree_with_tq_female') : 0;
                                $master_degree_with_tq_total = ($sumSurvey->sum('master_degree_with_tq_total')) ? $sumSurvey->sum('master_degree_with_tq_total') : 0;
                                $graduate_with_tq_male = ($sumSurvey->sum('graduate_with_tq_male')) ? $sumSurvey->sum('graduate_with_tq_male') : 0;
                                $graduate_with_tq_female = ($sumSurvey->sum('graduate_with_tq_female')) ? $sumSurvey->sum('graduate_with_tq_female') : 0;
                                $graduate_with_tq_total = ($sumSurvey->sum('graduate_with_tq_total')) ? $sumSurvey->sum('graduate_with_tq_total') : 0;
                                $graduate_without_tq_male = ($sumSurvey->sum('graduate_without_tq_male')) ? $sumSurvey->sum('graduate_without_tq_male') : 0;
                                $graduate_without_tq_female = ($sumSurvey->sum('graduate_without_tq_female')) ? $sumSurvey->sum('graduate_without_tq_female') : 0;
                                $graduate_without_tq_total = ($sumSurvey->sum('graduate_without_tq_total')) ? $sumSurvey->sum('graduate_without_tq_total') : 0;
                                $hnd_with_tq_male = ($sumSurvey->sum('hnd_with_tq_male')) ? $sumSurvey->sum('hnd_with_tq_male') : 0;
                                $hnd_with_tq_female = ($sumSurvey->sum('hnd_with_tq_female')) ? $sumSurvey->sum('hnd_with_tq_female') : 0;
                                $hnd_with_tq_total = ($sumSurvey->sum('hnd_with_tq_total')) ? $sumSurvey->sum('hnd_with_tq_total') : 0;
                                $hnd_without_tq_male = ($sumSurvey->sum('hnd_without_tq_male')) ? $sumSurvey->sum('hnd_without_tq_male') : 0;
                                $hnd_without_tq_female = ($sumSurvey->sum('hnd_without_tq_female')) ? $sumSurvey->sum('hnd_without_tq_female') : 0;
                                $hnd_without_tq_total = ($sumSurvey->sum('hnd_without_tq_total')) ? $sumSurvey->sum('hnd_without_tq_total') : 0;
                                $nce_male = ($sumSurvey->sum('nce_male')) ? $sumSurvey->sum('nce_male') : 0;
                                $nce_female = ($sumSurvey->sum('nce_female')) ? $sumSurvey->sum('nce_female') : 0;
                                $nce_total = ($sumSurvey->sum('nce_total')) ? $sumSurvey->sum('nce_total') : 0;
                                $ond_and_equivalent_male = ($sumSurvey->sum('ond_and_equivalent_male')) ? $sumSurvey->sum('ond_and_equivalent_male') : 0;
                                $ond_and_equivalent_female = ($sumSurvey->sum('ond_and_equivalent_female')) ? $sumSurvey->sum('ond_and_equivalent_female') : 0;
                                $ond_and_equivalent_total = ($sumSurvey->sum('ond_and_equivalent_total')) ? $sumSurvey->sum('ond_and_equivalent_total') : 0;
                                $others_male = ($sumSurvey->sum('others_male')) ? $sumSurvey->sum('others_male') : 0;
                                $others_female = ($sumSurvey->sum('others_female')) ? $sumSurvey->sum('others_female') : 0;
                                $others_total = ($sumSurvey->sum('others_total')) ? $sumSurvey->sum('others_total') : 0;
                            @endphp
                        <tr>
                            <td>{{strtoupper($lga->name)}}</td>
                            <td>{{$master_degree_with_tq_male}}</td>
                            <td>{{$master_degree_with_tq_female}}</td>
                            <td>{{$master_degree_with_tq_total}}</td>
                            <td>{{$graduate_with_tq_male}}</td>
                            <td>{{$graduate_with_tq_female}}</td>
                            <td>{{$graduate_with_tq_total}}</td>
                            <td>{{$graduate_without_tq_male}}</td>
                            <td>{{$graduate_without_tq_female}}</td>
                            <td>{{$graduate_without_tq_total}}</td>
                            <td>{{$hnd_with_tq_male}}</td>
                            <td>{{$hnd_with_tq_female}}</td>
                            <td>{{$hnd_with_tq_total}}</td>
                            <td>{{$hnd_without_tq_male}}</td>
                            <td>{{$hnd_without_tq_female}}</td>
                            <td>{{$hnd_without_tq_total}}</td>
                            <td>{{$nce_male}}</td>
                            <td>{{$nce_female}}</td>
                            <td>{{$nce_total}}</td>
                            <td>{{$ond_and_equivalent_male}}</td>
                            <td>{{$ond_and_equivalent_female}}</td>
                            <td>{{$ond_and_equivalent_total}}</td>
                            <td>{{$others_male}}</td>
                            <td>{{$others_female}}</td>
                            <td>{{$others_total}}</td>
                        </tr>
                        @endforeach
                      </tbody>
                    </table>
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Classrooms:</th>
                          <th>Number Available</th>
                          <th>Number In Good Condition</th>
                          <th>Number Needed</th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach($lgas as $lga)
                            @php
                                $sumSurvey = App\SchoolSurvey::where('local_government_area', $lga->name)->where('session', $session);
                                $classrooms_available = ($sumSurvey->sum('classrooms_available')) ? $sumSurvey->sum('classrooms_available') : 0;
                                $classrooms_in_good_condition = ($sumSurvey->sum('classrooms_in_good_condition')) ? $sumSurvey->sum('classrooms_in_good_condition') : 0;
                                $classrooms_needed = ($sumSurvey->sum('classrooms_needed')) ? $sumSurvey->sum('classrooms_needed') : 0;
                            @endphp
                        <tr>
                            <td>{{strtoupper($lga->name)}}</td>
                            <td>{{$classrooms_available}}</td>
                            <td>{{$classrooms_in_good_condition}}</td>
                            <td>{{$classrooms_needed}}</td>
                        </tr>
                        @endforeach
                      </tbody>
                    </table>
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Laboratories:</th>
                          <th>Number Available</th>
                          <th>Number In Good Condition</th>
                          <th>Number Needed</th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach($lgas as $lga)
                            @php
                                $sumSurvey = App\SchoolSurvey::where('local_government_area', $lga->name)->where('session', $session);
                                $laboratories_available = ($sumSurvey->sum('laboratories_available')) ? $sumSurvey->sum('laboratories_available') : 0;
                                $laboratories_in_good_condition = ($sumSurvey->sum('laboratories_in_good_condition')) ? $sumSurvey->sum('laboratories_in_good_condition') : 0;
                                $laboratories_needed = ($sumSurvey->sum('laboratories_needed')) ? $sumSurvey->sum('laboratories_needed') : 0;
                            @endphp
                        <tr>
                            <td>{{strtoupper($lga->name)}}</td>
                            <td>{{$laboratories_available}}</td>
                            <td>{{$laboratories_in_good_condition}}</td>
                            <td>{{$laboratories_needed}}</td>
                        </tr>
                        @endforeach
                      </tbody>
                    </table>
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Computer Rooms:</th>
                          <th>Number Available</th>
                          <th>Number In Good Condition</th>
                          <th>Number Needed</th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach($lgas as $lga)
                            @php
                                $sumSurvey = App\SchoolSurvey::where('local_government_area', $lga->name)->where('session', $session);
                                $computerroom_available = ($sumSurvey->sum('computerroom_available')) ? $sumSurvey->sum('computerroom_available') : 0;
                                $computerroom_in_good_condition = ($sumSurvey->sum('computerroom_in_good_condition')) ? $sumSurvey->sum('computerroom_in_good_condition') : 0;
                                $computerroom_needed = ($sumSurvey->sum('computerroom_needed')) ? $sumSurvey->sum('computerroom_needed') : 0;
                            @endphp
                        <tr>
                            <td>{{strtoupper($lga->name)}}</td>
                            <td>{{$computerroom_available}}</td>
                            <td>{{$computerroom_in_good_condition}}</td>
                            <td>{{$computerroom_needed}}</td>
                        </tr>
                        @endforeach
                      </tbody>
                    </table>
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Technical Workshops:</th>
                          <th>Number Available</th>
                          <th>Number In Good Condition</th>
                          <th>Number Needed</th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach($lgas as $lga)
                            @php
                                $sumSurvey = App\SchoolSurvey::where('local_government_area', $lga->name)->where('session', $session);
                                $technical_workshop_available = ($sumSurvey->sum('technical_workshop_available')) ? $sumSurvey->sum('technical_workshop_available') : 0;
                                $technical_workshop_in_good_condition = ($sumSurvey->sum('technical_workshop_in_good_condition')) ? $sumSurvey->sum('technical_workshop_in_good_condition') : 0;
                                $technical_workshop_needed = ($sumSurvey->sum('technical_workshop_needed')) ? $sumSurvey->sum('technical_workshop_needed') : 0;
                            @endphp
                        <tr>
                            <td>{{strtoupper($lga->name)}}</td>
                            <td>{{$technical_workshop_available}}</td>
                            <td>{{$technical_workshop_in_good_condition}}</td>
                            <td>{{$technical_workshop_needed}}</td>
                        </tr>
                        @endforeach
                      </tbody>
                    </table>
                    <table class="ui celled structured table" style="margin: 0px !important;">
                      <thead>
                        <tr>
                          <th rowspan="2">Total Libraries:</th>
                          <th>Number Available</th>
                          <th>Number In Good Condition</th>
                          <th>Number Needed</th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach($lgas as $lga)
                            @php
                                $sumSurvey = App\SchoolSurvey::where('local_government_area', $lga->name)->where('session', $session);
                                $library_available = ($sumSurvey->sum('library_available')) ? $sumSurvey->sum('library_available') : 0;
                                $library_in_good_condition = ($sumSurvey->sum('library_in_good_condition')) ? $sumSurvey->sum('library_in_good_condition') : 0;
                                $library_workshop = ($sumSurvey->sum('library_workshop')) ? $sumSurvey->sum('library_workshop') : 0;
                            @endphp
                        <tr>
                            <td>{{strtoupper($lga->name)}}</td>
                            <td>{{$library_available}}</td>
                            <td>{{$library_in_good_condition}}</td>
                            <td>{{$library_workshop}}</td>
                        </tr>
                        @endforeach
                      </tbody>
                    </table>
                @endif
                <br>
                <div class="p-left">
                    <button type="button" class="no-print export-hide ui black labeled icon button" onclick="switchPage(1)">
                      <i class="left arrow icon"></i>
                      Previous
                    </button>
                </div>
                <div style="clear: both;"></div>
            </div>
        </form>
    </div>
    <div id="editor"></div>
    <style>
        .survey-form{
            width: -webkit-fill-available;
            margin: 20px auto;
            padding: 20px;
            /*display: flex;*/
            position: relative;
        }
        .main-loader{
            position: absolute;
            top: 0px;
            left: 0px;
            bottom: 0px;
            right: 0px;
            z-index: 5;
        }
        .survey-form .segment{
            z-index: -1;
        }
        .survey-form.all-page .segment{
            display: block !important;
        }
        .survey-form li{
          margin: 15px 0px;
          color: #000;
          font-weight: bold;
          font-size: 15px;
        }
        .survey-form .segment .watermark{
          background: url('https://odsgmoe.com/eportal/public/images/header-logo.png');
          background-position: center;
          opacity: 0.1;
          position: absolute;
          top: 50%;
          left: 50%;
          transform: translate(-50%, -50%);
          width: 100%;
          height: 100%;
        }
        .survey-form .segment table{
          background: transparent;
        }
        .survey-form li .answer{
          margin-left: 10px;
          color: #777;
          font-weight: bold;
          font-size: 16px;
          text-transform: capitalize;
        }
        .survey-form td .answer{
          margin-left: 10px;
          color: #777;
          font-weight: bold;
          font-size: 16px;
          text-transform: capitalize;
        }
        .survey-form .field{
            padding: 15px 15px;
        }
        .survey-form .p-right{
            float: right;
        }
        .survey-form .p-left{
            float: left;
        }
        .survey-form .hidden{
            display: none;
        }
        .num_table input{
            width: 70px;
        }
        .export{
          margin-bottom: 20px;
        }
        .alert-news li{
          font-size: 13px !important;
          font-weight: lighter;
        }
        .alert-news li b{
          font-size: 13px !important;
          font-weight: 900 !important;
        }
        .teacher---sort .field{
          padding: 0px !important;
        }
    </style>
@endsection
@section('scripts')
    <script src="https://odsgmoe.com/eportal/public/js/chart.min.js"></script>
    <script src="https://odsgmoe.com/eportal/public/js/jspdf.js"></script>
    <script>
        window.onload = function(){
            MainChart.init();
            MainChart.fetchSummary();
        };
        
        $(function(){
            $('.ui.radio.checkbox').checkbox();
            $('.ui.accordion').accordion();
            $('.export-btn').popup();
        });
        
        function getIMages(){
            return new Promise(resolve => {
                var counter = 1;
                var doc = new jsPDF();
                var width = doc.internal.pageSize.width;
                var height = doc.internal.pageSize.height;
                var lastPage = '{{$lga->count()}}';
                doc.setFontSize(12);
                doc.text(35, 25, $('.survey-form').attr('data-title'));
                
                $('.survey-form .segment').each(function(){
                    var segmentHeight = $(this).height();
                    html2canvas($(this).get(0)).then(function (canvas) {
                    var canvasWidth = canvas.width;
                    var canvasHeight = canvas.height;
                        var img = canvas.toDataURL('image/jpeg');
                        
                        // Before adding new content
                        y = segmentHeight // Height position of new content
                        if (y >= height && counter != 1)
                        {
                          doc.addPage();
                          y = 0 // Restart height position
                        }

                        doc.addImage(img, 'JPEG', 0, 0, width, height);
                        if(counter == lastPage){
                            resolve(doc);
                        }
                        counter++;
                    })
                });
            });
        }
        
        function preparePage(){
            return new Promise(resolve => {
                $('.export-btn').popup('hide all');
                resolve();
            });
        }
        
        async function genPDF(obj){
            var btn = $(obj);
            var doc = await getIMages();

            doc.save(`${$('.survey-form').attr('data-title')}.pdf`);
            btn.removeClass('loading');
            btn.css('pointer-events', 'all');
        }

        async function printPage(){
            var page = await preparePage();
            window.print();
           
        }
        
        function exportExcel(){
            $('.lga-export-form').toggleClass('hidden');
        }

        function switchPage(number){
            $('.survey-form .segment').each(function(){
                $(this).slideUp('fast');
            });
            $(`.survey-form .segment[data-page=${number}]`).slideDown('fast');
            
            $('.page-count a.black').addClass('grey');
            $('.page-count a.black').removeClass('black');
            
            $(`.page-count a[data-page=${number}]`).addClass('black');
            $(`.page-count a[data-page=${number}]`).removeClass('grey');
        }
        
        // charts
        const MainChart = {
            getChartData: function(){
                return new Promise(resolve => {
                    $.ajax({
                        url: '{{url("ministry/schools-survey-stats-data")}}/{{$session}}',
                        type: 'GET',
                        success: function(res){
                            // $('.main-loader').remove();
                            resolve(res);
                        },
                        error: function(err){
                            console.log(err.responsJSON.message);
                        }
                    });
                });
            },
            
            fetchSummary: function(){
                $.ajax({
                    url: '{{url("ministry/schools-survey-stats-data-summary")}}/{{$session}}',
                    type: 'GET',
                    success: function(res){
                        $('.main-loader').remove();
                        
                        if(res.data.length){
                            $.each(res.data, function(index, value){
                                var segment = $(`.survey-form .segment[data-id=${value.id}]`);
                                var table = segment.find('.summary--table');
                                var schools = value.schools;
                                if(schools.length){
                                    $row = '';
                                    $counter = 1;
                                    $.each(schools, function(index, value){
                                        $row += `
                                            <tr>
                                            <td>${$counter}</td>
                                            <td>${value.name}</td>
                                            ${(() => {
                                            if(value.survey.id != undefined && value.survey.id != null && value.survey.id != ''){
                                                var survey = value.survey;
                                                return `
                                                    <td class="number_of_students">${survey.number_of_students}</td>
                                                    <!--subs-->
                                                    <td class="classrooms_available">${survey.classrooms_available}</td>
                                                    <td class="classrooms_in_good_condition">${survey.classrooms_in_good_condition}</td>
                                                    <td class="classrooms_needed">${survey.classrooms_needed}</td>
                                                    <td class="laboratories_available">${survey.laboratories_available}</td>
                                                    <td class="laboratories_in_good_condition">${survey.laboratories_in_good_condition}</td>
                                                    <td class="laboratories_needed">${survey.laboratories_needed}</td>
                                                    <td class="computerroom_available">${survey.computerroom_available}</td>
                                                    <td class="computerroom_in_good_condition">${survey.computerroom_in_good_condition}</td>
                                                    <td class="computerroom_needed">${survey.computerroom_needed}</td>
                                                    <td class="technical_workshop_available">${survey.technical_workshop_available}</td>
                                                    <td class="technical_workshop_in_good_condition">${survey.technical_workshop_in_good_condition}</td>
                                                    <td class="technical_workshop_needed">${survey.technical_workshop_needed}</td>
                                                    <td class="library_available">${survey.library_available}</td>
                                                    <td class="library_in_good_condition">${survey.library_in_good_condition}</td>
                                                    <td class="library_workshop">${survey.library_workshop}</td>
                                                    <td colspan="3" class="toilet">${survey.toilet}</td>
                                                    <td colspan="3" class="school_fence">${survey.school_fence}</td>
                                                    <!--end subs-->
                                                    <td></td>
                                                `;
                                            }else{
                                                return `<td colspan="23">Survey record for session not found</td>`;
                                            }
                                            })()}  
                                            </tr>
                                        `; 
                                        $counter++
                                    });
                                    table.find('tbody').html($row);
                                }
                                segment.find('.dummy-loader').remove();
                                MainChart.sumTotals();
                            });
                        }
                    },
                    error: function(err){
                        console.log(err.responsJSON.message);
                    }
                });
            },

            sumTotals: function(){
                // $('.survey-form .segment').each(function(){
                //     var table = $(this).find('.summary--table');
                //     if(table.length > 0){
                //         console.log(table.html())
                //         table.find('.number_of_students').each(function(){
                //             console.log($(this).html());
                //         });
                //     }
                // });
            },
            
            init: async function(){
                var data = await MainChart.getChartData();
                
                MainChart.generalChart(data);
                MainChart.generalLgaChart(data);
                MainChart.juniorChart(data);
                MainChart.seniorChart(data);
            },
            
            // general chart
            generalChart: function(data){
                var adminCount = data.general_chart.admin_count;
                var teacherCount =  data.general_chart.teacher_count;
                var studentCount =  data.general_chart.student_count;
                var config = {
              type: 'doughnut',
              data: {
                datasets: [{
                  data: [adminCount, teacherCount, studentCount],
                  backgroundColor: [
                              'rgba(239, 95, 131, 1)',
                              'rgb(54, 162, 235)',
                              'rgb(255, 205, 86)'
                            ],
                  label: 'General chart'
                }],
                labels: ['Administrators', 'Teachers', 'Students']
              },
              options: {
                responsive: true,
                legend: {
                  position: 'top',
                },
                title: {
                  display: true,
                  text: 'General Schools Analysis'
                },
                animation: {
                  animateScale: true,
                  animateRotate: true
                }
              }
            };
            
          var ctx = document.getElementById('generalChart').getContext('2d');
          window.myDoughnut = new Chart(ctx, config);
            },
            
            generalLgaChart: function(data){
                var mainData = data.lga_chart.states_school_counts;
                var mainLabels = data.lga_chart.states_name;
                var mainColors = data.lga_chart.colors;
                var mainBorderColors = data.lga_chart.border_colors;
                var ctx = document.getElementById('generalLgaChart').getContext('2d');
                var myChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: mainLabels,
                        datasets: [{
                            label: '#Schools in LGA',
                            data: mainData,
                            backgroundColor: mainColors,
                            borderColor: mainBorderColors,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        scales: {
                            yAxes: [{
                                ticks: {
                                    beginAtZero: true
                                }
                            }]
                        }
                    }
                });
            },
            
            juniorChart: function(data){
                var jssOneCount =  data.junior_chart.jss_one;
                var jssTwoCount =  data.junior_chart.jss_two;
                var jssThreeCount =  data.junior_chart.jss_three;
                var totalCount = parseInt(jssOneCount) + parseInt(jssTwoCount) + parseInt(jssThreeCount);
                var config = {
              type: 'bar',
              data: {
                datasets: [{
                  data: [jssOneCount, jssTwoCount, jssThreeCount],
                  backgroundColor: [
                              'rgba(239, 95, 131, 1)',
                              'rgb(54, 162, 235)',
                              'rgb(255, 205, 86)'
                            ],
                  label: 'Junior Graphical Representation'
                }],
                labels: ['Jss1', 'Jss2', 'Jss3']
              },
              options: {
                responsive: true,
                legend: {
                  position: 'bottom',
                },
                title: {
                  display: true,
                  text: `Total: ${totalCount}`
                },
                animation: {
                  animateScale: true,
                  animateRotate: true
                }
              }
            };
            
          var ctx = document.getElementById('juniorChart').getContext('2d');
          window.myDoughnut = new Chart(ctx, config);
            },
            
            seniorChart: function(data){
                var ssOneCount =  data.senior_chart.ss_one;
                var ssTwoCount =  data.senior_chart.ss_two;
                var ssThreeCount =  data.senior_chart.ss_three;
                var totalCount = parseInt(ssOneCount) + parseInt(ssTwoCount) + parseInt(ssThreeCount);
                var config = {
              type: 'pie',
              data: {
                datasets: [{
                  data: [ssOneCount, ssTwoCount, ssThreeCount],
                  backgroundColor: [
                              'rgba(239, 95, 131, 1)',
                              'rgb(54, 162, 235)',
                              'rgb(255, 205, 86)'
                            ],
                  label: 'Senior Graphical Representation'
                }],
                labels: ['ss1', 'ss2', 'ss3']
              },
              options: {
                responsive: true,
                legend: {
                  position: 'bottom',
                },
                title: {
                  display: true,
                  text: `Total: ${totalCount}`
                },
                animation: {
                  animateScale: true,
                  animateRotate: true
                }
              }
            };
            
          var ctx = document.getElementById('seniorChart').getContext('2d');
          window.myDoughnut = new Chart(ctx, config);
            }
        }
    </script>
@endsection