@extends('layouts.main-datatable')
@section('content')

<style type="text/css">
.mb30 {
    margin-bottom: 30px;
}
h3 em {
    color: #dc4900;
}
p strong em {
    color: #dc4900;
}
.scrollable_content_box {height:300px; padding:1% 1%; background:#f1f1f1; border:2px solid #CCC; overflow-y:scroll;}
</style>

<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">
    @if(isset($_GET['action']) && $_GET['action'] == 'table')
    <h2 class="ui dividing header text_center print-none"> 
    <a class="ui button blue pull_right" href="?">Quick Stat</a>
    <a class="ui button blue pull_right" href="?action=table-broad">Stat Table (Broad)</a>
    <a class="ui button blue pull_right" href="?action=school-result-indicator">Result Stat</a>
    <a class="ui button blue pull_right" href="?action=school-subjects">Subject Stat</a>
    <a class="ui button blue pull_right" href="?action=school-subjects-broad">Subject Stat (Broad)</a>
     <?php echo $title; ?> <span style="float: right;font-size: 13px;color: #000;">Total no of schools: {{App\School::all()->count()}}</span></h2>
     
    <img class="ui fuild image print-show" src="{{url_public('/images/header-logo.png')}}" style="width:100%;display:none;" height="100">

     <form action="" method="post" class="form-horizontal global_form">
        <div class="two fields">
        {{csrf_field()}}

        <div class="form-group mb30">
            <label class="col-md-3 control-label">Choose LGA</label>
            <div class="col-md-5">
                <div class="field">
                    <select id="lga_id" name="lga_id" required class="ui fluid search dropdown">
                        <option value="">Select LGA</option>
                          @foreach($ngstate_lgas as $ngstate_lga)
                              <option value="{{$ngstate_lga->id}}">{{$ngstate_lga->name}}</option>
                          @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="form-group mb30">
            <label class="col-md-3 control-label">Choose Session</label>
            <div class="col-md-5">
                <div class="field">
                    <select id="session_val" name="session" required class="ui fluid search dropdown">
                        <option value="">Select Session</option>
                        @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                         <option value="{{$i}}">{{$i}}/{{$i+1}}</option>
                        @endfor
                    </select>
                </div>
            </div>
        </div>

        <div class="form-group mb30">
            <label class="col-md-3 control-label">User Type</label>
            <div class="col-md-5">
                <div class="field">
                    <select id="user_type" name="user_type" required class="ui fluid dropdown">
                        <option value="">Select</option>
                        <option value="Student">Student</option>
                        <option value="Teacher">Teacher</option>
                    </select>
                </div>
            </div>
        </div>

          <div class="field mb30">
            <input type="button" class="ui small blue button" id="form_submit" name="form_submit" value="Generate Statistics Table" />
          </div>
         </div>
        </form>

    <div id="statTableHolder"></div>
    
    @elseif(isset($_GET['action']) && $_GET['action'] == 'table-broad')

    <h2 class="ui dividing header text_center print-none"> 
    <a class="ui button blue pull_right" href="?">Quick Stat</a>
    <a class="ui button blue pull_right" href="?action=table">Stat Table</a>
    <a class="ui button blue pull_right" href="?action=school-result-indicator">Result Stat</a>
    <a class="ui button blue pull_right" href="?action=school-subjects">Subject Stat</a>
    <a class="ui button blue pull_right" href="?action=school-subjects-broad">Subject Stat (Broad)</a>
     <?php echo $title; ?> <span style="float: right;font-size: 13px;color: #000;">Total no of schools: {{App\School::all()->count()}}</span></h2>
     
    <img class="ui fuild image print-show" src="{{url_public('/images/header-logo.png')}}" style="width:100%;display:none;" height="100">

     <form action="" method="post" class="form-horizontal global_form">
        <div class="two fields">
        {{csrf_field()}}

        <div class="form-group mb30">
            <label class="col-md-3 control-label">Choose LGA</label>
            <div class="col-md-5">
                <div class="field">
                    <select id="lga_id" name="lga_id" required class="ui fluid search dropdown">
                        <option value="">Select LGA</option>
                          @foreach($ngstate_lgas as $ngstate_lga)
                              <option value="{{$ngstate_lga->id}}">{{$ngstate_lga->name}}</option>
                          @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="form-group mb30">
            <label class="col-md-3 control-label">Choose Session</label>
            <div class="col-md-5">
                <div class="field">
                    <select id="session_val" name="session" required class="ui fluid search dropdown">
                        <option value="">Select Session</option>
                        @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                         <option value="{{$i}}">{{$i}}/{{$i+1}}</option>
                        @endfor
                    </select>
                </div>
            </div>
        </div>

          <div class="field mb30">
            <input type="button" class="ui small blue button" id="form_submit_broad" name="form_submit_broad" value="Generate Statistics Table" />
          </div>
         </div>
        </form>

    <div id="statBroadTableHolder"></div>

    @elseif(isset($_GET['action']) && $_GET['action'] == 'school-subjects')

    <h2 class="ui dividing header text_center print-none"> 
    <a class="ui button blue pull_right" href="?">Quick Stat</a>
    <a class="ui button blue pull_right" href="?action=table">Stat Table</a>
    <a class="ui button blue pull_right" href="?action=table-broad">Stat Table (Broad)</a>
    <a class="ui button blue pull_right" href="?action=school-result-indicator">Result Stat</a>
    <a class="ui button blue pull_right" href="?action=school-subjects-broad">Subject Stat (Broad)</a>
     <?php echo $title; ?> <span style="float: right;font-size: 13px;color: #000;">Total no of schools: {{App\School::all()->count()}}</span></h2>
     
    <img class="ui fuild image print-show" src="{{url_public('/images/header-logo.png')}}" style="width:100%;display:none;" height="100">

     <form action="" method="post" class="form-horizontal global_form">
        <div class="two fields">
        {{csrf_field()}}

        <div class="form-group mb30">
            <label class="col-md-3 control-label">Choose LGA</label>
            <div class="col-md-5">
                <div class="field">
                    <select id="lga_id" name="lga_id" required class="ui fluid search dropdown">
                        <option value="">Select LGA</option>
                          @foreach($ngstate_lgas as $ngstate_lga)
                              <option value="{{$ngstate_lga->id}}">{{$ngstate_lga->name}}</option>
                          @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="form-group mb30">
            <label class="col-md-3 control-label">Choose Subject</label>
            <div class="col-md-5">
                <div class="field">
                    <select id="subject_id" name="subject_id" required class="ui fluid search dropdown">
                        <option value="">Select Subject</option>
                          @foreach($subjects as $subject)
                              <option value="{{$subject->id}}">{{$subject->subject_name}} ({{$subject->class_category}})</option>
                          @endforeach
                    </select>
                </div>
            </div>
        </div>

          <div class="field mb30">
            <input type="button" class="ui small blue button" id="form4_submit" name="form4_submit" value="Generate Statistics" />
          </div>
         </div>
        </form>

    <div id="schoolSubjectStat"></div>  
    
    @elseif(isset($_GET['action']) && $_GET['action'] == 'school-subjects-broad')

    <h2 class="ui dividing header text_center print-none"> 
    <a class="ui button blue pull_right" href="?">Quick Stat</a>
    <a class="ui button blue pull_right" href="?action=table">Stat Table</a>
    <a class="ui button blue pull_right" href="?action=table-broad">Stat Table (Broad)</a>
    <a class="ui button blue pull_right" href="?action=school-result-indicator">Result Stat</a>
    <a class="ui button blue pull_right" href="?action=school-subjects">Subject Stat</a>
     <?php echo $title; ?> <span style="float: right;font-size: 13px;color: #000;">Total no of schools: {{App\School::all()->count()}}</span></h2>
     
    <img class="ui fuild image print-show" src="{{url_public('/images/header-logo.png')}}" style="width:100%;display:none;" height="100">

     <form action="" method="post" class="form-horizontal global_form">
        <div class="two fields">
        {{csrf_field()}}

        <div class="form-group mb30">
            <label class="col-md-3 control-label">Choose LGA</label>
            <div class="col-md-5">
                <div class="field">
                    <select id="lga_id" name="lga_id" required class="ui fluid search dropdown">
                        <option value="">Select LGA</option>
                          @foreach($ngstate_lgas as $ngstate_lga)
                              <option value="{{$ngstate_lga->id}}">{{$ngstate_lga->name}}</option>
                          @endforeach
                    </select>
                </div>
            </div>
        </div>

          <div class="field mb30">
            <input type="button" class="ui small blue button" id="form3_submit" name="form3_submit" value="Generate Statistics" />
          </div>
         </div>
        </form>

    <div id="schoolSubjectStatBroad"></div>     
    
    @elseif(isset($_GET['action']) && $_GET['action'] == 'school-result-indicator')

    <h2 class="ui dividing header text_center print-none"> 
    <a class="ui button blue pull_right" href="?">Quick Stat</a>
    <a class="ui button blue pull_right" href="?action=table">Stat Table</a>
    <a class="ui button blue pull_right" href="?action=table-broad">Stat Table (Broad)</a>
    <a class="ui button blue pull_right" href="?action=school-subjects">Subject Stat</a>
    <a class="ui button blue pull_right" href="?action=school-subjects-broad">Subject Stat (Broad)</a>
     <?php echo $title; ?> <span style="float: right;font-size: 13px;color: #000;">Total no of schools: {{App\School::all()->count()}}</span></h2>
     
    <img class="ui fuild image print-show" src="{{url_public('/images/header-logo.png')}}" style="width:100%;display:none;" height="100">

     <form action="" method="post" class="form-horizontal global_form">
        <div class="two fields">
        {{csrf_field()}}
        
        <div class="form-group mb30">
            <label class="col-md-3 control-label">Select LGA</label>
            <div class="col-md-5">
                <div class="field">
                    <select id="lga_id" onchange="showRangeInput(this)" name="lga_id" required class="ui fluid search dropdown">
                        <option value="">Select LGA</option>
                        <option value="all">All LGA</option>
                          @foreach($ngstate_lgas as $ngstate_lga)
                              <option value="{{$ngstate_lga->id}}">{{$ngstate_lga->name}}</option>
                          @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="ui form form-group mb30 range_field" style="padding:0px 16px;display: none;">
            <div class="three fields">
                <div class="field">
                    <div class="ui labeled input">
                      <div class="ui label">
                        From:
                      </div>
                      <input type="number" min="0" name="from" class="from__input" placeholder="0">
                    </div>
                </div>
                <div class="field">
                    <div class="ui labeled input">
                      <div class="ui label">
                        Number Of Records to Return:
                      </div>
                      <input type="number" min="0" name="to" class="to__input" placeholder="0">
                    </div>
                </div>
                <div class="field">
                    <select id="with_result__input" name="with_result" class="ui fluid search dropdown">
                        <option selected value="yes">With Results</option>
                        <option value="no">Without Results</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="form-group mb30">
            <label class="col-md-3 control-label">Select Session</label>
            <div class="col-md-5">
                <div class="field">
                    <select id="session_val" name="session" required class="ui fluid search dropdown">
                        <option value="">Select Session</option>
                        @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                         <option value="{{$i}}">{{$i}}/{{$i+1}}</option>
                        @endfor
                    </select>
                </div>
            </div>
        </div>

        <div class="form-group mb30">
            <label class="col-md-3 control-label">Select Term</label>
            <div class="col-md-5">
                <div class="field">
                    <select id="term" name="term" required class="ui fluid search dropdown">
                        <option value="">Select Term</option>
                         <option value="First">First Term</option>  
                         <option value="Second">Second Term</option>  
                         <option value="Third">Third Term</option>                         
                    </select>
                </div>
            </div>
        </div>
        

          <div class="field mb30">
            <input type="button" class="ui small blue button" id="form2_submit" name="form2_submit" value="Generate Statistics Table" />
          </div>
         </div>
        </form>

    <div id="schoolSessionResultIndicator"></div>
   
    @else    
    <h2 class="ui dividing header text_center print-none">
    <a class="ui button blue pull_right" href="?action=table">Stat Table</a> 
    <a class="ui button blue pull_right" href="?action=table-broad">Stat Table (Broad)</a>
    <a class="ui button blue pull_right" href="?action=school-result-indicator">Result Stat</a>
    <a class="ui button blue pull_right" href="?action=school-subjects">Subject Stat</a>
    <a class="ui button blue pull_right" href="?action=school-subjects-broad">Subject Stat (Broad)</a>
     <?php echo $title; ?> <span style="float: right;font-size: 13px;color: #000;">Total no of schools: {{App\School::all()->count()}}</span></h2>
    
    <div class="ui grid">
        <div class="four wide column">
            <div class="ui vertical fluid tabular menu">
            <a href="{{url('ministry/school-statistics')}}" class="item @if(!isset($_GET['action']) || $_GET['action'] == '') active @endif">
                View live
            </a>
            <a href="{{url('ministry/school-statistics?action=view_all')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'view_all') active @endif">
                View all
            </a>
            <a class="item @if(isset($_GET['action']) && $_GET['action'] == 'view_lga') active @endif">
                <form class="ui left action input">
                    <input type="hidden" name="action" value="view_lga">
                    <button class="ui button">LGA:</button>
                    <select name="value" class="ui fluid search dropdown">
                        <option value="">Choose LGA</option>
                        @if($item_rows = DB::table('ondo_lgas')->where('state_id', 28)->get())
                            @foreach ($item_rows as $item_data)
                            <option <?php if(isset($_GET['value']) && $_GET['value'] == $item_data->id){ echo 'selected'; } ?> value="{{$item_data->id}}">{{$item_data->name}}</option>
                            @endforeach
                        @endif
                    </select>
                </form>
            </a>
            
            <br>
            <br>
            
            @if($state_stat_status)
            <div>
                <h3>Ondo Statistic Overview</h3>
                <p>Total Teacher: {{$state_teachers}}</p>
                <p>Total Student: {{$state_students}}</p>
                <p>Total Male Student: {{$state_students_male}}</p>
                <p>Total Female Student: {{$state_students_female}}</p>
            </div>
            @endif
            
            </div>
        </div>
        <div class="twelve wide stretched column">
            <div class="ui segment">
                @if(isset($_GET['action']) && $_GET['action'] == 'view_all')
                <div class="c8">
                    <img class="ui fuild image" src="{{url_public('/images/ill-stats.png')}}" style="width:100%" height="250">
                    <table class="ui celled table">
                    <thead>
                        <tr>
                            <th>
                                <div class="ui ribbon label">School name</div>
                            </th>
                            <th>
                                <div class="ui ribbon label">School Logo</div>
                            </th>
                            <th>
                                <div class="ui ribbon label">School LGA</div>
                            </th>
                            <th colspan="2">
                                <div class="ui ribbon label">Actions on School</div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    @if(count($schools) > 0)
                        @foreach($schools as $school)
                        <tr>
                        <td>{{$school->name}}</td>
                        <td><img src="{{url_public($school->logo)}}" class="ui fluid image"></td>
                        <td>{{$school->ondo_lga->name}}</td>
                        <td class="std-view" width="250">
                            <button style="background: #3caeb7;color: #fff;"  class="ui labeled icon button showStatsBtn" school-name="{{$school->name}}" school-id="{{$school->id}}">
                            <i class="edit icon"></i>
                            View School Statistics
                            </button>
                        </td>
                        </tr>
                    @endforeach
                        @else
                        <tr>
                            <th colspan="6">
                                <div class="ui icon negative message">
                                <i class="info circle icon"></i>
                                <div class="content">
                                    <div class="header">
                                    Sorry, No Record can be found.
                                    </div>
                                </div>
                                </div>
                            </th>
                        </tr>
                    @endif
                    </tbody>
                    <tfoot>
                        <tr><th colspan="6">
                        @include('pagination.default', ['paginator' => $schools])
                        </th>
                    </tr></tfoot>
                    </table>
                </div>
                @elseif(isset($_GET['action']) && $_GET['action'] == 'view_lga')
                <div class="c8">
                    <div class="wallpaper">
                        <img class="" src="{{url_public('/images/ill-stats.png')}}">
                        <h1>{{$lga_name}}</h1>
                    </div>
                    <div class="main">
                        <table class="ui celled table">
                            <thead>
                                <tr>
                                    <th>
                                        <div class="ui ribbon label">School name</div>
                                    </th>
                                    <th>
                                        <div class="ui ribbon label">School Logo</div>
                                    </th>
                                    <th>
                                        <div class="ui ribbon label">School LGA</div>
                                    </th>
                                    <th colspan="2">
                                        <div class="ui ribbon label">Actions on School</div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                            @if(count($schools) > 0)
                                @foreach($schools as $school)
                                <tr>
                                <td>{{$school->name}}</td>
                                <td><img src="{{url_public($school->logo)}}" class="ui fluid image"></td>
                                <td>{{$school->ondo_lga->name}}</td>
                                <td class="std-view" width="250">
                                    <button style="background: #3caeb7;color: #fff;"  class="ui labeled icon button showStatsBtn" school-name="{{$school->name}}" school-id="{{$school->id}}">
                                    <i class="edit icon"></i>
                                    View School Statistics
                                    </button>
                                </td>
                                </tr>
                            @endforeach
                                @else
                                <tr>
                                    <th colspan="6">
                                        <div class="ui icon negative message">
                                        <i class="info circle icon"></i>
                                        <div class="content">
                                            <div class="header">
                                            Sorry, No Record can be found.
                                            </div>
                                        </div>
                                        </div>
                                    </th>
                                </tr>
                            @endif
                            </tbody>
                            <tfoot>
                                <tr><th colspan="6">
                                @include('pagination.default', ['paginator' => $schools])
                                </th>
                            </tr></tfoot>
                        </table>
                    </div>
                </div>
                @else
                <div class="c8">
                    <img class="ui fuild image" src="{{url_public('/images/ill-stats.png')}}" style="width:100%" height="250">
                    <table class="ui celled table">
                    <thead>
                        <tr>
                            <th>
                                <div class="ui ribbon label">School name</div>
                            </th>
                            <th>
                                <div class="ui ribbon label">School Logo</div>
                            </th>
                            <th>
                                <div class="ui ribbon label">School LGA</div>
                            </th>
                            <th colspan="2">
                                <div class="ui ribbon label">Actions on School</div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    @if(count($schools) > 0)
                        @foreach($schools as $school)
                        <tr>
                        <td>{{$school->name}}</td>
                        <td><img src="{{url_public($school->logo)}}" class="ui fluid image"></td>
                        <td>{{$school->ondo_lga->name}}</td>
                        <td class="std-view" width="250">
                            <button style="background: #3caeb7;color: #fff;"  class="ui labeled icon button showStatsBtn" school-name="{{$school->name}}" school-id="{{$school->id}}">
                            <i class="edit icon"></i>
                            View School Statistics
                            </button>
                        </td>
                        </tr>
                    @endforeach
                        @else
                        <tr>
                            <th colspan="6">
                                <div class="ui icon negative message">
                                <i class="info circle icon"></i>
                                <div class="content">
                                    <div class="header">
                                    Sorry, No Record can be found.
                                    </div>
                                </div>
                                </div>
                            </th>
                        </tr>
                    @endif
                    </tbody>
                    <tfoot>
                        <tr><th colspan="6">
                        @include('pagination.default', ['paginator' => $schools])
                        </th>
                    </tr></tfoot>
                    </table>
                </div>
                @endif
            </div>
        </div>
    </div>
    @endif
</section>
    
<!-- modals -->
<form class="ui long modal superSchoolStats">
    <!-- <i class="close icon"></i> -->
    <div class="header">
    </div>
    <div class="image content" style="height: 70vh;">
    <div class="image loading">
        loading statistics
    </div>
    <div class="description ui grid">
        <div class="five wide column field loading" style="margin-left: 10px;margin-top: 10px;"></div>
        <div class="stats hard-center" style="display: none;">
        <div class="ui statistics">
            <div class="statistic">
                <div class="value teacher_count">
                0
                </div>
                <div class="label">
                Teachers
                </div>
            </div>
            <div class="statistic">
                <div class="value student_count">
                0
                </div>
                <div class="label">
                Students
                </div>
            </div>
            <div class="statistic">
                <div class="value admin_count">
                0
                </div>
                <div class="label">
                Admins
                </div>
            </div>
        </div>

        <div class="ui stackable equal height stackable grid">
            <div class="row">
                <div class="eight wide column field-line">
                    <div class="ui list">
                        <div class="item">
                            <i class="users icon"></i>
                            <div class="content account">
                            </div>
                        </div>
                        <div class="item">
                            <i class="marker icon"></i>
                            <div class="content location">
                            </div>
                        </div>
                        <div class="item">
                            <i class="clock icon"></i>
                            <div class="content created_at">
                            </div>
                        </div>
                        <div class="item">
                            <i class="linkify icon"></i>
                            <div class="content category">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="eight wide column field-line">                   
                    <div class="ui stackable equal height stackable grid">
                        <div class="eight wide column">
                            <div class="ui special cards">
                            <div class="card">
                                <div class="image" style="padding: 5px;">
                                <img src="{{url_public('/images/boys.png')}}">
                                </div>
                                <div class="content">
                                <!-- <a class="header">Students</a> -->
                                <div class="meta">
                                    <span class="date">Male Count</span>
                                </div>
                                </div>
                                <div class="extra content">
                                <a>
                                    <i class="users icon"></i>
                                    <span class="male_count">0</span> Males
                                </a>
                                </div>
                            </div>
                            </div>
                        </div>

                        <div class="eight wide column">
                            <div class="ui special cards">
                            <div class="card">
                                <div class="image" style="padding: 5px;">
                                <img src="{{url_public('/images/girls.png')}}">
                                </div>
                                <div class="content">
                                <!-- <a class="header">Students</a> -->
                                <div class="meta">
                                    <span class="date">Female Count</span>
                                </div>
                                </div>
                                <div class="extra content">
                                <a>
                                    <i class="users icon"></i>
                                    <span class="female_count">0</span> Females
                                </a>
                                </div>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </div>
    </div>
    <div class="actions">
    <div class="ui cancel button">Cancel</div>
    </div>
</form>
<div class="jtr"></div>
<script type="text/javascript">

var site_url = "{{url('/ministry')}}";
var token = "{{csrf_token()}}";
var ajax_loader = "{{url_public('/images/ajax-loader.gif')}}";

$("#form4_submit").on('click', function() {
    var lga_id = $("#lga_id").val();
    var subject_id = $("#subject_id").val();

    if(lga_id && subject_id){

        var form_data = {
            lga_id : lga_id,
            subject_id : subject_id,
            _token : token
        }

        $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
        $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
        $("#pagewrap_ajax_box").show('slow');          
        $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
        window.oncontextmenu = function(){return false;}    // Disable right click  
        $("select").prop('disabled', true);                    // Disable form input

        $.ajax({
            url :   site_url+"/generate-subject-statistics",
            type :  "POST",
            data :  form_data,
            dataType: "html",
            cache :     false
        })
        .done(function(resp){   
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});  
            $("select").prop('disabled', false);                   // Enable form input       

            $("#schoolSubjectStat").html(resp);
            $('#global_datatable').dataTable();
            })
        .fail(function(){
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
            $("select").prop('disabled', false);                   // Enable form input 

            alert('Error encountered while processing request. Pls try again shortly');  
        });  

    }
    else{
        alert("LGA must be selected to generate statistics")
    }
});

$("#form3_submit").on('click', function() {
    var lga_id = $("#lga_id").val();

    if(lga_id){

        var form_data = {
            lga_id : lga_id,
            _token : token
        }

        $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
        $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
        $("#pagewrap_ajax_box").show('slow');          
        $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
        window.oncontextmenu = function(){return false;}    // Disable right click  
        $("select").prop('disabled', true);                    // Disable form input

        $.ajax({
            url :   site_url+"/generate-subject-statistics-broad",
            type :  "POST",
            data :  form_data,
            dataType: "html",
            cache :     false
        })
        .done(function(resp){   
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});  
            $("select").prop('disabled', false);                   // Enable form input       

            $("#schoolSubjectStatBroad").html(resp);
            $('#global_datatable').dataTable();
            })
        .fail(function(){
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
            $("select").prop('disabled', false);                   // Enable form input 

            alert('Error encountered while processing request. Pls try again shortly');  
        });  

    }
    else{
        alert("LGA must be selected to generate statistics")
    }
});

$("#form2_submit").on('click', function() {
    var lga_id = $("#lga_id").val();
    var session_val = $("#session_val").val();
    var term = $("#term").val();

    if(lga_id && session_val && term){
        if(lga_id == 'all'){
            var from = $('input.from__input').val();
            var to = $('input.to__input').val();
            var with_result = $('#with_result__input').val();
            var form_data = {
                from : from,
                to : to,
                with_result : with_result,
                lga_id : lga_id,
                session : session_val,
                term : term,
                _token : token
            }
        }else{
            var form_data = {
                lga_id : lga_id,
                session : session_val,
                term : term,
                _token : token
            }
        }

        $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
        $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
        $("#pagewrap_ajax_box").show('slow');          
        $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
        window.oncontextmenu = function(){return false;}    // Disable right click  
        $("select").prop('disabled', true);                    // Disable form input

        $.ajax({
            url :   site_url+"/generate-statistics-session-result",
            type :  "POST",
            data :  form_data,
            dataType: "html",
            cache :     false
        })
        .done(function(resp){   
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});  
            $("select").prop('disabled', false);                   // Enable form input       

            $("#schoolSessionResultIndicator").html(resp);
            $('#global_datatable').dataTable();
            })
        .fail(function(){
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
            $("select").prop('disabled', false);                   // Enable form input 

            alert('Error encountered while processing request. Pls try again shortly');  
        });  

    }
    else{
        alert("LGA and Session and Term must be selected")
    }
});

$("#form_submit").on('click', function() {
    var lga_id = $("#lga_id").val();
    var session_val = $("#session_val").val();
    var user_type = $("#user_type").val();

    if(lga_id && session_val && user_type){

        var form_data = {
            lga_id : lga_id,
            session : session_val,
            user_type : user_type,
            _token : token
        }
        
        var url = (user_type == 'Student') ? 'generate-statistics-tables-student': 'generate-statistics-tables-teacher';

        $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
        $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
        $("#pagewrap_ajax_box").show('slow');          
        $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
        window.oncontextmenu = function(){return false;}    // Disable right click  
        $("select").prop('disabled', true);                    // Disable form input

        $.ajax({
            url :   site_url+"/"+url,
            type :  "POST",
            data :  form_data,
            dataType: "html",
            cache :     false
        })
        .done(function(resp){   
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});  
            $("select").prop('disabled', false);                   // Enable form input       

            //alert('data ready');
            $("#statTableHolder").html(resp);
            $('#global_datatable').dataTable();
            })
        .fail(function(){
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
            $("select").prop('disabled', false);                   // Enable form input 

            alert('Error encountered while processing request. Pls try again shortly');  
        });  

    }
    else{
        alert("LGA Session, and User type must be selected to generate statistics")
    }
});

$("#form_submit_broad").on('click', function() {
    var lga_id = $("#lga_id").val();
    var session_val = $("#session_val").val();

    if(lga_id && session_val){

        var form_data = {
            lga_id : lga_id,
            session : session_val,
            _token : token
        }

        $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
        $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
        $("#pagewrap_ajax_box").show('slow');          
        $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
        window.oncontextmenu = function(){return false;}    // Disable right click  
        $("select").prop('disabled', true);                    // Disable form input

        $.ajax({
            url :   site_url+"/generate-broad-statistics-tables",
            type :  "POST",
            data :  form_data,
            dataType: "html",
            cache :     false
        })
        .done(function(resp){   
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});  
            $("select").prop('disabled', false);                   // Enable form input       

            $("#statBroadTableHolder").html(resp);
            $('#global_datatable').dataTable();
            })
        .fail(function(){
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
            $("select").prop('disabled', false);                   // Enable form input 

            alert('Error encountered while processing request. Pls try again shortly');  
        });  

    }
    else{
        alert("LGA and Session must be selected to generate statistics")
    }
});

$(document).ready(function(){
    $('.showStatsBtn').click(function(){
        var modal = $('.ui.modal.superSchoolStats');
        var name = $(this).attr('school-name');
        var id = $(this).attr('school-id');
        modal.find('.header').html(name.toUpperCase()+"'s  Statistics");
        modal.find('.image.loading').fadeIn('slow');
        modal.find('.loading').fadeIn('slow');
        $('.stats').fadeOut('slow');
        modal.modal({
        closable  : false,
        centered: false,
        onDeny : function() {
            modal.find('.approve').fadeOut('fast');
        },
        onApprove : function() {
            $(this).submit();
        }
      }).modal('show');
        //get permissions with ajax
        var token = "{{csrf_token()}}";
        var route = "{{route('super_admin.school.view.statistics')}}";
        $.ajax({
            url: route,
            type: 'POST',
            data: {school_id: id, _token: token},
            success: function(response){
                // alert(response);
                modal.find('.image.loading').fadeOut('slow');
                modal.find('.loading').fadeOut('slow');
                $.each(response, function(index, value){
                    // alert(value.teacher_count)
                    $('.stats .teacher_count').html(value.teacher_count);
                    $('.stats .student_count').html(value.student_count);
                    $('.stats .admin_count').html(value.admin_count);
                    $('.stats .male_count').html(value.male_count);
                    $('.stats .female_count').html(value.female_count);
                    $('.stats .account').html(value.account);
                    $('.stats .location').html(value.location);
                    $('.stats .created_at').html(value.created_at);
                    $('.stats .category').html(value.category);
                    $('.stats').fadeIn('slow');
                });
            },
            error: function(error){
                console.log(error);
                $('.msg-bag').html(error('Something went wrong'));
                msgClose();
                modal.find('.approve').fadeOut('fast');
            }
        });
    });
    
    $.ajax({
        url: 'http://odsgmoe.com/eportal/api/payment',
        type: 'POST',
        data: {'PAYEE_ID': '419157b7f2-4-6', 'PAYMENT_TYPE': 'CBT-Payment'},
        success: function(res){
            console.log(res);
        },
        error: function(error){
            console.log(error);
        }
    });
});

function showRangeInput(obj){
    var select,value,rangeField;
    select = $(obj);
    value = select.val();
    rangeField = $('.range_field');
    if(value == 'all'){
        rangeField.slideDown('slow');
        rangeField.find('input').each(function(){
            $(this).attr('required', 'required');
        });
    }else{
        rangeField.slideUp('slow');
        rangeField.find('input').each(function(){
            $(this).removeAttr('required');
        });
    }
}
</script>
<style>
@media print{
    /*background: url(https://odsgmoe.com/eportal/public/images/header-logo.png) !important;*/
    .print-none{
        display: none !important;
    }
    .print-show{
        display: inline !important;
    }
}
.wallpaper{
    position: relative;
    height: 250px;
    width: 100%;
    background: red;
}
.wallpaper img{
    position: absolute;
    width: 100%;
    height: 100%;
    filter: brightness(0.4);
}
.wallpaper h1{
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: #fff;
    font-size: 3em;
    text-transform: uppercase;
    text-align: center;
}
</style>
@endsection