@extends('layouts.main')
@section('content')
	<section class="ui raised segment" style="max-width: 1024px; margin: 30px auto;">
	    <h2 class="ui horizontal divider header" style="color:#dc4900;">
		  View School
		</h2>
		
		<div class="search-bar">
			<div class="ui stackable equal height stackable grid">
				<div class="seven wide column">
					<form method="get" action="{{route('super_admin.search.bar')}}" class="form form-horizontal global_form">
							<input type="hidden" name="type" value="search_school">
							{{csrf_field()}}
							<div class="ui left action input fluid">
									<button class="ui orange labeled icon button">
											<i class="search icon"></i>
											Search KEYWORD:
									</button>
									<input type="text" placeholder="Enter keyword..." name="keyword" value="">
							</div>
					</form>
				</div>
				<div class="two wide column">
					<h2 class="ui horizontal divider header" style="margin-top: 8px;color:#dc4900;text-align: center;">Or</h2>
				</div>
				<div class="seven wide column">
					<form method="get" action="{{route('super_admin.search.bar')}}" class="form form-horizontal global_form">
							<input type="hidden" name="type" value="search_school">
							{{csrf_field()}}
							<div class="second">
									<div class="fields">
											<div class="sixteen wide field">
													<div class="ui left action input fluid">
															<button class="ui orange labeled icon button">
																	<i class="search icon"></i>
																	Search with LGA:
															</button>
															<select name="lga" class="ui search fluid dropdown">
																<option value="">Choose LGA</option>
																@if($item_rows = DB::table('ondo_lgas')->get())
																		@foreach ($item_rows as $item_data)
																		<option value="{{$item_data->id}}">{{$item_data->name}}</option>
																		@endforeach
																@endif
														</select>
													</div>
											</div>
									</div>
							</div>
					</form>
				</div>
			</div>
		</div>
		<table class="ui celled table">
		  <thead>
		    <tr>
			  	<th>
			    	<div class="ui ribbon label">School name</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">School Logo</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">School Address</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">School LGA</div>
			    </th>
			    <th colspan="2">
			    	<div class="ui ribbon label">Actions on School</div>
			    </th>
			 </tr>
		  </thead>
		  <tbody>
		  <tr>
		  	<th colspan="6"><a href="{{route('super_admin.create.school')}}" class="ui orange fluid button">Create School</a></th>
		  </tr>
		  @if(count($schools) > 0)
		  	@foreach($schools as $school)
		    <tr>
		      <td>{{$school->name}}</td>
		      <td><img src="{{url_public($school->logo)}}" class="ui fluid image"></td>
		      <td>{{$school->address}}</td>
		      <td>{{$school->ondo_lga->name}}</td>
		      <td class="std-view">
			      <button class="ui labeled blue icon button" data-std-id="{{$school->id}}" data-href="{{route('super_admin.edit.school', ['id' => $school->id])}}">
				  <i class="edit icon"></i>
				  Edit
				</button>
			  </td>
		      <td class="std-view">
				<button class="ui labeled negative icon button" data-std-id="{{$school->id}}" data-href="{{route('super_admin.delete.school', ['id' => $school->id])}}">
				  <i class="trash icon"></i>
				  Delete
				</button>
		      </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="6">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr><th colspan="6">
		      @include('pagination.default', ['paginator' => $schools])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
	<div class="jtr"></div>
@endsection