@extends('layouts.main')
@section('content')
	<section class="ui raised segment" style="max-width:500px; margin: 40px auto;">
  @include('partial.error')
		<form class="ui form" action="" method="post" enctype="multipart/form-data">
			<h2 class="ui dividing header">Create School</h2>
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		      <div class="field">
            <label>State</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" @if(!empty(old('state_id')))
                  value="{{old('state_id')}}"
                @else
                  value="{{$ngstate->id}}"
                @endif data-href="{{url('/do-ajax/state')}}">
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
              </div>
            </div>
          </div>

          <div class="field" id="field-lga">
            <label>Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="{{old('lga_id')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Local Govt. Area</div>
              <div class="menu" id="state-lga">
                @foreach($ngstate_lgas as $ngstateLGA)
                 <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                @endforeach
              </div>
            </div>
          </div>

          <div class="field">
            <label>Name of School</label>
            <input type="text" name="school" value="{{old('school')}}" placeholder="Name of School">
          </div>

          <div class="field">
            <label>School Category</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="school_category" value="{{old('school_category')}}">
              <i class="dropdown icon"></i>
              <div class="default text">School Category</div>
              <div class="menu">
                 <div class="item" data-value="unity">Unity School</div>
                 <div class="item" data-value="non_unity">Non Unity School</div>
              </div>
            </div>
          </div>

          <div class="field">
              <div class="image-handler" style="max-width:280px;">
                <img src="https://via.placeholder.com/300x250" class="ui fluid image">
              </div>
              <label>School Logo</label>
              <div class="ui right action input">
                <input type="text" class="pseudo-batch-file-name" name="pseudo_batch_file_name" >
                <button type="button" class="ui orange labeled icon button pseudo-batch-file">
                  Choose Logo
                </button>
              </div>
              <input type="file" name="passport" id="batch_file" class="batch-file fileUpload" style="display: none">
          </div>

          <div class="field">
              <label>School Address</label>
              <textarea name="address" rows="3" placeholder="School Address">{!!old('address')!!}</textarea>
          </div>

          <button class="ui fluid large orange submit button" type="submit">Create School</button>
		</form>
	</section>
	<div class="jtr"></div>
@endsection