@extends('layouts.main')
@section('content')
	<section class="ui raised segment" style="max-width:500px; margin: 40px auto;">
  @include('partial.error')
		<form class="ui form" action="" method="post" enctype="multipart/form-data">
			<h2 class="ui dividing header">Batch Create Primary School</h2>
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		      <div class="field">
            <label>State</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" @if(!empty(old('state_id')))
                  value="{{old('state_id')}}"
                @else
                  value="{{$ngstate->id}}"
                @endif data-href="{{url('/do-ajax/state')}}">
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
              </div>
            </div>
          </div>

          <div class="field" id="field-lga">
            <label>Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="{{old('lga_id')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Local Govt. Area</div>
              <div class="menu" id="state-lga">
                @forelse($ngstate->ondo_lga as $ngstateLGA)
                 <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                @empty
                @endforelse
              </div>
            </div>
          </div>

        <div class="field">
            <label>File Upload</label>
            <div class="ui right action input">
              <input type="text" class="pseudo-batch-file-name" name="pseudo_batch_file_name" >
              <button type="button" class="ui orange labeled icon button pseudo-batch-file">
                <i class="file excel outline icon"></i>
                Upload Excel File
              </button>
            </div>
            <input type="file" name="batch_file" id="batch-file" class="batch-file" style="display: none">
        </div>

          <button class="ui fluid large orange submit button" type="submit">Batch Create Primary School</button>
		</form>
	</section>
	<div class="jtr"></div>
@endsection