@extends('layouts.main')
@section('content')
	<section class="ui raised segment" style="max-width:500px; margin: 40px auto;">
  @include('partial.error')
		<form class="ui form" action="" method="post">
			<h2 class="ui dividing header">Edit School Admin</h2>
			<input type="hidden" name="_token" value="{{csrf_token()}}">
    		  <div class="field states">
            <label>State</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" @if(!empty(old('state_id')))
                  value="{{old('state_id')}}"
                @else
                  value="{{$ngstate->id}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
              </div>
            </div>
          </div>

          <div class="field" id="field-lga">
            <label>Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id"  @if(!empty(old('lga_id')))
                  value="{{old('lga_id')}}"
                @else
                  value="{{$admin_school->lga_id}}"
                @endif data-href="{{url('/do-ajax/school')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Local Govt. Area</div>
              <div class="menu" id="state-lga">
                @foreach($ngstate_lgas as $ngstateLGA)
                 <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                @endforeach
              </div>
            </div>
          </div>

          <div class="field" id="field-school">
            <label>School</label>
            <div class="ui fluid search selection dropdown" id="wrap-schools">
              <input type="hidden" name="school" @if(!empty(old('school')))
                  value="{{old('school')}}"
                @else
                  value="{{$admin_school->id}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Schools</div>
              <div class="menu" id="school-options-handler">
                @if(getSchoolByLGA($admin_school->state_id, $admin_school->lga_id)->count() > 0)
                    @foreach(getSchoolByLGA($admin_school->state_id, $admin_school->lga_id) as $school)
                     <div class="item" data-value="{{$school->id}}">{{$school->name}}</div>
                    @endforeach
                @else
                   <div class="item" data-value="">Schools</div>
                @endif
              </div>
            </div>
          </div>

          <div class="field">
            <label>Fullname</label>
            <input type="text" name="fullname" @if(!empty(old('fullname')))
                  value="{{old('fullname')}}"
                @else
                  value="{{$school_admin->fullname}}"
                @endif placeholder="Fullname">
          </div>

          <div class="field">
            <label>Email</label>
            <input type="text" name="email" @if(!empty(old('email')))
                  value="{{old('email')}}"
                @else
                  value="{{$school_admin->email}}"
                @endif  placeholder="Email">
          </div>

          <div class="field">
            <label>Username</label>
            <input type="text" name="username" @if(!empty(old('username')))
                  value="{{old('username')}}"
                @else
                  value="{{$school_admin->username}}"
                @endif  placeholder="Username">
          </div>

          <div class="field">
            <label>Phone</label>
            <input type="text" name="phone" @if(!empty(old('phone')))
                  value="{{old('phone')}}"
                @else
                  value="{{$school_admin->phone}}"
                @endif placeholder="Phone Formart: 2348022222222">
          </div>

          <button class="ui fluid large orange submit button" type="submit">Update School Admin</button>
		</form>
	</section>
	<div class="jtr"></div>
@endsection