@extends('layouts.main')
@section('content')
	<section class="ui raised segment" style="max-width:500px; margin: 40px auto;">
  @include('partial.error')
		<form class="ui form" action="" method="post">
			<h2 class="ui dividing header">Create School Admin</h2>
			<input type="hidden" name="_token" value="{{csrf_token()}}">
    		  <div class="field states">
            <label>State</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" @if(!empty(old('state_id')))
                  value="{{old('state_id')}}"
                @else
                  value="{{$ngstate->id}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
              </div>
            </div>
          </div>

          <div class="field" id="field-lga">
            <label>Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="{{old('lga_id')}}" data-href="{{url('/do-ajax/school')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Local Govt. Area</div>
              <div class="menu" id="state-lga">
                @foreach($ngstate_lgas as $ngstateLGA)
                 <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                @endforeach
              </div>
            </div>
          </div>

          <div class="field" id="field-school">
            <label>School</label>
            <div class="ui fluid search selection dropdown" id="wrap-schools">
              <input type="hidden" name="school" value="{{old('school')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Schools</div>
              <div class="menu" id="school-options-handler">
                @if(!empty(old('school')))
                    @foreach(getSchools(old('school')) as $school)
                     <div class="item" data-value="{{$school->id}}">{{$school->name}}</div>
                    @endforeach
                  @else
                     <div class="item" data-value="">Schools</div>
                  @endif
              </div>
            </div>
          </div>

          <div class="field">
            <label>Fullname</label>
            <input type="text" name="fullname" value="{{old('fullname')}}" placeholder="Fullname">
          </div>

          <div class="field">
            <label>Email</label>
            <input type="text" name="email" value="{{old('email')}}" placeholder="Email">
          </div>

          <div class="field">
            <label>Username</label>
            <input type="text" name="username" value="{{old('username')}}" placeholder="Username">
          </div>

          <div class="field">
            <label>Phone</label>
            <input type="number" name="phone" value="{{old('phone')}}" placeholder="Phone Formart: 2348022222222">
          </div>
          
          <div class="field">
            <label>Password</label>
            <input type="password" name="password" value="" placeholder="Password">
          </div>


          <div class="field">
            <label>Confirm Password</label>
            <input type="password" name="password_confirmation" value="" placeholder="Confirm Password">
          </div>

          <button class="ui fluid large orange submit button" type="submit">Create School Admin</button>
		</form>
	</section>
	<div class="jtr"></div>
@endsection