@extends('layouts.main')
@section('content')
	<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 800px" id="result-view">

  @include('partial.error')
<div class="sixteen wide column">
	<form action="{{route('admin.update.student.result')}}" method="post" class="ui form">
	<input type="hidden" name="_token" value="{{csrf_token()}}">
	<input type="hidden" name="_method" value="put">
	<input type="hidden" name="session" value="{{$session}}">
	<input type="hidden" name="class_id" value="{{$class_id}}">
	<input type="hidden" name="classarm_id" value="{{$classarm_id}}">
	<input type="hidden" name="term" value="{{$term}}">
	<input type="hidden" name="student_id" value="{{$id}}">
    <table class="ui unstackable celled table">
      <thead>
      	<tr>
      		<th colspan="4">{{getStudentFullnameByStudentID($id).'\'s Result'}}</th>
      	</tr>
        <tr>
          <th>Subject</th>
          <th>CA</th>
          <th>EXAM</th>
        </tr>
      </thead>
      <tbody>

       @foreach($student_results as $student_result)
        <tr>
          <td>
          	{{getSubjectNameBySubjectID($student_result->subject_id)}}
          	<input type="hidden" name="subject_id[]" value="{{$student_result->subject_id}}">
          </td>
          <td>
          	<input type="text" name="ca[{{$student_result->subject_id}}]" value="{{$student_result->ca_score}}">
          </td>
          <td>
          	<input type="text" name="exam[{{$student_result->subject_id}}]" value="{{$student_result->exam_score}}">
          </td>
        </tr>
        @endforeach

      </tbody>
      <tfoot>
      	<tr>
      		<td colspan="3"><button type="submit" class="ui button fluid" style="background-color: #f75a0c; color:white;">Update Student Result</button></td>
      	</tr>
      </tfoot>
    </table>
    </form>
</div>
</section>
<div class="jtr"></div>
@endsection