@extends('layouts.main')
@section('content')
<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 1024px" id="result-view">
<div class="sixteen wide column">
    <table class="ui unstackable celled table">
      <thead>
        <tr>
          <th>Students' Name and Results</th>
        </tr>
      </thead>
      <tbody>

       @foreach($students_results_info as $key => $student_results)
        <tr>
          <td>
            <table class="ui unstackable celled table">
              <thead>
                <tr>
                    <th colspan="{{ceil(count($student_results['data']) / 2)}}">{{getStudentFullnameByStudentID($key)}}</th>
                    <th colspan="{{floor(count($student_results['data']) / 2)}}">{{getRegNumByStudentID($key)}}</th>
                    <th colspan="2">ACTIONS</th>
                </tr>
              </thead>
              <tbody> 
                <tr>
              @if(count($student_results['data']) > 0)           
                  @foreach($student_results['data'] as  $student_result)
                    <td>
                       <table class="inner-table">
                         <tr><td>{{getSubjectCodeBySubjectID($student_result->subject_id)}}</td></tr>
                         <tr><td>{{$student_result->weighted_average}}</td></tr>
                         <tr><td>{{$student_result->grade}}</td></tr>
                       </table>
                    </td>
                  @endforeach
                    <td class="std-view"> 
                    @if(auth('admin')->user()->can('edit-student-result'))
                      <button class="ui labeled blue icon button" data-std-id="{{$key}}" data-href="{{route('admin.edit.student.result', ['id' => $key, 'session' => $session, 'term' => $term, 'class_id' => $class_id, 'classarm_id' => $classarm_id_get])}}" data-item="{{getStudentFullnameByStudentID($key).'\'s Result'}}">
                          <i class="edit icon"></i> Edit
                      </button>
                      @endif
                    </td>
                    <td class="std-view">
                    @if(auth('admin')->user()->can('delete-student-result'))
                      <button class="ui labeled negative icon button" data-std-id="{{$key}}" data-href="{{route('admin.delete.student.result', ['id' => $key])}}" data-item="{{getStudentFullnameByStudentID($key).'\'s Result'}}">
                          <i class="trash icon"></i> Delete
                      </button>
                      @endif
                    </td>

                @else
                    <td colspan="3">
                      <div class="ui icon negative message">
                            <div class="content">
                              <p class="header">Result has not been uploaded</p>
                            </div>
                      </div>
                    </td>
                @endif
                </tr>
              </tbody>
            </table>
          </td>
        </tr>
        @endforeach

      </tbody>
    </table>
</div>
</section>
<div class="jtr"></div>
<div class="ui modal" id="edit">
    <div class="header">Header</div>
    <div class="image content">
      <div class="description">

      </div>
    </div>
    <div class="actions">
      <div class="ui cancel button">Cancel</div>
      <a href="" class="ui approve blue button">Edit</a>
    </div>
  </div>

  <div class="ui modal" id="delete">
    <div class="header">Header</div>
    <div class="image content">
      <div class="description">

      </div>
    </div>
    <div class="actions">
      <div class="ui cancel button">Cancel</div>
      <form action="" method="post" style="display:inline-block;">
        <input type="hidden" name="_token" value="{{csrf_token()}}">
        <input type="hidden" name="_method" value="delete">
        <input type="hidden" name="session" value="{{$session}}">
        <input type="hidden" name="class_id" value="{{$class_id}}">
        <input type="hidden" name="classarm_id" value="{{$classarm_id_get}}">
        <input type="hidden" name="term" value="{{$term}}">
        <button type="submit" class="ui approve negative button">Delete</button>
      </form>
    </div>
  </div>
@endsection