@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		@include('partial.error')
	<form class="ui form" action="{{route('super_admin.view.teacher.post')}}" method="post" enctype="multipart/form-data">
		<input type="hidden" name="_token" value="{{csrf_token()}}">
		<h2 class="ui dividing header">Search Registered Teachers</h2>
		<div class="four fields">
		  <div class="field states">
            <label>State</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" @if(!empty(old('state_id')))
                  value="{{old('state_id')}}"
                @else
                  value="{{$ngstate->id}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
              </div>
            </div>
          </div>
          <div class="field" id="field-lga">
            <label>Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="{{old('lga_id')}}" data-href="{{url('/do-ajax/school')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Local Govt. Area</div>
              <div class="menu" id="state-lga">
                @foreach($ngstate_lgas as $ngstateLGA)
                 <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                @endforeach
              </div>
            </div>
          </div>

          <div class="field" id="field-school">
            <label>School</label>
            <div class="ui fluid search selection dropdown" id="wrap-schools">
              <input type="hidden" name="school" value="{{old('school')}}" data-href="{{url('/do-ajax/classes')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Schools</div>
              <div class="menu" id="school-options-handler">
                @if(!empty(old('school')))
                    @foreach(getSchools(old('school')) as $school)
                     <div class="item" data-value="{{$school->id}}">{{$school->name}}</div>
                    @endforeach
                  @else
                     <div class="item" data-value="">Schools</div>
                  @endif
              </div>
            </div>
          </div>
          <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Teachers</button>
	      </div>
		</div>
		  
	</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  View Teachers Information
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Identification Number</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Passport</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Subject Areas</div>
		    </th>
		     <th>
		    	<div class="ui ribbon label">Teacher's School</div>
		    </th>
		    <th colspan="2">
		    	<div class="ui ribbon label">Actions on Teachers</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if(count($teachers) > 0)
		  @php $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $teachers->perPage() @endphp
		  	@foreach($teachers as $teacher)
		    <tr>
		    <td>{{++$counter}}</td>
		      <td>{{$teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename}}</td>
		      <td>{{$teacher->staff_no}}</td>
		      <td><img src="{{env('APP_URL').$teacher->passport}}" class="ui image"></td>
		      <td>
		      	<div class="ui middle aligned divided list">
		      	@forelse(getAssocSubject($teacher->id) as $t_s)
		      	<div class="item">
				    <div class="content">
				      <p class="header">{{$t_s->subject_name}}</p>
				    </div>
				</div>
				@empty
				<div class="item">
				    <div class="content">
				      <p class="header">No Subject Area Yet</p>
				    </div>
				</div>
		      	@endforelse
		      	</div>
		      </td>
		      <td>{{getSchoolName($teacher->school_id)}}</td>
		      <td class="std-view">
		      @if(auth('super_admin')->user()->can('edit-teacher'))
			      <button class="ui labeled blue icon button editPermission" user-name="{{$teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename}}" user-id="{{$teacher->id}}">
				  <i class="edit icon" ></i>
				  Edit Permissions
				</button>
			@endif
			  </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="8">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr><th colspan="8">
		      @include('pagination.post-default', ['paginator' => $teachers, 'post_data' => $data])
		    </th>
		  </tr></tfoot>
		</table>
	</section>

	<!-- modals -->
	<form class="ui long modal">
	  <i class="close icon"></i>
	  <div class="header">
	  </div>
	  <div class="image content" style="height: 70vh;">
	    <div class="image">
	      Available Permissions
	    </div>
	    <div class="description ui grid">
	    	<p style="text-align: center;padding-top: 1em;color: red;">
	    		<small>Not available now please check back..</small>
	    	</p>
	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	    <div style="display: none;" class="ui approve blue button">Update</div>
	  </div>
	</form>

	
	@include('super-admin.permissions.select')
<script type="text/javascript">
	$(document).ready(function(){
        $('.editPermission').click(function(){
        	var modal = $('.ui.modal');
        	var name = $(this).attr('user-name');
        	var id = $(this).attr('user-id');
        	modal.find('.header').html("Edit "+name.toLowerCase()+"'s permissions");
        	// modal.find('.description').html('<div class="five wide column field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 10px;"></div>');
	       // append class arm
	       var route = "{{route('super_admin.get.classarm')}}";
	       var token = "{{csrf_token()}}";
			$.ajax({
				url: route,
				type: 'POST',
				data: {id:id, _token: token},
				success: function(response){
					if(response == 'permissions updated'){
						$('.msg-bag').html(success(response));
						msgClose();
					}else{
						$('.msg-bag').html(error(response));
						msgClose();
					}
					modal.find('.approve').fadeOut('fast');
				},
				error: function(error){
	        		console.log(error);
	        		$('.msg-bag').html(error('Something went wrong'));
	        		msgClose();
					modal.find('.approve').fadeOut('fast');
				}
			});

	        modal.modal({
		    closable  : false,
		    centered: false,
		    onDeny : function() {
				modal.find('.approve').fadeOut('fast');
		    },
		    onApprove : function() {
		    	$(this).submit();
		    }
		  }).modal('show');
	    });
	});
</script>
<script>
	function getPermissions(value, modal){
		$permission = '<div class="three wide column left floated compact segment" style="padding: 30px">';
		  $permission += '<div class="ui fitted toggle checkbox">';
		    $permission += '<input '+value.status+' name="permission['+value.id+']" value="'+value.id+'" type="checkbox">';
		    $permission += '<label></label>';
		    $permission += value.permission;
		  $permission += '</div>';
		$permission += '</div>';

		modal.find('.description').append($permission);
	}

	function error(response){
		$error = '<div class="ui error message transition">';
		  $error += '<div class="header">'+response+'</div>';
		  $error += '<i class="close icon"></i>';
		$error += '</div>';
		return $error;
	}

	function success(response){
		$success = '<div class="ui success message transition">';
		  $success += '<div class="header">'+response+'</div>';
		  $success += '<i class="close icon"></i>';
		$success += '</div>';
		return $success;
	}

	function msgClose(){
		$('.message .close').on('click', function() {
		    $(this).closest('.message').fadeOut('slow');
		});
	}
</script>
@endsection