@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 1024px; margin: 30px auto;">
	<div class="msg-bag"></div>
	<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  View School Admin
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    	<th>
		    		<div class="ui ribbon label">S/N</div>
		    	</th>
			  	<th>
			    	<div class="ui ribbon label">School Admin</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">School Name</div>
			    </th>
			     <th>
			    	<div class="ui ribbon label">School Username</div>
			    </th>
			    <th colspan="2" width="14%">
			    	<div class="ui ribbon label">Actions on School Admin</div>
			    </th>
			 </tr>
		  </thead>
		  <tbody>
		  <tr>
		  	<th colspan="6"><a href="{{route('super_admin.create.school.admin')}}" class="ui orange fluid button">Create School Admin</a></th>
		  </tr>
		  @if($school_admins->count() > 0)
		  @php $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $school_admins->perPage() @endphp
		  	@foreach($school_admins as $school_admin)
		    <tr>
		      <td>{{++$counter}}</td>
		      <td>{{$school_admin->fullname}}</td>
		      <td>
		      @if(getSchools($school_admin->school_id)->count() > 0)
		      	<div class="item"><p>{{getSchoolName($school_admin->school_id)}}</p></div>
		      @else
		      	<div class="ui negative message">
		      		<p>Sorry, School has not been created</p>
		      	</div>
		      @endif
		      </td>
		      <td>{{$school_admin->username}}</td>
		      <td class="std-view">
			      <!--<button class="ui labeled blue icon button editPermission" user-name="{{$school_admin->fullname}}" user-id="{{$school_admin->id}}">
				  <i class="edit icon" ></i>
				  Edit Permissions
				</button>-->
				<a href="{{route('super_admin.user.permission.view', ['usertype' => 'school-admin', 'id' => $school_admin->id])}}">Edit Permissions</a>
		      </td>
			    </tr>
			   @endforeach
		    @else
			<tr>
				<th colspan="6">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr><th colspan="6">
		      @include('pagination.default', ['paginator' => $school_admins])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<!-- modals -->
	<form class="ui long modal">
	  <!-- <i class="close icon"></i> -->
	  <div class="header">
	  </div>
	  <div class="image content" style="height: 70vh;">
	    <div class="image">
	      Available Permissions
	    </div>
	    <div class="description ui grid">
	      <div class="five wide column field loading" style="margin-left: 10px;margin-top: 10px;"></div>
	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	    <div style="display: none;" class="ui approve blue button">Update</div>
	  </div>
	</form>

	<div class="jtr"></div>


	@include('super-admin.permissions.select')

@endsection