@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 1024px; margin: 30px auto;">
	<div class="msg-bag"></div>
	<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  View Ministry Admin
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    	<th>
		    		<div class="ui ribbon label">S/N</div>
		    	</th>
			  	<th>
			    	<div class="ui ribbon label">Ministry Admin</div>
			    </th>
			     <th>
			    	<div class="ui ribbon label">Ministry Username</div>
			    </th>
			    <th colspan="2">
			    	<div class="ui ribbon label">Actions on Ministry Admin</div>
			    </th>
			 </tr>
		  </thead>
		  <tbody>
		  <!-- tr for creating ministry here -->
		  @if($ministry_admins->count() > 0)
		  @php $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $ministry_admins->perPage() @endphp
		  	@foreach($ministry_admins as $ministry_admin)
		    <tr>
		      <td>{{++$counter}}</td>
		      <td>{{$ministry_admin->fullname}}</td>
		      <td>{{$ministry_admin->username}}</td>
		      <td class="std-view">
			      <!--<button class="ui labeled blue icon button editPermission" user-name="{{$ministry_admin->fullname}}" user-id="{{$ministry_admin->id}}">
				  <i class="edit icon" ></i>
				  Edit Permissions
				</button>-->
				<a href="{{route('super_admin.user.permission.view', ['usertype' => 'ministry-admin', 'id' => $ministry_admin->id])}}">Edit Permissions</a>
		      </td>
			    </tr>
			   @endforeach
		    @else
			<tr>
				<th colspan="6">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr><th colspan="6">
		      @include('pagination.default', ['paginator' => $ministry_admins])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<!-- modals -->
	<form class="ui long modal">
	  <!-- <i class="close icon"></i> -->
	  <div class="header">
	  </div>
	  <div class="image content" style="height: 70vh;">
	    <div class="image">
	      Available Permissions
	    </div>
	    <div class="description ui grid">
	      <div class="five wide column field loading" style="margin-left: 10px;margin-top: 10px;"></div>
	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	    <div style="display: none;" class="ui approve blue button">Update</div>
	  </div>
	</form>

	<div class="jtr"></div>


	@include('super-admin.permissions.select')
@endsection