@extends('layouts.main-datatable')
@section('content')   


<style>
.pay_ok {
  color:#FFF;
  background-color: #060;
  padding: 3px 8px;
  text-align: center;
}
</style> 

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="" method="post">
  <h2 class="ui dividing header">{{$title}}</h2>

		<table class="ui celled table" id="global_datatable">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">School</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">LGA</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Category</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Verified Pay</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Unverified Pay</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if($schools->count() > 0)
		  	@foreach($schools as $school)
		    <tr>
		      <td>{{strtoupper($school->school_name)}}</td>
		      <td>{{$school->lga_name}}</td>
		      <td>{{strtoupper($school->school_category)}}</td>
		      <td>
		      		<a href="{{route('super_admin.payment.all.transaction.verified', ['id' => $school->id])}}">View All</a>	     	
		      </td>
		      <td>
		      		<a href="{{route('super_admin.payment.all.transaction.unverified', ['id' => $school->id])}}">View All</a>		      	
		      </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="4">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record was found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr><th colspan="5">
		      <!--@include('pagination.default', ['paginator' => $schools])-->
		    </th>
		  </tr></tfoot>
		</table>



  
</form>
   
</section>

<div class="jtr"></div>
@endsection	