@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">
    <h2 class="ui dividing header text_center"> <?php echo $title; ?> </h2>
    <div class="ui grid">
        <div class="four wide column">
            <div class="ui vertical fluid tabular menu">
            <a href="{{url('ministry/payment-statistics')}}" class="item @if(!isset($_GET['action']) || $_GET['action'] == '') active @endif">
                View live
            </a>
            <a href="{{url('ministry/payment-statistics?action=view_all')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'view_all') active @endif">
                View all
            </a>
            <a class="item @if(isset($_GET['action']) && $_GET['action'] == 'view_lga') active @endif">
                <form class="ui left action input">
                    <input type="hidden" name="action" value="view_lga">
                    <button class="ui button">LGA:</button>
                    <select name="value" class="ui fluid search dropdown">
                        <option value="">Choose LGA</option>
                        @if($item_rows = DB::table('ondo_lgas')->where('state_id', 28)->get())
                            @foreach ($item_rows as $item_data)
                            <option <?php if(isset($_GET['value']) && $_GET['value'] == $item_data->id){ echo 'selected'; } ?> value="{{$item_data->id}}">{{$item_data->name}}</option>
                            @endforeach
                        @endif
                    </select>
                </form>
            </a>
            <a href="{{url('ministry/payment-statistics?action=search')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'search') active @endif">
                Search Payment Invoice
            </a>
            </div>
        </div>
        <div class="twelve wide stretched column">
            <div class="ui segment">
                @if(isset($_GET['action']) && $_GET['action'] == 'view_all')
                <div class="c8">
                    <img class="ui fuild image" src="{{url_public('/images/ill-stats.png')}}" style="width:100%" height="250">
                    <table class="ui celled table">
                    <thead>
                        <tr>
                            <th>
                                <div class="ui ribbon label">School name</div>
                            </th>
                            <th>
                                <div class="ui ribbon label">School Logo</div>
                            </th>
                            <th>
                                <div class="ui ribbon label">School LGA</div>
                            </th>
                            <th colspan="2">
                                <div class="ui ribbon label">Actions on School</div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    @if(count($schools) > 0)
                        @foreach($schools as $school)
                        <tr>
                        <td>{{$school->name}}</td>
                        <td><img src="{{url_public($school->logo)}}" class="ui fluid image"></td>
                        <td>{{$school->ondo_lga->name}}</td>
                        <td class="std-view" width="250">
                            <button style="background: #3caeb7;color: #fff;"  class="ui labeled icon button showStatsBtn" school-name="{{$school->name}}" school-id="{{$school->id}}">
                            <i class="edit icon"></i>
                            View Payment Statistics
                            </button>
                        </td>
                        </tr>
                    @endforeach
                        @else
                        <tr>
                            <th colspan="6">
                                <div class="ui icon negative message">
                                <i class="info circle icon"></i>
                                <div class="content">
                                    <div class="header">
                                    Sorry, No Record can be found.
                                    </div>
                                </div>
                                </div>
                            </th>
                        </tr>
                    @endif
                    </tbody>
                    <tfoot>
                        <tr><th colspan="6">
                        @include('pagination.default', ['paginator' => $schools])
                        </th>
                    </tr></tfoot>
                    </table>
                </div>
                @elseif(isset($_GET['action']) && $_GET['action'] == 'view_lga')
                <div class="c8">
                    <div class="wallpaper">
                        <img class="" src="{{url_public('/images/ill-stats.png')}}">
                        <h1>{{$lga_name}}</h1>
                    </div>
                    <div class="main">
                        <table class="ui celled table">
                            <thead>
                                <tr>
                                    <th>
                                        <div class="ui ribbon label">School name</div>
                                    </th>
                                    <th>
                                        <div class="ui ribbon label">School Logo</div>
                                    </th>
                                    <th>
                                        <div class="ui ribbon label">School LGA</div>
                                    </th>
                                    <th colspan="2">
                                        <div class="ui ribbon label">Actions on School</div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                            @if(count($schools) > 0)
                                @foreach($schools as $school)
                                <tr>
                                <td>{{$school->name}}</td>
                                <td><img src="{{url_public($school->logo)}}" class="ui fluid image"></td>
                                <td>{{$school->ondo_lga->name}}</td>
                                <td class="std-view" width="250">
                                    <button style="background: #3caeb7;color: #fff;"  class="ui labeled icon button showStatsBtn" school-name="{{$school->name}}" school-id="{{$school->id}}">
                                    <i class="edit icon"></i>
                                    View Payment Statistics
                                    </button>
                                </td>
                                </tr>
                            @endforeach
                                @else
                                <tr>
                                    <th colspan="6">
                                        <div class="ui icon negative message">
                                        <i class="info circle icon"></i>
                                        <div class="content">
                                            <div class="header">
                                            Sorry, No Record can be found.
                                            </div>
                                        </div>
                                        </div>
                                    </th>
                                </tr>
                            @endif
                            </tbody>
                            <tfoot>
                                <tr><th colspan="6">
                                @include('pagination.default', ['paginator' => $schools])
                                </th>
                            </tr></tfoot>
                        </table>
                    </div>
                </div>
                @elseif(isset($_GET['action']) && $_GET['action'] == 'search')
                <form method="post" action="{{route('admin.payment.offline.search.invoice')}}" class="ui form form-horizontal global_form">
                    <input type="hidden" name="school_id" value="ministry">
                    {{csrf_field()}}
                    <div class="ui left action input">
                        <button class="ui teal labeled icon button">
                            <i class="search icon"></i>
                            Search Invoice with ID:
                        </button>
                        <input type="text" name="invoice_id" value="">
                    </div>
                </form>
                    <br>
                    <h2 class="ui horizontal divider header" style="color:#dc4900;">Or</h2>
                    <br>
                <form method="post" action="{{route('admin.payment.offline.search.invoice')}}" class="ui form form-horizontal global_form">
                    <input type="hidden" name="school_id" value="ministry">
                    {{csrf_field()}}
                    <div class="second">
                        <div class="fields">
                            <div class="eleven wide field">
                                <div class="ui left action input">
                                    <button class="ui teal labeled icon button">
                                        <i class="search icon"></i>
                                        Search Invoice with Student Registration Number:
                                    </button>
                                    <input type="number" value="" name="regnum" placeholde="Enter Registration Number...">
                                </div>
                            </div>
                            
                            <div class="five wide field">
                                <select name="item_id" class="ui fluid search dropdown">
                                    <option value="">Choose Payment Item</option>
                                    @if($item_rows = DB::table('payment_items')->get())
                                        @foreach ($item_rows as $item_data)
                                        <option value="{{$item_data->id}}">{{$item_data->item_name}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                    </div>
                </form>
                @else
                <div class="c8">
                    <img class="ui fuild image" src="{{url_public('/images/ill-stats.png')}}" style="width:100%" height="250">
                    <table class="ui celled table">
                    <thead>
                        <tr>
                            <th>
                                <div class="ui ribbon label">School name</div>
                            </th>
                            <th>
                                <div class="ui ribbon label">School Logo</div>
                            </th>
                            <th>
                                <div class="ui ribbon label">School LGA</div>
                            </th>
                            <th colspan="2">
                                <div class="ui ribbon label">Actions on School</div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    @if(count($schools) > 0)
                        @foreach($schools as $school)
                        <tr>
                        <td>{{$school->name}}</td>
                        <td><img src="{{url_public($school->logo)}}" class="ui fluid image"></td>
                        <td>{{$school->ondo_lga->name}}</td>
                        <td class="std-view" width="250">
                            <button style="background: #3caeb7;color: #fff;"  class="ui labeled icon button showStatsBtn" school-name="{{$school->name}}" school-id="{{$school->id}}">
                            <i class="edit icon"></i>
                            View Payment Statistics
                            </button>
                        </td>
                        </tr>
                    @endforeach
                        @else
                        <tr>
                            <th colspan="6">
                                <div class="ui icon negative message">
                                <i class="info circle icon"></i>
                                <div class="content">
                                    <div class="header">
                                    Sorry, No Record can be found.
                                    </div>
                                </div>
                                </div>
                            </th>
                        </tr>
                    @endif
                    </tbody>
                    <tfoot>
                        <tr><th colspan="6">
                        @include('pagination.default', ['paginator' => $schools])
                        </th>
                    </tr></tfoot>
                    </table>
                </div>
                @endif
            </div>
        </div>
    </div>
</section>
	
    
<!-- modals -->
<form class="ui large modal">
    <!-- <i class="close icon"></i> -->
    <div class="header">
    </div>
    <div class="image content" style="height: 70vh;">
    <div class="image loading">
        loading statistics
    </div>
    <div class="description ui grid">
        <div class="five wide column field loading" style="margin-left: 10px;margin-top: 10px;"></div>
        <div class="stats hard-center" style="display: none;">
            <div class="ui statistics">
                <div class="statistic">
                    <div class="value payment_count">
                    0
                    </div>
                    <div class="label">
                    Payments
                    </div>
                </div>
                <div class="statistic">
                    <div class="value payment_made_count">
                    0
                    </div>
                    <div class="label">
                    Payments Made
                    </div>
                </div>
                <div class="statistic">
                    <div class="value payment_pending_count">
                    0
                    </div>
                    <div class="label">
                    Payments Pending
                    </div>
                </div>
            </div>
            <br><br>
            <!-- list    -->
            <div class="multiple_select_holder" style="height: 50vh;overflow-y: auto;">
                <table class="ui compact celled definition table">
                    <thead>
                        <tr>
                        <th>Cutomer ID</th>
                        <th>Item</th>
                        <th>Student Reg</th>
                        <th>Student Name</th>
                        <th>Student Class</th>
                        <th>Arm</th>
                        <th>Session</th>
                        <th>Status</th>
                        <th>Order Date</th>
                        <th>Total</th>
                        </tr>
                    </thead>
                    <tbody class="paymentsTable">
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    </div>
    <div class="actions">
    <div class="ui cancel button">Cancel</div>
    </div>
</form>
<div class="jtr"></div>
<script type="text/javascript">
	$(document).ready(function(){
        $('.showStatsBtn').click(function(){
        	var modal = $('.ui.modal');
        	var name = $(this).attr('school-name');
        	var id = $(this).attr('school-id');
        	modal.find('.header').html(name.toUpperCase()+"'s  Payments");
            modal.find('.image.loading').fadeIn('slow');
        	modal.find('.loading').fadeIn('slow');
            $('.stats').fadeOut('slow');
	        modal.modal({
		    closable  : false,
		    centered: false,
		    onDeny : function() {
				modal.find('.approve').fadeOut('fast');
		    },
		    onApprove : function() {
		    	$(this).submit();
		    }
		  }).modal('show');
	        //get permissions with ajax
            table = $('.paymentsTable');
	        var token = "{{csrf_token()}}";
	        var route = "{{route('super_admin.payment.view.statistics')}}";
	        var school_id = id;
            $.ajax({
                url: route,
                type: 'POST',
                data: {school_id: school_id, _token: token},
                success: function(response){
                    table.html('');
                    modal.find('.image.loading').fadeOut('slow');
                    modal.find('.loading').fadeOut('slow');
                    $.each(response,  function(index, value){
                        $('.stats .payment_count').html(value.payment_count);
                        $('.stats .payment_made_count').html(value.payment_made_count);
                        $('.stats .payment_pending_count').html(value.payment_pending_count);
                        $('.stats').fadeIn('slow');

                        // table append
                        $item = '<tr>';
                        $item += '<td class="collapsing">'+value.customer_id+'</td>';
                        $item += '<td>'+value.item+'</td>';
                        $item += '<td>'+value.student_reg+'</td>';
                        $item += '<td>'+value.student_name+'</td>';
                        $item += '<td>'+value.student_class+'</td>';
                        $item += '<td>'+value.student_classarm+'</td>';
                        $item += '<td>'+value.session+'</td>';
                        $item += '<td>'+value.status+'</td>';
                        $item += '<td class="collapsing">'+value.order_date+'</td>';
                        $item += '<td>₦'+value.total+'</td>';
                        $item += '</tr>';

                        if(value.empty != true && value.customer_id != undefined){
                            table.append($item);
                        }
                    });
                    $('.multiple_select_holder .field.loading').remove();
                },
                error: function(error){
                    console.error(error);
                }
            });
	    });
	});
</script>
<style>
.wallpaper{
    position: relative;
    height: 250px;
    width: 100%;
    background: red;
}
.wallpaper img{
    position: absolute;
    width: 100%;
    height: 100%;
    filter: brightness(0.4);
}
.wallpaper h1{
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: #fff;
    font-size: 3em;
    text-transform: uppercase;
    text-align: center;
}
</style>
@endsection