@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 1240px; margin: 20px auto;">
		@include('partial.error')
		<form class="ui form" action="" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		  <h2 class="ui dividing header">Search Registered Students Passport</h2>
		  <div class="four fields">
    		  <div class="field states">
                <label>State</label>
                <div class="ui fluid search selection dropdown" id="states-dropdown">
                  <input type="hidden" name="state_id" @if(!empty(old('state_id')))
                      value="{{old('state_id')}}"
                    @else
                      value="{{$ngstate->id}}"
                    @endif>
                  <i class="dropdown icon"></i>
                  <div class="default text">States</div>
                  <div class="menu">
                     <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
                  </div>
                </div>
              </div>
              <div class="field">
                <label>Local Govt Area.</label>
                <div class="ui fluid search selection dropdown" id="wrap-slgas">
                  <input type="hidden" name="lga_id" value="{{old('lga_id')}}" data-href="{{url('/do-ajax/school')}}">
                  <i class="dropdown icon"></i>
                  <div class="default text">Local Govt. Area</div>
                  <div class="menu" id="state-lga">
                    @foreach($ngstate_lgas as $ngstateLGA)
                     <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach
                  </div>
                </div>
              </div>
              <div class="field">
                <label>Batch Download Amount</label>
                <div class="ui fluid search selection dropdown">
                  <input type="hidden" name="amount" value="{{old('amount')}}" required>
                  <i class="dropdown icon"></i>
                  <div class="default text">Select Download Amount</div>
                  <div class="menu">
                    <div class="item" data-value="all">All</div>
                    <div class="item" data-value="50">50</div>
                    <div class="item" data-value="100">100</div>
                    <div class="item" data-value="150">150</div>
                    <div class="item" data-value="200">200</div>
                    <div class="item" data-value="250">250</div>
                    <div class="item" data-value="300">300</div>
                    <div class="item" data-value="350">350</div>
                    <div class="item" data-value="400">400</div>
                    <div class="item" data-value="450">450</div>
                    <div class="item" data-value="500">500</div>
                  </div>
                </div>
              </div>
              <div class="field">
                <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">Download Passports</button>
              </div>
		  </div>
		</form>
	</section>
@endsection