@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
	@include('partial.error')
	<form class="ui form" action="{{route('super_admin.news.create')}}" method="post">
		<input type="hidden" name="_token" value="{{csrf_token()}}">
		<input type="hidden" name="super_admin_id" value="{{auth('super_admin')->user()->id}}">
		  <h2 class="ui dividing header">Create News</h2>
		  <div class="three fields">
		      <div class="field">
		        <div class="ui input">
				  <input type="text" placeholder="Enter title..." name="title" required>
				</div>
		      </div>
			  <div class="field">
			    <textarea rows="2" placeholder="Write conten here..." name="content" required></textarea>
			  </div>
		      <div class="field">
		      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Make Post</button>
		      </div>
	    </div>
	  
	</form>
	<h2 class="ui horizontal divider header" style="color:#dc4900;">
	  <i class="student icon"></i>
	  Edit News
	</h2>
	<table class="ui celled table">
	  <thead>
	    <tr>
	    <th>
	    	<div class="ui ribbon label">S/N</div>
	    </th>
	    <th>
	    	<div class="ui ribbon label">Title</div>
	    </th>
	    <th>
	    	<div class="ui ribbon label">Content</div>
	    </th>
	    <th>
	    	<div class="ui ribbon label">Edit</div>
	    </th>
	    <th>
	    	<div class="ui ribbon label">Delete</div>
	    </th>
	  </tr>
	  </thead>
	  <tbody>
	 	@php $news = App\News::all(); @endphp
	 	@if($news->count() > 0)
	 	@foreach($news as $new)
			<tr>
				<form action="{{route('super_admin.news.edit')}}" method="POST">
					{{csrf_field()}}
					<input type="hidden" name="id" value="{{$new->id}}">
					<td>
						{{$new->id}}
					</td>
					<td>
						{{$new->title}}
						<div class="ui input fluid">
						  <input type="text" name="title" placeholder="Old: {{$new->title}}" required>
						</div>
					</td>
					<td>
						{{$new->content}}
						<div class="ui input fluid">
						  <input type="text" name="content" placeholder="Old: {{$new->content}}" required>
						</div>
					</td>
					<td>
						<button class="ui labeled icon button blue">
						  <i class="edit icon"></i>
						  Edit
						</button>
					</td>
				</form>
				<form action="{{route('super_admin.news.delete')}}" method="POST">
					{{csrf_field()}}
					<input type="hidden" name="id" value="{{$new->id}}">
					<td>
						<button class="ui labeled negative icon button red">
						  <i class="trash icon"></i>
						  Delete
						</button>
					</td>
				</form>
		    </tr>
	 	@endforeach
	 	@else
			<tr>
				<th colspan="7">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Post found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
	 	@endif
	  </tbody>
	  <tfoot>
	  </tr></tfoot>
	</table>
</section>
@endsection