@extends('layouts.main')
@section('content')
@include('partial.error')
<section class="ui middle aligned center aligned grid">
    @if(isset($username) && isset($password))
    <div class="column" style="max-width: 450px;">
        <h2 class="ui orange image header">
          <img src="{{url_public('/images/header-logo.png')}}" class="image">
          <div class="content">
            Verify Account Phone Number
          </div>
        </h2>
        <form class="ui large form" action="{{route('super_admin.login')}}" method="post">
            <input type="hidden" name="_token" value="{{csrf_token()}}">
            <input type="hidden" name="username"  value="{{$username}}">
            <input type="hidden" name="password"  value="{{$password}}">
            <div class="ui stacked segment">
                <div class="field">
                  <div class="ui left icon input">
                    <i class="phone icon"></i>
                    <input type="number" required name="phone" placeholder="Enter Last 4 Digit In Phone Number">
                  </div>
                </div>
                <button class="ui fluid large orange submit button" type="submit">Continue Login</button>
            </div>
        </form>
   </div>
    @else
    <div class="column" style="max-width: 450px;">
        <h2 class="ui orange image header">
          <img src="{{url_public('/images/header-logo.png')}}" class="image">
          <div class="content">
            Ministry Adminstrator Log-in to your account
          </div>
        </h2>
        <form class="ui large form" action="{{route('super_admin.login')}}" method="post">
            <input type="hidden" name="_token" value="{{csrf_token()}}">
            <div class="ui stacked segment">
                <div class="field">
                  <div class="ui left icon input">
                    <i class="user icon"></i>
                    <input type="text" name="username" placeholder="Enter Username"  value="{{old('username')}}">
                  </div>
                </div>
                <div class="field">
                  <div class="ui left icon input">
                    <i class="lock icon"></i>
                    <input type="password" name="password" placeholder="Enter Password">
                  </div>
                </div>
                <button class="ui fluid large orange submit button" type="submit">Login</button>
            </div>
        </form>
    
        <div class="ui message">
          Having issue with your password ? <a href="{{route('super_admin.password.email')}}">Reset Password</a>
        </div>
   </div>
   @endif
</section>
@endsection
