@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 90%; margin: 20px auto;">
		@include('partial.error')
		@include('partial.flash-error')
		<div class="ui yellow message">
          <i class="close icon"></i>
          <div class="header">
            Notice
          </div>
          <p>Actions cannot be undone!</p></div>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="users icon"></i>
		  All Ministry Users
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Admin's Details</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Email Address</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Phone Number</div>
		    </th>
			<th>
		    	<div class="ui ribbon label">Status</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Login Count</div>
		    </th>
		    <th >
		    	<div class="ui toggle checkbox check-all">
					<input type="checkbox" class="">
					<label>Select All</label>
				</div>
		    </th>
		  </tr>
		  </thead>
		  <tbody>
		  	<form class="ui form" action="{{route('super_admin.login-reset')}}" method="post">
                <input type="hidden" name="_token" value={{csrf_token()}}>
            @php $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $admins->perPage() @endphp
		  	@forelse($admins as $admin)
		    <tr>
		      <td>{{++$counter}}</td>
		      <td>{{$admin->fullname}} <br> <small>{{'@'.$admin->username}}</small></td>
		      <td>{{$admin->email}}</td>
		      <td>{{substr($admin->phone, 0, -4)}} @if($admin->phone != '') **** @endif</td>
		      <td>
		          @if($admin->status == 1 && $admin->phone == '' && $admin->login_count >= 5)
		            <div class="ui purple message">
                      <p>Phone number not updated & max login attempt reached</p>
                    </div>
		          @elseif($admin->status == 1 && $admin->phone != '' && $admin->login_count >= 5)
		            <div class="ui green message">
                      <p>Password & phone number updated</p>
                    </div>
		          @elseif($admin->status != 1 && $admin->phone == '' && $admin->login_count >= 5)
		            <div class="ui red message">
                      <p>Profile not updated & max login attempt reached</p>
                    </div>
		          @else
		            <div class="ui message">
                      <p>Max login attempt not reached</p>
                    </div>
		          @endif
		      </td>
		      <td>{{$admin->login_count}}</td>
		      <td class="std-view">
			     <div class="ui toggle checkbox studentID">
					<input type="checkbox" name="admin_id[]" class="formCheckbox" value="{{$admin->id}}" @if(!empty(old('admin_id'))){{in_array($admin->id, old('admin_id')) ? 'checked="checked"' : ''}}@endif><label></label>
				</div>
			  </td>
		    </tr>
		    
		   @empty
			<tr>
				<th colspan="7">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endforelse
		  @if($admins->count() > 0)
		  <tr>
            <td colspan="7">
                <button class="ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;padding: 10px !important;">Reset Selected Admin's Login Attempt</button>
            </td>
		  </tr>
		  @endif
		  </form>
		  </tbody>
		  <tfoot>
		    <tr><th colspan="7">
		     @include('pagination.default', ['paginator' => $admins])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
@endsection