@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
		@include('partial.error')
		@include('partial.flash-error')
		<div class="ui yellow message">
          <i class="close icon"></i>
          <div class="header">
            Popups Usage Alert
          </div>
          <p>Please we require you enable popups for this page
        </p></div>
		<form class="ui form cardForm" action="{{route('super_admin.view.student-for-id-card.post')}}" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		  <h2 class="ui dividing header">Search Student For ID Card Generation</h2>
		  <div class="three fields">
		  <div class="field states">
            <label>State</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" @if(!empty(old('state_id')))
                  value="{{old('state_id')}}"
                @else
                  value="{{$ngstate->id}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
              </div>
            </div>
          </div>
          <div class="field" id="field-lga">
            <label>Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="{{old('lga_id')}}" data-href="{{url('/do-ajax/school')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Local Govt. Area</div>
              <div class="menu" id="state-lga">
                @foreach($ngstate_lgas as $ngstateLGA)
                 <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                @endforeach
              </div>
            </div>
          </div>

          <div class="field" id="field-school">
            <label>School</label>
            <div class="ui fluid search selection dropdown" id="wrap-schools">
              <input type="hidden" name="school" value="{{old('school')}}" data-href="{{url('/do-ajax/classes')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Schools</div>
              <div class="menu" id="school-options-handler">
                @if(!empty(old('school')))
                    @foreach(getSchools(old('school')) as $school)
                     <div class="item" data-value="{{$school->id}}">{{$school->name}}</div>
                    @endforeach
                  @else
                     <div class="item" data-value="">Schools</div>
                  @endif
              </div>
            </div>
          </div>
		  </div>
		  <div class="five fields">
	      <div class="field">
	        <label>Session</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="session" value="{{old('session')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Session</div>
	          <div class="menu">
	            @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
	             <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
	            @endfor
	          </div>
	        </div>
	      </div>
	      <div class="field">
	        <label>Term</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="term" value="{{old('term')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Term</div>
	          <div class="menu">
	             <div class="item" data-value="First"> First Term </div>
	             <div class="item" data-value="Second"> Second Term </div>
	             <div class="item" data-value="Third"> Third Term </div>
	          </div>
	        </div>
	      </div>
	      
	      <div class="field" id="field-class">
	        <label>Class</label>
	        <div class="ui fluid search selection dropdown" id="classes-dropdown">
	          <input type="hidden" name="class_id" value="{{old('class_id')}}" data-href="{{url('/do-ajax/class')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Class</div>
	          <div class="menu" id="class-options-handler">
	            @if(!empty(old('school')))
	                @foreach(getClasses(old('school')) as $class)
	                 <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
	                @endforeach
	              @else
	                 <div class="item" data-value="">Select Class</div>
	              @endif
	            
	          </div>
	        </div>
	      </div>
	      <div class="field" id="field-arms">
	        <label>Class Arm</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="class_arm_id" value="{{old('class_arm_id')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Class Arm</div>
	          <div class="menu" id="class-arms">
	            @if(!empty(old('class_id')))
	                @foreach(getClassArms(old('class_id')) as $class_arm)
	                 <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
	                @endforeach
	              @else
	                 <div class="item" data-value="">Select Class Arm</div>
	              @endif
	            
	          </div>
	        </div>
	      </div>
	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Students For ID Card Generation</button>
	      </div>

	    </div>
		  
		</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  Students For School ID Card Generation
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">OSSI Number</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student's ID Card</div>
		    </th>
			<th>
		    	<div class="ui ribbon label">Expiry Date</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">School</div>
		    </th>
		    <th >
		    	<div class="ui toggle checkbox check-all">
					<input type="checkbox" class="">
					<label>Select All</label>
				</div>
		    </th>
		  </tr>
		  </thead>
		  <tbody>
		  	<form class="ui form" action="{{route('super_admin.generate.student-school-id-card')}}" method="post">
			@include('pagination.hidden-input-post')
		  	@forelse($students as $student)
		    <tr>
		      <td>{{++$counter}}</td>
		      <td>{{$student->surname.' '.$student->firstname.' '.$student->middlename}}</td>
		      <td>{{$student->regnum}}</td>
			@if(count(getStudentIDCard($student->id)) > 0)
		      <td>
		      <a class="ui small image" href="{{route('super_admin.download.student-idcard', ['id' => $student->id])}}" target="_blank">
			      <div class="ui dimmer">
				    <div class="content">
				      <div class="center">
				        <h2 class="ui inverted header"></h2>
				        <div class="ui orange button idcarDownloadBtn">Download ID Card</div>
				      </div>
				    </div>
				  </div>
			      <img src="{{url_public(getStudentIDCard($student->id)->id_card)}}" class="ui small image">
			    </a>
		      <td>{{getIDCardExpDate($student->school_id)}}</td>
		    @else
	    	<td colspan="2">
	    		<p>Student ID card has not been generated</p>
	    	</td>
		    @endif
		      <td>{{getSchoolName($student->school_id)}}</td>
		      <td class="std-view">
		     @if($student->passport !== '/images/passports/no_img_da88a72526.gif')
			     <div class="ui toggle checkbox studentID">
					<input type="checkbox" name="student_id[]" class="formCheckbox" value="{{$student->id}}" @if(!empty(old('student_id'))){{in_array($student->id, old('student_id')) ? 'checked="checked"' : ''}}@endif><label></label>
				</div>
			@else
				<p>No passport</p>
			@endif
			  </td>
		    </tr>
		    
		   @empty
			<tr>
				<th colspan="7">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endforelse
		  @if($students->count() > 0)
		  <tr>
		    	<td colspan="7">
						<button class="ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;padding: 10px !important;">Generate Student ID Card</button>
		    		<button class="cardDownloadBtn ui button blue" type="button" style="color:white;margin-top:24px;padding: 10px !important;">Download Selected ID Cards</button>
		    	</td>
		    </tr>

		  @endif
		  </form>
		  </tbody>
		  <tfoot>
		    <tr><th colspan="7">
		     @include('pagination.post-default', ['paginator' => $students, 'post_data' => $data])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
    <script>
	$(document).ready(function(){
		$('.cardDownloadBtn').click(function(){
			var btn = $(this);
			btn.attr('disabled', 'disabled');
			 $('input[type=checkbox].formCheckbox').each(function(){
				 if($(this).is(':checked')){
						var parent = $(this).parents("tr:first");
						setTimeout(() => {
							parent.find('.idcarDownloadBtn').trigger('click');
						}, 3000);
				 }
			 });
			 btn.removeAttr('disabled')
		});
	});
	</script>
@endsection