@extends('layouts.main')
@section('content')
<style>
    .preview__holder{
        height: 10px;
        visibility: hidden;
        overflow: hidden;
    }
    .student_idcard{
        position: relative !important;
	    margin: 15px 0px !important;
	    width: 950px;
	    height: 484px;
    }
    .student_idcard .status.downloaded{
        background: #21ba45;
        color: #fff;
        z-index: 1233345679 !important;
        position: absolute;
        top: 0px;
        left: 0px;
        padding: 10px 20px;
    }
    .student_idcard .status.not_downloaded{
        background: red;
    }
    /*junior*/
    /*.id__card.junior{
        pointer-events: none;
		position: absolute;
	    top: 0%;
	    left: 0%;
	    right: 0%;
	    overflow: hidden;
	    bottom: 0%;
	    width: 100%;
	    height: 100%;
	    border-radius: 4px;
	    border: 5px solid #dc4901;
	    padding: 0px !important;
	}
	.id__card.junior .cover_one{
		position: absolute;
	    top: 0px;
	    left: -100px;
	    bottom: 0px;
	    right: 150px;
	    background: #f9f90163;
	    border-radius: 50%;
        border-top-left-radius: 0px !important;
        border-bottom-left-radius: 0px !important;
	    background: linear-gradient(45deg, #f9f90163, #f9f901a8);
		z-index: 2px !important;
	}
	.id__card.junior .cover_two{
		position: absolute;
        bottom: -170px;
        left: -170px;
        height: 250px;
        width: 250px;
        background: #f055097a;
        border-radius: 50%;
		z-index: 2px !important;
	}*/
	/*senior*/
    .id__card.senior{
        pointer-events: none;
		position: absolute;
	    top: 0%;
	    left: 0%;
	    right: 0%;
	    overflow: hidden;
	    bottom: 0%;
	    width: 100%;
	    height: 100%;
	    border-radius: 4px;
	    border: 5px solid #dc4901;
	    padding: 0px !important;
	}
	.id__card.senior .cover_one{
		position: absolute;
	    top: 0px;
	    left: 0px;
	    bottom: 0px;
	    right: 0px;
	    background: linear-gradient(45deg, #fff, #ffffff14);
	    z-index: 2px !important;
	    background-size: 55% 34% !important;
	    background-position: 122% 80% !important;
	    background-color: #fff !important;
	    background-repeat: no-repeat !important;
	    transform: rotate(-10deg);
	}
	.id__card.senior .cover_two{
		position: absolute;
        bottom: -170px;
        left: -170px;
        height: 250px;
        width: 250px;
        background: #9e9e9e14;
        border-radius: 50%;
		z-index: 2px !important;
	}
	.id__card .main{
		position: absolute;
		top: 0px;
		left: 0px;
		right: 0px;
		bottom: 0px;
		z-index: 2px !important;
		/*padding: 0px 50px;*/
	}
	.id__card .header{
		display: flex;
		justify-content: center;
		align-content: center;
		background: #dc4901;
		padding: 10px 10px;
		margin-bottom: 4px;
	}
	.id__card .header_bottom{
		background: #dc4901;
		padding: 3px;
	}
	.id__card .header .ods_logo{
		padding: 10px 15px;
	    background: #fff;
	    border-radius: 5px;
	}
	.id__card .header .ods_logo img{
		width: 140px;
		height: 100px;
	}
	.id__card .header .school_logo{
		padding: 10px 15px;
	    background: #fff;
	    border-radius: 5px;
	}
	.id__card .header .school_logo img{
		width: 130px !important;
		height: 100px !important;
	}
	.id__card .header .title{
		padding: 0px 10px 0px 10px;
		text-align: center;
	}
	.id__card .header .title h1{
		font-size: 25px;
		color: #f7f7f7;
		text-transform: uppercase;
		word-break: keep-all;
		margin-bottom: 0px;
	}
	.id__card .header .title p{
		font-size: 15px;
		color: #f7f7f7;
		text-transform: uppercase;
		word-break: keep-all;
	}

	/*content*/
	.id__card .content{
		padding: 15px 50px;
		display: flex;
		justify-content: center;
	}
	.id__card .content .user_details{
		flex: 3;
		padding-left: 10px;
	}
	.id__card .content .user_details .form_input.row{
		display: flex;
		justify-content: flex-start;
	}
	.id__card .content .user_details .form_input .title{
		font-size: 20px !important;
        color: #000;
        align-self: flex-end;
        padding-right: 10px;
        flex: none;
        font-weight: 700 !important;
        text-transform: uppercase !important;
    }
	.id__card .content .user_details .form_input .line{
	    font-size: 21px !important;
        text-transform: capitalize !important;
        width: 100%;
        color: #000;
        /* border-bottom: 1px solid #333; */
        padding: 5px 19px 0px 0px;
        font-weight: 900 !important;
	}
	.id__card .content .user_photo{
		flex: 1;
		padding-right: 10px;
		align-self: center;
	}
	.id__card .content .user_photo img{
		width: 200px;
		height: 180px;
		border-radius: 8px;
	    border: 6px solid #dc4901;
	    background-color: #fffa;
	}
	.id__card .footer{
	    margin-top: 15px;
		padding: 10px 0px;
		border-top: 5px solid #dc4901;
		border-bottom: 5px solid #dc4901;
	}
	.id__card .footer div{
	    width: 100%;
	    text-align: center;
		text-transform: capitalize;
		font-size: 25px;
		padding: 10px;
		color: #f7f7f7;
		background: #dc4901;
	}
	.form_row{
		display: inline-flex;
		justify-content: space-between;
	}
	.form_row .form_input{
		flex: 1;
	}
</style>
<section class="ui raised segment" style="max-width: 1200px; margin: 20px auto;box-shadow: 0px 0px 0px transparent !important;border-style: none !important;">
    <div class="ui yellow message">
    	<i class="close icon"></i>
    	<div class="header">
    		Multiple Download Alert!
    	</div>
    	<p>
    		Please allow multiple download to use this feature
    	</p>
    </div>
	@forelse($students as $student)
	@php
	    $student_current_class = DB::table('classarm_student')
                                ->where('student_id', $student->id)
                                ->orderBy('session', 'desc')
                                ->first();
        $student_voucher = App\ResultVoucher::where('student_id', '=', $student->id)
            ->where('session', '=', $student_current_class->session)
            ->where('class_id', '=', $student_current_class->class_id)
            ->where('classarm_id', '=', $student_current_class->classarm_id)
            ->get()->first();
        $payment = App\DigitalPayment::where('student_id', $student->id)->get()->first();
        $request = App\StudentIDCardRequest::where('student_id', $student->id)
                ->where('school_id', $student->schools->id)
                ->where('is_verified', true)
                ->get()->first();
	@endphp
	<div class="student_idcard" data-regnum="{{$student->regnum}}" data-id="{{$student->id}}" data-url="{{route('super_admin.school.id-card-request-download', ['id' => $student->id, 'school_id' => $student->schools->id])}}">
	    @if($request && $request->is_downloaded == true)
	    <div class="printnone status downloaded">Downloaded</div>
	    @endif
    	<div class="id__card @if(strtolower(getClassNameByClassID($student_current_class->class_id)[0]) == 'j') senior @endif @if(strtolower(getClassNameByClassID($student_current_class->class_id)[0]) == 's') senior @endif">
    	    <div style="">
        		<div class="cover_one"></div>
        		<div class="cover_two"></div>
        		<div class="main">
        			<div class="header">
        				<div class="ods_logo">
        					<img src="{{url_public('/images/header-logo.png')}}">
        				</div>
        				<div class="title">
        					<h1>Ondo State Ministry of Education <br> Science and Technology</h1>
        				</div>
        				<div class="school_logo">
        					<img src="{{url_public($school->logo)}}">
        				</div>
        			</div>
        			<div class="header_bottom"></div>
        			<div class="content">
    					<div class="user_photo">
    						<img src="{{url_public($student->passport)}}">
    					</div>
        				<div class="user_details">
        					<div class="form_input">
        						<div class="title">
        							FULLNAME
        						</div>
        						<div class="line">{{$student->surname}} {{$student->firstname}} {{$student->middlename}}</div>
        					</div>
        					<br>
        					<div class="form_input">
        						<div class="title">
        							ONDO STATE STUDENT IDENTIFICATION NUMBER (0SSIN)
        						</div>
        						<div class="line">{{$student->regnum}}</div>
        					</div>
        					<br>
        					<div class="form_row">
	        					<div class="form_input">
	        						<div class="title">
	        							CLASS:
	        						</div>
	        						<div class="line">
	        						    @if(strtolower(getClassNameByClassID($student_current_class->class_id)[0]) == 'j')
	        						    JUNIOR
	        						    @elseif(strtolower(getClassNameByClassID($student_current_class->class_id)[0]) == 's')
	        						    SENIOR
	        						    @else
	        						    @endif
	        						</div>
	        					</div>
	        					<div class="form_input" style="margin-left:3em;">
	        						<div class="title">
	        							GENDER:
	        						</div>
	        						<div class="line">{{$student->gender}}</div>
	        					</div>
	        				</div>
	        				<br><br>
        					<div class="form_input row">
        						<div class="title">
        							P/G MOBILE:
        						</div>
        						<div class="line">{{$student->parent_phone}}</div>
        					</div>
        				</div>
    				</div>
    				<div class="footer">
    				    <div>{{$school->name}}</div>
    				</div>
        		</div>
        	</div>
    	</div>
	</div>
	@empty
	<div class="ui icon negative message">
	  <i class="info circle icon"></i>
	  <div class="content">
	    <div class="header">
	    Sorry, No Reciept found.
	  	</div>
	  </div>
	</div>
	@endforelse
	<div class="preview__holder"></div>
	<div class="ui primary button printnone" onclick="printCards(this);">
      Dowonload ID Card
      <i class="print icon"></i>
    </div>
</section>
<style>
.ext{
    width: 100% !important;
}
.ext .card{
    width: 100% !important;
}
.ext .card .item{
    text-align: left;
    padding: 13px;
}
.ext .card .content{
    text-align: right;
    float: right;
}
</style>
<script>
// $(document).ready(function(){
	
// var element = $(".asdgnfsgdafs")[0]; // global variable
// var getCanvas; // global variable
 
//     $("#btn-Preview-Image").click(function(){
// 	    html2canvas(element, {
// 	        onrendered: function(canvas) {
// 				$('.preview__holder').prepend(canvas);
//                 var dataURL = canvas.toDataURL();
//                 var newData = dataURL.replace(/^data:image\/png/, "data:application/octet-stream");
//                 $("#btn-Convert-Html2Image").attr("download", "your_pic_name.png").attr("href", newData);
//                 $("#btn-Convert-Html2Image").trigger('click');
//         		console.log(dataURL);
// 	        }
//       });
//     });

// // 	$("#btn-Convert-Html2Image").on('click', function () {
// //     var imgageData = getCanvas.toDataURL("image/png");
// //     // Now browser starts downloading it instead of just showing it
// //     var newData = imgageData.replace(/^data:image\/png/, "data:application/octet-stream");
// //     $("#btn-Convert-Html2Image").attr("download", "your_pic_name.png").attr("href", newData);
// // 	});

// });

function printCards(obj) 
{
    var btn = $(obj);
    var oldBtn = btn.html();
    var idCard = $(".student_idcard");
    btn.html('Downloading...');
    btn.css('pointer-events', 'none');
    idCard.each(function(){
        var card = $(this);
        var cardUrl = card.attr('data-url');
        card.find('.printnone').each(function(){
            $(this).fadeOut();
        });
    	// to canvas
    	html2canvas(card.get(0)).then(function(canvas) {
    		// canvas width
    		var canvasWidth = canvas.width;
    		// canvas height
    		var canvasHeight = canvas.height;
    		// render canvas
    		// convert canvas to image
    		var img = Canvas2Image.convertToImage(canvas, canvasWidth, canvasHeight);
    		// render image
    		$('.preview__holder').prepend(img);
    		// save
    		let type = 'jpg'; // image type
    		let w = $('#imgW').val(); // image width
    		let h = $('#imgH').val(); // image height
    		let f = card.attr('data-regnum'); // file name
    		w = (w === '') ? canvasWidth : w; 
    		h = (h === '') ? canvasHeight : h;
    		// save as image
    		Canvas2Image.saveAsImage(canvas, w, h, type, f);
            // btn restore
            btn.html(oldBtn);
            btn.css('pointer-events', 'all');
            // update download status foreach...
            $.ajax({
                url: cardUrl,
                type: 'GET',
                success: function(res){
                    if(res.message && res.message == true){
                        card.append('<div class="printnone status downloaded">Downloaded</div>');
                    }
                },
                error: function(res){
                    //
                }
            });
            
            card.find('.printnone').each(function(){
                $(this).fadeIn();
            });
    	});
    });
}
</script>
@endsection