@extends('layouts.main-datatable')
@section('content')   


<style>
.ui.celled.table tr th, .ui.celled.table tr td {
	font-size: 14px;
}
</style> 

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="" method="post">
  <h2 class="ui dividing header">All FAQ</h2>

		<table class="ui celled table" id="global_datatable">
		  <thead>
		    <tr>
            <th width="5%">S/N</th>
            <th>Title</th>
            <th width="15%">View</th>
		    <th width="6%">
		    	<div class="ui ribbon label">Delete</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if(count($data_list) > 0)
		  	@php
		  	$sn = 1
		  	@endphp
				@foreach($data_list as $data)
				<tr>
					<td>{{$sn}}</td>
					<td>{{$data->title}}</td>
					<td><a href="{{route('faq.read', ['id' => $data->id])}}"> Click to Read </td>
					<td>
					@if(auth('super_admin')->user()->can('delete-faq'))
						<a onclick="return confirm('Are you sure you want to delete this data completely?')" href="{{route('super_admin.faq.delete.post', ['id' => $data->id])}}"> <img src="{{url_public('/images/remove.png')}}"> 
					@endif
					</td>
				</tr>
				@php
				$sn++
				@endphp
				@endforeach
		   @else
			<tr>
				<td colspan="4">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record was found.
					  	</div>
					  </div>
					 </div>
				</td>
			</tr>
		  @endif
		  </tbody>
		</table>



  
</form>
   
</section>

<div class="jtr"></div>

@endsection	