@extends('layouts.main')

@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">

		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  Generate Examination Scratch Card
		</h2>
	@if(auth('super_admin')->user()->can('create-scratch-card'))
		@include('partial.error')
	  <form action="{{route('super_admin.generate.exam_scratch_card')}}" method="post" class="ui form">
		<div class="four fields">
		{{csrf_field()}}
	      
	      <div class="field">
	        <label>Number of Scratch Card</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="iteration" value="{{old('iteration')}}"  >
	          <i class="dropdown icon"></i>
	          <div class="default text">Select Number of Scratch Card</div>
	          <div class="menu">
	            @foreach($iterations as $iteration)
	             <div class="item" data-value="{{$iteration}}">{{$iteration}}</div>
	            @endforeach
	          </div>
	        </div>
	      </div>

	      <div class="field">
	        <label>Exam Card</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="exam_type" value="{{old('exam_type')}}"  >
	          <i class="dropdown icon"></i>
	          <div class="default text">Select Exam Type</div>
	          <div class="menu">
	            @foreach($exam_types as $exam_type)
	             <div class="item" data-value="{{str_replace(' ', '_', strtolower($exam_type))}}">{{$exam_type}}</div>
	            @endforeach
	          </div>
	        </div>
	      </div>

	      <div class="field">
	        <label>Number of students for a card </label>
	        <input type="number" name="multiple" value="{{old('multiple')}}" placeholder="Number of Student per Card">
	      </div>

	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white; margin-top:24px;">Generate Exam Scratch Cards</button>
	      </div>
	     </div>
	    </form>
	 @endif
	   <form action="{{route('super_admin.delete.exam_scratch_card')}}" method="post" class="ui form">
	   {{csrf_field()}}
	   <input type="hidden" name="_method" value="delete">
		<table class="ui celled table">
		  <thead>
		    <tr>
			    <th>
			    	S/N
			    </th>
			    <th>
			    	Serial Number
			    </th>
			    <th>
			    	Pin
			    </th>
			    <th>
			    	Exam Number
			    </th>
			    <th>
			    	Exam Type
			    </th>
			    <th>
			    	Students per Card
			    </th>
			    <th >
			    	Select Cards
			    	<div class="ui toggle checkbox check-all">
						<input type="checkbox" class="">
						<label>Select All</label>
					</div>
			    </th>
			 </tr>
		  </thead>
		  <tbody>
		  @php $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $vouchers->perPage() @endphp
		  	@forelse($vouchers as $voucher)
		    <tr>
		      <td>{{++$counter}}</td>
		      <td>{{$voucher->serial}}</td>
		      <td>{{$voucher->pin}}</td>
		      @if($voucher->regnum !== NULL)
				<td>{{$voucher->regnum}}</td>	
		      @else
		      <td>{{ empty($voucher->school_id) || $voucher->school_id === NULL ? 'Not Used' : $voucher->school->name}}</td>
		      @endif
		      <td>{{str_replace('_', ' ', ucwords($voucher->exam_type))}}</td>
		      <td>{{$voucher->multiple}}</td>
		      <td class="std-view">
			     <div class="ui toggle checkbox studentID">
					<input type="checkbox" name="scratch_cards[]" value="{{$voucher->id}}"><label></label>
				</div>
			  </td>
		    </tr>
		   @empty
			<tr>
				<th colspan="7">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endforelse
		  </tbody>
		  <tfoot>
		  @if($vouchers->count() > 0 && auth('super_admin')->user()->can('delete-scratch-card'))
		  	<tr>
		  		<td colspan="7"><button class="fluid ui disabled scratch-card button" type="submit" style="background-color: #f75a0c; color:white;">Delete Scratch Cards</button></td>
		  	</tr>
		  @endif
		  	<tr>
		  		<td colspan="7">
		  			@include('pagination.default', ['paginator' => $vouchers])
		  		</td>
		  	</tr>
		  </tfoot>
		</table>
		
	</form>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
@endsection