@extends('layouts.main')
@section('content')
	<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
		@include('partial.error')
		<form class="ui form" action="" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		  <h2 class="ui dividing header">Batch Teacher Registration</h2>
		  <div class="three fields">
	      <div class="field">
	        <label>Session</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="session" value="{{old('session')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Session</div>
	          <div class="menu">
	            @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
	             <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
	            @endfor
	          </div>
	        </div>
	      </div>

	      <div class="field">
		      	<label>File Upload</label>
		      	<div class="ui right action input">
				  <input type="text" class="pseudo-batch-file-name" name="pseudo_batch_file_name" >
				  <button type="button" class="ui orange labeled icon button pseudo-batch-file">
				    <i class="file excel outline icon"></i>
				    Upload Excel File
				  </button>
				</div>
        		<input type="file" name="batch_file" id="batch_file" class="batch-file" style="display: none">
		   </div>
			
			<div class="field">
		      <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:22.5px;">Batch Register Teachers</button>
		  </div>

	    </div>

		  
		  
		</form>
	</section>
@endsection