@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="" method="post">
  <h2 class="ui dividing header">Class Registration</h2>
  <div class="field">
    <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
    <input type="hidden" name="_method" value="put">
    
    <div class="three fields">
      <div class="disabled field">
        <label>Class</label>
        <input type="hidden" name="class_id" @if(!empty(old('class_id')))
          value="{{old('class_id')}}"
        @else
          value="{{$classarm->class_id}}"
        @endif >
        <input placeholder="{{getClassNameByClassID($classarm->class_id)}}" type="text" disabled="" tabindex="-1">
      </div>
      <div class="field">
      <label>Class Arm Name</label>
        <input type="text" name="class_arm_name" @if(!empty(old('class_arm_name')))
          value="{{old('class_arm_name')}}"
        @else
          value="{{$classarm->class_arm}}"
        @endif placeholder="Class Name">
      </div>
      <div class="field">
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white; margin-top:22.5px;">Update Class Arm</button>
      </div>
    </div>
  </div>
</form>
<h2 class="ui dividing header">Available Classes and Class Arms</h2>
@if($all_classarms->count() > 0)
  <div class="ui tag labels">
  @foreach($all_classarms as $key => $classarm)
  <a class="ui {{getDynamicColorByKey($key)}} label">
    {{getClassNameByClassID($classarm->class_id)}} {{$classarm->class_arm}}
  </a>

  @endforeach
</div>
@else
@endif
</section>
<div class="jtr"></div>
@endsection