@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="" method="post">
  <h2 class="ui dividing header">Assign Teacher To Class</h2>
  <div class="field">
    <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
    <input type="hidden" name="_method" value="put">
    
    <div class="four fields">
      <div class="disabled field">
        <label>Class</label>
        <input type="hidden" name="class_id" @if(!empty(old('class_id')))
          value="{{old('class_id')}}"
        @else
          value="{{$classarm->class_id}}"
        @endif data-href="{{url('/do-ajax/class')}}" >
        <input placeholder="{{getClassNameByClassID($classarm->class_id)}}" type="text" disabled="" tabindex="-1">
      </div>
      <div class="disabled field">
        <label>Class Arm</label>
        <input type="hidden" name="class_arm_id" @if(!empty(old('class_arm_id')))
          value="{{old('class_arm_id')}}"
        @else
          value="{{$classarm->id}}"
        @endif >
        <input placeholder="{{$classarm->class_arm}}" type="text" disabled="" tabindex="-1">
      </div>
      <div class="field">
        <label>Assign Teacher</label>
         <select multiple="" class="ui dropdown" name="teachers[]" >
            <option>Select multiple subject areas</option>
          @if(!empty(old('all_teachers')) )
             @foreach($all_teachers as $teacher)
              <option  value="{{$teacher->id}}" 
              @if(in_array($teacher->id, old('teachers')))
                  selected="selected"
              @endif
              >{{$teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename}}</option>
             @endforeach
          @else
              @foreach($all_teachers as $teacher)
              <option  value="{{$teacher->id}}" 
              @if(in_array($teacher->id, $assign_teachers))
                  selected="selected"
              @endif
              >{{$teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename}}</option>
             @endforeach
          @endif
         </select>
      </div>
      
      <div class="field">
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white; margin-top:22.5px;">Update Assigned Teacher to Class</button>
      </div>
    </div>
  </div>
</form>
</section>
<div class="jtr"></div>
@endsection